
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

void
print_usage (char *progname);


void
print_usage (char *progname)
{
    printf ("%s [-g <debug domains>] [-hmp]\n", progname);
}

int main (int argc, char **argv)
{
    RBuf *buf;
    RBuf *buf2;
    int i, a;
    int test_rmdbg = FALSE;
    char *domains;

    rinit ();

    RARGV_SWITCH {
        case 'm':
            test_rmdbg = TRUE;
            break;

        case 'h':
            print_usage (argv[0]);
            exit (0);
            break;

        case 'p':
            printf ("Hello world!\n");
            break;

        case 'g':
            domains = RARGV_NEXT;
            if (domains == NULL) {
                printf ("Argument expected for -g\n");
                print_usage (argv[0]);
                exit (0);
            }
            rdebug_enable (domains);
            printf ("Enabled debug for domains: '%s'\n", domains);
            break;

        case '*':
            printf ("Unexpected argument: '%s'\n", RARGV_CURRENT);
            print_usage (argv[0]);
            exit (0);
            break;
            
        default:
            printf ("Unknown flag: -%c\n", RARGV_CURRENT_FLAG);
            print_usage (argv[0]);
            exit (0);
            break;

    } RARGV_CLOSE;

    buf = rbuf_new_with_str ("x");
    rbuf_append_char (buf, ',');
    rbuf_append_str (buf, "y");
    rbuf_append_rbuf (buf, buf);

    rbuf_own (buf);

    /* rbuf_free () on an owned buf is a NOP */
    rbuf_free (buf);

    printf ("buf is %s\n", rbuf_str (buf));

    if (rbuf_owned (buf)) {
        buf2 = rbuf_new_with_rbuf (buf);
    } else {
      printf ("Somehow, owner information was lost. aborting.\n");
      exit (1);      
    }
    

    for (i = 0; i < 10; i++) {
        rbuf_append_rbuf (buf2, buf);
        rbuf_append_char (buf2, '\n');
    }

    rbuf_release (buf);
    rbuf_free (buf);
    printf ("buf2 is:\n%s", rbuf_str (buf2));
    rbuf_free (buf2);

    buf = rbuf_new_with_str ("H");
    buf2 = rbuf_new_with_str ("Hello");
    rbuf_truncate (buf2, 1);

    printf ("buf1 is '%s', buf2 is '%s'\n", rbuf_str (buf),
        rbuf_str (buf2));

    if (!rbuf_equal_rbuf (buf, buf2)) {
        printf ("uh oh, buf should equal buf2!\n");
    }

    rbuf_free (buf);
    rbuf_free (buf2);

    buf = rbuf_new_with_static ("Hello");

    printf ("(you should see 2 warnings below..)\n");
    rbuf_append_str (buf, " again");
    rbuf_set_rdwr (buf);
    rbuf_append_str (buf, " again");

    rbuf_free (buf);

    for (i = 0; i < 1000000; i++) {
        buf = rbuf_auto ("Hmmm...");
        if (rbuf_equal_rbuf (buf, rbuf_auto ("Hmmm I don't think so"))) {
            printf ("ACK! rbuf_auto foobared somehow\n");
        }
    }

    buf = rbuf_new_with_long (75123);
    printf ("long of 75123 comes out as %ld, or in text, %s\n", rbuf_long (buf), rbuf_str (buf));
    rbuf_free (buf);

    buf = rbuf_new_with_long (-12451);
    printf ("long of -12451 comes out as %ld, or in text, %s\n", rbuf_long (buf), rbuf_str (buf));
    rbuf_append_char (buf, '0');
    printf ("after appending '0': %s\n", rbuf_str (buf));
    rbuf_free (buf);

    /* This is to test rmdbg */
    if (test_rmdbg) {
        buf = rbuf_new_with_str ("foo");
        buf = rbuf_new ();
        buf = rbuf_new ();
        buf = rbuf_new ();
        /* Free with inappropriate function */
        rmem_free (buf);
        /* double free's */
        rbuf_free (buf);
        rbuf_free (buf);
    }

    for (a = 0; a < 1000; a++) {
        buf = rbuf_new ();
        for (i = 0; i < 50000; i++) {
            rbuf_append_char (buf, 'c');
        }
        rbuf_truncate (buf, 0);
        rbuf_free (buf);
    }

    buf = rbuf_new_with_str ("Hello");
    if (!rbuf_equal_rbuf_len (buf, rbuf_auto ("Hel"), 3))
        printf ("FAILED: 1st rbuf_equal_rbuf_len compare\n");
    
    if (rbuf_equal_rbuf_len (buf, rbuf_auto ("Hel"), 4))
        printf ("FAILED: 2nd rbuf_equal_rbuf_len compare\n");
    
    if (!rbuf_equal_rbuf_len (buf, rbuf_auto ("Hel"), 2))
        printf ("FAILED: 3rd rbuf_equal_rbuf_len compare\n");

    if (!rbuf_equal_rbuf_len (buf, rbuf_auto ("Hello"), 10))
        printf ("FAILED: 4th rbuf_equal_rbuf_len compare\n");
    
    if (rbuf_equal_rbuf_len (buf, rbuf_auto ("Hillo"), 5))
        printf ("FAILED: 5th rbuf_equal_rbuf_len compare\n");

    if (!rbuf_equal_rbuf_len (buf, rbuf_auto ("Hell!"), 4))
        printf ("FAILED: 6th rbuf_equal_rbuf_len compare\n");
    
    if (rbuf_equal_rbuf_len (buf, rbuf_auto ("Hell!"), 5))
        printf ("FAILED: 6th rbuf_equal_rbuf_len compare\n");


    rcleanup ();

    return (0);
}


