
/*
 * Copyright (C) 1999-2003, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

void
decode_msg (char *msg, unsigned int len);

void
decode_msg (char *msg, unsigned int len)
{
    RXpDecoder *decoder;
    unsigned int length;
    RBuf *bufval;
    int intval;
    unsigned int uintval;
    float floatval;
    double doubleval;
    RXpDataType type;


    decoder = rxp_decoder_new (msg, len);
    length = rxp_decoder_msg_length (decoder);
    printf ("Total message length is %u bytes.\n", length);
    
    while (1) {

        type = rxp_decode_peek_next_type (decoder);

	if (type == 0) {
	    break;
	}

        if (type == RXP_TYPE_RBUF) {
	    if (rxp_decode_rbuf (decoder, &bufval)) {
		printf ("Couldn't decode rbuf.\n");
		break;
	    }
            printf ("RBuf: '%s'\n", rbuf_str (bufval));
            rbuf_free (bufval);
        } else if (type == RXP_TYPE_NULL_RBUF) {
	    if (rxp_decode_rbuf (decoder, &bufval)) {
		printf ("Couldn't decode NULL rbuf.\n");
		break;
	    }
            printf ("NULL RBuf\n");
        } else if (type == RXP_TYPE_INT32) {
	    if (rxp_decode_rint32 (decoder, &intval)) {
		printf ("Couldn't decode int32.\n");
		break;
	    }
            printf ("rint32: %d\n", intval);
        } else if (type == RXP_TYPE_UINT32) {
	    if (rxp_decode_ruint32 (decoder, &uintval)) {
		printf ("Couldn't decode int32.\n");
		break;
	    }
            printf ("ruint32: %d\n", uintval);
        } else if (type == RXP_TYPE_FLOAT) {
	    if (rxp_decode_float (decoder, &floatval)) {
		printf ("Couldn't decode float.\n");
		break;
	    }
            printf ("float: %f\n", floatval);
        } else if (type == RXP_TYPE_DOUBLE) {
	    if (rxp_decode_double (decoder, &doubleval)) {
		printf ("Couldn't decode double.\n");
		break;
	    }
            printf ("double: %f\n", doubleval);
        }
    }
    rxp_decoder_free (decoder);
}

int main (int argc, char *argv[])
{
    RXpDecoder *decoder;
    char *buffer;
    int len;
    FILE *fp;
    
    rinit ();
  
    if (argc != 2) {
        printf ("Usage: rxpdecode <filename>\n");
        exit (0);
    }

    fp = fopen (argv[1], "r");
    if (!fp) {
        fprintf (stderr, "Error opening %s for writing: %s\n", argv[1], strerror (errno));
        exit (0);
    }

    buffer = rmem_alloc (sizeof (rint32));
    fread (buffer, sizeof (rint32), 1, fp); 

    decoder = rxp_decoder_new (buffer, sizeof (rint32));

    len = rxp_decoder_msg_length (decoder);

    buffer = rmem_realloc (buffer, len);
    fread (buffer + sizeof (rint32), len - sizeof (rint32), 1, fp); 

    decode_msg (buffer, len);
    
    rxp_decoder_free (decoder);

    rcleanup ();

    return 0;
}



