/*
 * header file for RTF-to-LaTeX2e translation writer code.
 * (c) 1999 Ujwal S. Sathyam
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


# define	rtf2latex2e_version "1.0 fc1"

# define	WRAP_LIMIT	120
# define	PACKAGES	9

#ifndef boolean
typedef unsigned char boolean;
#endif
# define	New(t)	((t *) RTFAlloc (sizeof (t)))
# define	Swap(a, b) {double tmp;\
						tmp = a;\
						a = b;\
						b = tmp;}

/* figure out the system we are compiling for */
#if defined(__POWERPC__) || defined(__CFM68K__) || defined(__MC68K__)
	/* check for Macintosh */	
	# include	<unix.mac.h>
	# include 	"Main.h"
	# define	PATH_SEP	':'
	# define	RTF2LATEX2E_MAC	1
#elif defined(WIN32)			
	/* check for Windows */
	# define	PATH_SEP	'\\'
	# define	RTF2LATEX2E_DOS	1
# else
	/* default to UNIX */																	
	# define	PATH_SEP	'/'
	# define	RTF2LATEX2E_UNIX	1
#endif


#ifndef false
	#define false 0
#endif

#ifndef true
	#define true 1
#endif

#ifndef size_t
	/* autoconf defines size_t as unsigned if not defined */
#	define size_t unsigned long /* 'unsigned' changed to 'unsigned long' by Ujwal Sathyam */
#endif


void	WriterInit (void);
int	BeginLaTeXFile (void);
void EndLaTeXFile (void);

void RTFSetOutputStream (FILE *ofp);


enum pictType {unknownPict, pict, wmf, gif, jpeg, bin, png};
enum objClass {unknownObj, Equation, equation, WordPicture, MSGraphChart};
enum word97ObjectClass {unknownWord97Object, word97Object, standardObject, word97Picture, word97ObjText};
enum {left, center, right};
enum {singleSpace, oneAndAHalfSpace, doubleSpace};
typedef enum {tinySize, scriptSize, footNoteSize, smallSize, normalSize, 
			largeSize, LargeSize, LARGESize, giganticSize, GiganticSize} fontSize;
enum cellMergeFlag {none, first, previous};
//typedef struct cell cell;
static char *objectClassList[] = {"Unknown", 
								  "Equation", 
								  "equation",
								  "Word.Picture", 
								  "MSGraph.Chart", 
								  (char *) NULL};

static char *justificationList[] = {"\\raggedright", "\\centering", "\\raggedleft"};

static char *environmentList[] = {"flushleft", "center", "flushright"};

static char *fontSizeList[] = {"\\tiny",
							   "\\scriptsize",
							   "\\footnotesize",
							   "\\small",
							   "\\normalsize",
							   "\\large", 
							   "\\Large", 
							   "\\LARGE",
							   "\\huge", 
							   "\\Huge"};


/*
 * Flags global to LaTeX2e-writer.c
 */
static int wrapCount = 0;
static int charAttrCount = 0;
static int mathMode = 0;
static int mathGroup = 0;
static int colorChange = 0;
static int temp1, temp2, temp3, temp4;
static int temp5, temp6, temp7, temp8, temp9, temp10, temp11;
static long rememberFontSize;
static int word97ObjectType;
static boolean lastCharWasLineBreak = true;
static boolean seenLeftDoubleQuotes = false;
static boolean wroteBeginDocument = false;
static int	spaceCount = 0;
static int	blankLineCount = 0;
static boolean suppressLineBreak;
static boolean requireColorPackage;
static boolean requireSetspacePackage;
static boolean requireFontEncPackage;
static boolean requireTablePackage;
static boolean requireMultirowPackage;
static boolean requireGraphicxPackage;
static boolean requireAmsSymbPackage;
static boolean requireMultiColPackage;
static boolean requireUlemPackage;
static boolean requireHyperrefPackage;
static boolean requireAmsMathPackage;
static long packagePos;
static boolean writingHeading1, writingHeading2, writingHeading3;
static boolean insideFootnote, justWroteFootnote;
static boolean insideHyperlink;

typedef struct 
{
	int	count;
	int	type;
	long	width;
	long	height;
	long	goalWidth;
	long	goalHeight;
	long	scaleX;
	long	scaleY;
	int		llx;
	int		lly;
	int		urx;
	int		ury;
	char	name[rtfBufSiz];
} pictureStruct;

typedef struct
{
	int count;
} equationStruct;

static struct
{
	int class;
	char className[rtfBufSiz];
	int word97;
} object;


typedef struct
{
	boolean	newStyle;
	int		boldGroupLevel;
	int		noBoldGroupLevel;
	boolean	wroteBold;
	boolean	wroteNoBold;
	int		italicGroupLevel;
	int		noItalicGroupLevel;
	boolean	wroteItalic;
	boolean	wroteNoItalic;
	int		underlinedGroupLevel;
	int		noUnderlinedGroupLevel;
	boolean	wroteUnderlined;
	int		dbUnderlinedGroupLevel;
	int		noDbUnderlinedGroupLevel;
	boolean	wroteDbUnderlined;
	int		shadowedGroupLevel;
	int		noShadowedGroupLevel;
	boolean	wroteShadowed;
	int		allCapsGroupLevel;
	boolean	wroteAllcaps;
	int		smallCapsGroupLevel;
	boolean	wroteSmallCaps;
	long	foreColor;
	int		foreColorGroupLevel;
	boolean	wroteForeColor;
	long	backColor;
	int		backColorGroupLevel;
	boolean	wroteBackColor;
	int		subScriptGroupLevel;
	int		noSubScriptGroupLevel;
	boolean	wroteSubScript;
	boolean	wroteNoSubScript;
	int		superScriptGroupLevel;
	int		noSuperScriptGroupLevel;
	boolean wroteSuperScript;
	boolean wroteNoSuperScript;
	long	fontSize;
	int		fontSizeGroupLevel;
	boolean	wroteFontSize;
	boolean	open;
} textStyleStruct;


static struct
pageStyleStruct {
	double	width;
	double	leftMargin;
	double	rightMargin;
} page;

static struct
{
	boolean	newStyle;
	int		alignment;
	boolean	wroteAlignment;
	int		lineSpacing;
	boolean	wroteSpacing;
	long	firstIndent;
	long	leftIndent;
	long	rightIndent;
	boolean	parbox;
} paragraph;

static struct
{
	boolean	newStyle;
	long	cols;
} section;

typedef struct cell
{
	long	x;
	long	y;
	long	left;
	long	right;
	double	width;
	int		columnSpan;
	int		index;
	int		mergePar;	
	long	textColor;
	boolean	textBold;
	boolean	textItalic;
	boolean	textUnderlined;
	struct cell	*nextCell;
} cell;

typedef struct
{
	boolean	inside;
	int		rows;
	int		cols;
	int		cellCount;
	long	leftEdge;
	cell	*cellInfo;
	int		rowInfo[rtfBufSiz];
	long	*columnBorders;
	int		cellMergePar;
	long	previousColumnValue;
	boolean	newRowDef;
    boolean multiCol;
    boolean multiRow;
} tableStruct;

/* Prototypes */

#if RTF2LATEX2E_MAC
OSType Str2OSType(char *theStr);
#endif
static void usage(void);
static boolean IsValidPref (char *name, char *pref);
short 		ReadPrefFile (char *file);
static short ReadR2LMap (void);
static short R2LItem (char *name);
int			GetPreferenceNum (char *name);
static void	InitializeGroupLevels (void);
static void StoreGroupLevels (void);
static void RestoreGroupLevels (void);
static void	InitializeTextStyle (void);
static void	TextClass (void);
static void	ControlClass (void);
static void GroupClass (void);
static void SkipGroup (void);
static void	Destination (void);
static void WriteColours (void);
static void	ReadFootnote (void);
static void	SpecialChar (void);
static void	PutStdChar (int	stdCode);
static void	PutLitChar (int	c);
static void	PutLitStr (char	*s);
static void WrapText (void);
static void WriteLaTeXHeader (void);
static void CharAttr (void);
static void ParAttr (void);
void CheckForCharAttr (void);
static void ForceCloseCharAttr (void);
static void WriteColor (void);
static void DefineColors (void);
static void CheckForParagraph (void);
static void ReadFieldInst (void);
static void CheckForMathMode (void);
static void ReadPicture (void);
static int  HexData (void);
static void WritePictureHeader (FILE *pictureFile);
static void ConvertHexPicture (char *pictureType);
static void ReadObject (void);
static void GetObjectClass (int *groupCounter);
static int  ReachedResult (int *groupCount);
void		ExamineToken (void);
static void ReadWord97Object (void);
static void ReadWord97Result (void);
static boolean ReadEquation (int *groupCount);
static void ReadObjectData (char *objectFileName, int type, int offset);
static int	DecodeOLE (char *objectFileName, char *streamType, 
            unsigned char **nativeEquationStream, size_t *equationSize);  
static void DoTable (void);
static void DoTableAttr (void);
static void	PrescanTable (void);
static void	CellsIntoStraightColumns (void);
static void DoMergedCells (cell *cellPtr);
static void	ProcessTableRow (int rowNum);
static void	ReadCell (void);
static cell *GetCellInfo (int cellNum);
static cell *GetCellByPos (int x, int y);
static int	GetColumnSpan (cell *cellPtr);
static void WriteCellHeader (int cellNum);
static void DrawTableRowLine (int rowNum);
static void	InheritTableRowDef (void);
static void ExamineTextStyle (void);
static void	CheckForBeginDocument (void);
static void	SetTextStyle (void);
static void	WriteTextStyle (void);
static void	WriteParagraphStyle (void);
static void IndentParagraph (void);
static void DoParagraphCleanUp (void);
static void SectAttr (void);
static void	WriteSectionStyle (void);
static void	DoSectionCleanUp (void);
int			ConvertPICT2EPS (char *fname);
static void IncludeGraphics (char *pictureType);
static int	ScanBoundingBox (char *epsFile);
static int	CountCharInString (char *theString, char theChar);
static void ReadHyperlink (void);
static void	InsertNewLine (void);