// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_CharacterLiteral.hh"
#include "IIR_CharacterLiteral.hh"
#include <iostream>
#include "savant.hh"

#include <cstring>

IIRBase_CharacterLiteral::IIRBase_CharacterLiteral(){}

IIRBase_CharacterLiteral::~IIRBase_CharacterLiteral(){}


IIR_CharacterLiteral *
IIRBase_CharacterLiteral::get( IIR_Char *new_text, IIR_Int32 new_length ){
  IIR_CharacterLiteral *retval = new IIR_CharacterLiteral();
  retval->_set_text( new_text, new_length );

  return retval;
}

IIR_CharacterLiteral *
IIRBase_CharacterLiteral::get( const string new_text ){
  IIR_CharacterLiteral *retval = new IIR_CharacterLiteral();
  retval->_set_text( new_text.c_str(), new_text.length() );

  return retval;
}

void 
IIRBase_CharacterLiteral::release(){
  delete this;
}
