
#ifndef IIRBASE_CONCURRENT_GENERATE_FOR_STATEMENT_HH
#define IIRBASE_CONCURRENT_GENERATE_FOR_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

//---------------------------------------------------------------------------

#include "IIR_ConcurrentStatement.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_ArchitectureStatementList.hh"

class IIR_ConstantDeclaration;

class IIRBase_ConcurrentGenerateForStatement : public IIR_ConcurrentStatement {

public:
  IIR_Kind get_kind() const {return IIR_CONCURRENT_GENERATE_FOR_STATEMENT;}
  IIR_Char *get_kind_text() const {return "IIR_ConcurrentGenerateForStatement";}

  void set_generate_parameter_specification(IIR_ConstantDeclaration *parameter); 
  IIR_ConstantDeclaration *get_generate_parameter_specification();

  IIR_DeclarationList           block_declarative_part;
  IIR_ArchitectureStatementList concurrent_statement_part;

protected:
  IIRBase_ConcurrentGenerateForStatement();
  virtual ~IIRBase_ConcurrentGenerateForStatement() = 0;
    
private:
  IIR_ConstantDeclaration *parameter;
};
#endif
