
#ifndef IIRBASE_EXIT_STATEMENT_HH
#define IIRBASE_EXIT_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIR_SequentialStatement.hh"

class IIR_SequentialStatement;

class IIRBase_ExitStatement : public IIR_SequentialStatement {

public:
  IIR_Kind get_kind() const {return IIR_EXIT_STATEMENT;}
  IIR_Char *get_kind_text() const {return "IIR_ExitStatement";}

  void set_enclosing_loop( IIR_SequentialStatement *enclosing_loop );
  IIR_SequentialStatement *get_enclosing_loop();

  void set_condition( IIR *condition );
  IIR *get_condition();

protected:
  IIRBase_ExitStatement();
  virtual ~IIRBase_ExitStatement() = 0;
    
private:
  IIR_SequentialStatement *enclosing_loop;
  IIR *condition;
};
#endif
