
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Kathiresan Nellayappan
//          Vasudevan Shanmugasundaram

//---------------------------------------------------------------------------

#include "IIRBase_SimpleSimultaneousStatement.hh"
#include "savant.hh"

IIRBase_SimpleSimultaneousStatement::IIRBase_SimpleSimultaneousStatement(){
  set_right_expression(NULL);
  set_left_expression(NULL);
  left_expression = NULL;
  right_expression = NULL;
  tolerance_aspect = NULL;
}

IIRBase_SimpleSimultaneousStatement::~IIRBase_SimpleSimultaneousStatement(){}

void
IIRBase_SimpleSimultaneousStatement::set_left_expression(IIR* my_left_expression){
  left_expression = my_left_expression;
}

void
IIRBase_SimpleSimultaneousStatement::set_right_expression(IIR* my_right_expression){
  right_expression = my_right_expression;
}

IIR*
IIRBase_SimpleSimultaneousStatement::get_left_expression(){
  return left_expression;
}

IIR*
IIRBase_SimpleSimultaneousStatement::get_right_expression(){
  return right_expression;
}

void
IIRBase_SimpleSimultaneousStatement::set_pure(IIR_Pure my_purity) {
  purity = my_purity;
}

IIR_Pure
IIRBase_SimpleSimultaneousStatement::get_pure() {
  return purity;
}

void 
IIRBase_SimpleSimultaneousStatement::set_tolerance_aspect(IIR* my_tolerance) {
  tolerance_aspect = my_tolerance;
}

IIR*
IIRBase_SimpleSimultaneousStatement::get_tolerance_aspect() {
  return tolerance_aspect;
}
