// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_TypeDefinition.hh"
#include "IIR_TypeDefinition.hh"
#include "savant.hh"

IIRBase_TypeDefinition::IIRBase_TypeDefinition() {
  my_base_type = NULL ;
  _my_declaration = NULL;
  _my_type_mark = NULL;
}

IIRBase_TypeDefinition::~IIRBase_TypeDefinition(){}

void
IIRBase_TypeDefinition::set_base_type(IIR_TypeDefinition* base_type) {
  ASSERT( base_type == NULL || base_type->_is_subtype() == FALSE );
  my_base_type = base_type;
}

IIR_TypeDefinition*
IIRBase_TypeDefinition::get_base_type() {
  return my_base_type;
}

IIR_Declaration *
IIRBase_TypeDefinition::_get_declaration() {
  return _my_declaration;
}

void 
IIRBase_TypeDefinition::_set_declaration( IIR_Declaration *declaration ) {
  _my_declaration = declaration;
}

IIR_TypeDefinition *
IIRBase_TypeDefinition::_get_type_mark() {
  return _my_type_mark;
}

void 
IIRBase_TypeDefinition::_set_type_mark( IIR_TypeDefinition *type_mark ) {
  _my_type_mark = type_mark;
}

