// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_AssociationElement.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_List.hh"

IIRScram_AssociationElement::~IIRScram_AssociationElement() {}

void
IIRScram_AssociationElement::_publish_vhdl_without_formals(ostream &){
  _report_undefined_scram_fn("_publish_vhdl_without_formals(ostream &)");
}

void
IIRScram_AssociationElement::_publish_cc_generic_map_aspect( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_AssociationElement::_publish_cc_generic_map_aspect" );

  _report_undefined_scram_fn("_publish_cc_generic_map_aspect( _cc_out )");
}

void
IIRScram_AssociationElement::_publish_cc_generic_map_aspect_for_conc_stmts( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_AssociationElement::_publish_cc_generic_map_aspect_for_conc_stmts" );

  _report_undefined_scram_fn("_publish_cc_generic_map_aspect_for_conc_stmts( _cc_out )");
}

void 
IIRScram_AssociationElement::_publish_cc_subprogram_arguments( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AssociationElement::_publish_cc_subprogram_arguments" );

  _report_undefined_scram_fn("_publish_cc_subprogram_arguments( _cc_out )");
}

IIR_Int32 
IIRScram_AssociationElement::_get_number_of_element_associations() {
  _report_undefined_scram_fn("_get_number_of_element_associations()");
  return 0;
}

void
IIRScram_AssociationElement::_get_list_of_input_signals( set<IIR>* list ){
  if( _get_actual() != NULL ){
    _get_actual()->_get_list_of_input_signals(list);
  }
}

// This virtual method must never be called.  It is overloaded for
// IIR_AssociationElementByExpression
IIR*
IIRScram_AssociationElement::_get_actual() {
  return NULL;
}

// This virtual method must never be called.  It is overloaded for
// IIR_AssociationElementByExpression
void 
IIRScram_AssociationElement::_set_actual( IIR *) {
  ASSERT(FALSE);
}

IIR_Declaration *
IIRScram_AssociationElement::_find_formal_declaration(){
  
  // This gets called from _find_formal_declaration in IIR_FunctionCall.
  // It gets called directly on the formal originally.  That's why this one
  // has to call it on the actual - NOT the formal.
  
  IIR_Declaration *retval = NULL;
  if( _get_actual() != NULL ){
    retval = _get_actual()->_find_formal_declaration();
  }

  return retval;
}

IIR_Boolean 
IIRScram_AssociationElement::_is_named(){
  // If the formal isn't NULL we're named, unless we're by others.
  return get_formal() != NULL && _is_by_others() == FALSE ;
}

IIR_Boolean 
IIRScram_AssociationElement::_is_positional(){
  // If the formal is NULL and we're not others, we're positional
  return get_formal() == NULL && _is_by_others() == FALSE;
}


IIR_Boolean
IIRScram_AssociationElement::_is_by_others(){
  if( _get_actual() != NULL && _get_actual()->get_kind() == IIR_OTHERS_INITIALIZATION ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


IIR_Boolean 
IIRScram_AssociationElement::_is_globally_static_for_array(){
  _report_undefined_scram_fn("_is_globally_static_for_array()");
  abort();
  return FALSE;
}

IIR_Boolean 
IIRScram_AssociationElement::_is_globally_static_for_record(){
  _report_undefined_scram_fn("_is_globally_static_for_record");
  abort();
  return FALSE;
}

IIR_Boolean 
IIRScram_AssociationElement::_is_globally_static_for_function(){
  _report_undefined_scram_fn("_is_globally_static_for_function");
  abort();
  return FALSE;
}
