#ifndef IIRSCRAM_ATTRIBUTE_DECLARATION_HH
#define IIRSCRAM_ATTRIBUTE_DECLARATION_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_AttributeDeclaration.hh"
class IIR_Attribute;
class IIR_List ;

class IIRScram_AttributeDeclaration : public IIRBase_AttributeDeclaration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_entity_class(ostream &);
  IIR_Boolean _is_signal();

  /** An attribute declaration can refer to more than one instance of an
   attribute.  These methods refer to the FIRST instance of an attribute
   that caused this declaration to be created (if scram created it -
   user defined attributes are a different matter) These methods are so
   the parser gan easily determine things like if this is a signal
   valued attribute and so forth. */
  IIR_Attribute *_get_attribute();

  void _set_attribute(  IIR_Attribute *);
  IIR_Declaration* _get_prefix_declaration();

  IIR_TypeDefinition *get_subtype();

  declaration_type _get_type();

  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );

  /** Since an attribute declaration doesn't generate a file, there's no
     include we need to get ahold of the declaration.  Of course, if I'm
     wrong, we would call "_publish_cc_include" on our declarative
     region...  */
  void _publish_cc_include( published_file & ){}
  void _add_decl_into_cgen_symbol_table();

  IIR_TypeDefinition *_get_type_of_element( int );
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  IIR_Boolean _is_iir_attribute_declaration(){ return TRUE; }

protected:
  IIRScram_AttributeDeclaration();
  virtual ~IIRScram_AttributeDeclaration() = 0;
    
private:
  // (See the notes about get and set attribute above)  This is called "one
  // attribute" this declaration might refer to several instances of the
  // attribute - we just have a single pointer so we can easily get info
  // about the type.
  IIR_Attribute *one_attribute;
};
#endif
