
#ifndef IIRSCRAM_CASE_STATEMENT_ALTERNATIVE_HH
#define IIRSCRAM_CASE_STATEMENT_ALTERNATIVE_HH

// Copyright (c) 1996-2002 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//          Ardhendu Singh
//          Krishnan Subramani

//---------------------------------------------------------------------------
#include "IIRBase_CaseStatementAlternative.hh"

template <class type> class set;
class IIRScram_WaitStatement;
class IIR_TypeDefinition;
class IIR_SubprogramDeclaration;

class IIRScram_CaseStatementAlternative : public IIRBase_CaseStatementAlternative {

public:
  void _publish_cc_decl_for_loop_iterator( published_file &_cc_out );

  void _build_wait_list(dl_list<IIRScram_WaitStatement>* );
  void _get_list_of_input_signals( set<IIR> *list );
  void _get_signal_source_info( set<IIR> *siginfo );

  IIR_Boolean _type_check_return_statements( set<IIR_TypeDefinition> *,
					     IIR_SubprogramDeclaration * );

  IIR_Boolean _is_iir_case_statement_alternative() {return TRUE;};

  virtual void _clone( IIR * );
  IIR *_clone();

protected:
  IIRScram_CaseStatementAlternative() {}
  virtual ~IIRScram_CaseStatementAlternative() = 0;
    
  void _publish_vhdl_alternative(ostream &, IIR *);

private:

};
#endif
