
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_ConcurrentBreakStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_DesignatorList.hh"
#include "IIR_WaitStatement.hh"
#include "IIR_BreakElement.hh"
#include "IIR_Designator.hh"
#include "IIR_TypeDefinition.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "IIR_Label.hh"
#include "IIR_EventAttribute.hh"
#include "break_handler.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_AttributeDeclaration.hh"
#include "IIR_Declaration.hh"
#include "IIR_BreakStatement.hh"
#include "sstream-wrap.hh"

using std::cerr;
extern symbol_table *cgen_sym_tab_ptr;

IIRScram_ConcurrentBreakStatement::~IIRScram_ConcurrentBreakStatement() {}

void
IIRScram_ConcurrentBreakStatement::_publish_vhdl(ostream &_vhdl_out) {
  if (get_label() != NULL ){
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " : ";
  }
  _vhdl_out << " break " ;
  if ( concurrent_break_list.num_elements() != 0 ) {
    concurrent_break_list._publish_vhdl(_vhdl_out);
  }
  if ( sensitivity_list.num_elements() != 0) {
    _vhdl_out << " on ";
    sensitivity_list._publish_vhdl(_vhdl_out);
  }
  if ( get_condition() != NULL ) {
    _vhdl_out << " when " ;
    get_condition()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << " ;\n" ;
}

void
IIRScram_ConcurrentBreakStatement::_publish_cc() {}

void
IIRScram_ConcurrentBreakStatement::_build_break_info() {
  break_handler *breakInfo;
  breakInfo = new break_handler;
  breakInfo->set_condition(get_condition());
  breakInfo->set_breaklist(&concurrent_break_list);
  breakInfo->set_sensitivitylist(&sensitivity_list);
  //  breakList.append(breakInfo);
  //  num_interface_signals += sensitivity_list.num_elements();
}

void
IIRScram_ConcurrentBreakStatement::_publish_createNetInfo(char *filename, published_file &_cc_out) {
  string objectname;
  objectname = ", " + _get_current_elab_name() +"_elab_obj->id);\n" ;
  IIR* signals = ((IIRScram_DesignatorExplicit*)sensitivity_list.first());
  int numelements = sensitivity_list.num_elements();
  for(int i=0; i < numelements; i++) { 
    _cc_out << "Add(";
    switch(signals->get_kind()) {
    case IIR_SIGNAL_INTERFACE_DECLARATION:
      ((IIR_Declaration*)signals)->_publish_cc_elaborate(_cc_out);
      break;
    case IIR_DESIGNATOR_EXPLICIT:
      ((IIR_Declaration*)((IIR_DesignatorExplicit*)signals)->get_name())->_publish_cc_elaborate(_cc_out);
      break;
    default:
      signals->_publish_cc_elaborate(_cc_out);
      break;
    }
    _cc_out << objectname;
    signals = sensitivity_list.successor((IIR_Designator*)signals);
  }
}

void
IIRScram_ConcurrentBreakStatement::_publish_cc_ams() {}

IIR *
IIRScram_ConcurrentBreakStatement::_transmute() {
  
  IIR_ProcessStatement* pstmt = new IIR_ProcessStatement;
  IIR_WaitStatement* wstmt = new IIR_WaitStatement;
  
  copy_location( this, wstmt ); 
  copy_location( this, pstmt );
  
  IIR_BreakElement *break_element = NULL;
  IIR_BreakStatement *break_stmt = new IIR_BreakStatement();
  
  IIR_Designator *designator = NULL;
  set<IIR> signallist;
  IIR_Declaration *signals = NULL;
  
  pstmt->_set_design_file( _get_design_file( ) );
  pstmt->set_line_number(get_line_number());
  
  pstmt->set_label(get_label());
  pstmt->set_postponed(FALSE);
  
  break_stmt->set_condition(get_condition());
  for ( break_element = concurrent_break_list.first();
	break_element != NULL;
	break_element = concurrent_break_list.successor(break_element) ) {
    break_stmt->break_list.append(break_element);
  }
  
  for ( designator = sensitivity_list.first();
	designator != NULL;
	designator = sensitivity_list.successor(designator) ) {
    wstmt->sensitivity_list.append(designator);
  }
  if(get_condition() != NULL) {
    get_condition()->_get_list_of_input_signals(&signallist);
    for(signals = static_cast<IIR_Declaration *>(signallist.get_element());
	signals != NULL;
	signals = static_cast<IIR_Declaration *>(signallist.get_next_element())) {
      designator = new IIR_DesignatorExplicit;
      designator = new IIR_DesignatorExplicit;
      ((IIR_DesignatorExplicit*)designator)->set_name(signals);
      wstmt->sensitivity_list.append(designator);
    }
  }
  wstmt->set_condition_clause(NULL);
  wstmt->set_timeout_clause(NULL);
  pstmt->process_statement_part.append(break_stmt);
  pstmt->process_statement_part.append(wstmt);
  return pstmt;
}

void
IIRScram_ConcurrentBreakStatement::_type_check() {

  IIR *signal_decl = NULL;
  IIR *current_name = NULL;
  IIR *new_condition = NULL;
  IIR_BreakElement *break_element = concurrent_break_list.first();
  while(break_element != NULL) {
    break_element->_type_check();
    break_element = concurrent_break_list.successor(break_element);
  }
  IIR_Designator *current_designator = sensitivity_list.first();
  while (current_designator != NULL) {
    ASSERT(current_designator->get_kind() == IIR_DESIGNATOR_EXPLICIT);
    current_name = ((IIR_DesignatorExplicit*)current_designator)->get_name();
    signal_decl = _resolve_signal_name(current_name);
    if (signal_decl != NULL) {
      ((IIR_DesignatorExplicit *)current_designator)->set_name(signal_decl);
    }
    current_designator = sensitivity_list.successor(current_designator);
  }
  if( get_condition() != NULL ){
    new_condition = _type_check_and_resolve_boolean_condition(get_condition());
    ASSERT( new_condition != NULL );
    ASSERT( new_condition->_is_resolved() == TRUE );
    set_condition( new_condition );
  }
}

IIR *
IIRScram_ConcurrentBreakStatement::_resolve_signal_name(IIR *sig_name) {
  IIR *retval;
  set<IIR_TypeDefinition> *signal_rvals = sig_name->_get_rval_set( &IIRScram_ConcurrentBreakStatement::_is_signal );
  
  if( signal_rvals == NULL ){
    report_undefined_symbol( sig_name );
    return NULL;
  }
  switch (signal_rvals->num_elements()) {
  case 0: {
    ostringstream cerr;
    cerr << "Signal " << *sig_name << " is undeclared in this scope." ;
    return NULL;
    break;
  }
  case 1: {
    IIR_TypeDefinition *sig_type = signal_rvals->get_element();
    IIR *sig_name_transformed = sig_name->_semantic_transform( sig_type );
    sig_name->_type_check( sig_type );
    retval = sig_name->_rval_to_decl( sig_type );
    ASSERT( retval->_is_resolved() == TRUE );
    break;
  }
  default:
    report_ambiguous_error( sig_name, signal_rvals );
    break;
  }
  delete signal_rvals;
  return retval;
}
