#ifndef IIRSCRAM_CONFIGURATION_SPECIFICATION_HH
#define IIRSCRAM_CONFIGURATION_SPECIFICATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_ConfigurationSpecification.hh"

class IIR_StatementList;
class IIR_DeclarationList;
class IIR_ComponentInstantiationStatement;

class IIRScram_ConfigurationSpecification : public IIRBase_ConfigurationSpecification {

public:
  enum type_check_mode { CONFIG_SPEC, COMPONENT_INSTANT };

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);

  IIR_Boolean _is_specification() { return TRUE; }
  IIR_Boolean _is_iir_configuration_specification() { return TRUE; }

  IIR_DesignatorList *_get_instantiation_list();

  // The list passed into this type check method contains the statement region
  // of the declarative region this sepcification appears in.  It is used for
  // finding component instantiation statements, so it can resolve ALL and
  // OTHERS.
  void _type_check( IIR_List &statment_list, type_check_mode mode );

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,
			 char*);
#endif

  IIR *_get_component_name( );
  void _set_component_name( IIR * );
  IIR_LibraryUnit *_get_entity_aspect();

  void _publish_cc_port_map_aspect( published_file &_cc_out );
  void _publish_cc_headers( published_file & ) {}
  IIR_Boolean _has_same_component(IIR_ComponentInstantiationStatement* conc_stmt);
  IIR_Boolean _configures_this_component(IIR_ComponentInstantiationStatement* conc_stmt);
protected:
  IIRScram_ConfigurationSpecification() {}
  virtual ~IIRScram_ConfigurationSpecification() = 0;
    
private:
};
#endif
