
#ifndef IIRSCRAM_ENUMERATION_LITERAL_HH
#define IIRSCRAM_ENUMERATION_LITERAL_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

//---------------------------------------------------------------------------

#include "IIRBase_EnumerationLiteral.hh"
#include "IIR_Declaration.hh"

class IIR_Declaration;
template <class type> class set;
class IIR_List;

class IIRScram_EnumerationLiteral : public IIRBase_EnumerationLiteral {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_cc_rvalue( published_file &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_universal_value( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_value( published_file &_cc_out );

  void _publish_cc_initialization_value( published_file &_cc_out );

  //While publishing the if and case statements, the enumeration literals
  //must be converted to type of the enumeration literal
  void _publish_cc_condition( published_file &_cc_out );

  IIRScram_Declaration::declaration_type _get_type();

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  set<IIR_Declaration> *_symbol_lookup();
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  void _type_check( set<IIR_TypeDefinition> * );
  IIR *_clone();

  ostream &_print( ostream & );

  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_direction( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );
  void _publish_cc_ams_function( published_file &_cc_out );

  IIR_Boolean _is_enumeration_literal() { return TRUE; }
  IIR_Boolean _is_character_literal();
  IIR_Boolean _is_iir_enumeration_literal(){ return TRUE; }
  IIR_Boolean _is_static_expression() { return TRUE;}
  IIR_Boolean _is_locally_static() { return TRUE;}
  IIR_Boolean _is_overloadable(){ return TRUE; }
  IIR_Boolean _is_ascending_range();
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  IIR_Boolean _is_resolved();
  IIR_Boolean _is_homograph_of( IIR_Declaration * );

  // an empty function to prevent incorrect error message.
  void _add_declarations_in_initializations() {};
  void _add_decl_into_cgen_symbol_table() {};

  IIR_AttributeSpecificationList* _get_attribute_specification_list(){ return &attributes; }

protected:
  IIRScram_EnumerationLiteral() {}
  virtual ~IIRScram_EnumerationLiteral() = 0;
    
private:
};
#endif
