
#ifndef IIRSCRAM_FUNCTION_CALL_HH
#define IIRSCRAM_FUNCTION_CALL_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran

#include "IIRBase_FunctionCall.hh"

class IIR_DesignatorList;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_SubprogramDeclaration;
class IIR_IndexedName;
class IIR_FunctionCall;

class IIRScram_FunctionCall : public IIRBase_FunctionCall {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc_as_operator( published_file &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_elaborate_arg( published_file &_cc_out );

  /** This function is implemented recursively in different nodes to
      handle type conversion in procedure calls. The actual can be nest
      function calls and the actual nested with them is extracted and
      published. */
  void _publish_cc_first_objectParameter( published_file &_cc_out );

  //void _publish_cc_kernel_type( ostream &os );

  /** Publishes the function information appearing in a simultaneous
      statement. */ 
  void _publish_cc_ams_function( published_file& );
 
  /** Publishes the constructor information for function in simultaneous
      statement. */
  void _publish_cc_ams_function_call_in_simult_stmt(published_file&);

  /** Publishes the math functions and its arguments appearing in a
      simultaneous statement.

      @param math_function_name Math function appearing in the simultaneous statement. 
      @param _cc_out Stream to publish into. */
  void _publish_cc_ams_math_functions( IIR_TextLiteral *math_function_name, published_file &_cc_out );
  
  void _build_generic_parameter_set(set<IIR_Declaration> *);

  void _type_check( set<IIR_TypeDefinition> * );
  IIR * _rval_to_decl( IIR_TypeDefinition * );
  IIR_TypeDefinition *get_subtype();

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR_Boolean _is_resolved(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }

  static IIR_FunctionCall *_build_function_call( IIR_SubprogramDeclaration *, IIR_IndexedName * );

  ostream &_print( ostream & );

  set<IIR_Declaration> *_symbol_lookup();

  void _build_sensitivity_list( IIR_DesignatorList* sensitivity_list );
  void _get_list_of_input_signals( set<IIR> *list);
  void _add_decl_into_cgen_symbol_table();

  IIR *_clone();
  IIR_Mode _get_mode();

  // See IIRScram.hh for description.
  IIR_Declaration *_find_formal_declaration();

  IIR_Boolean _is_globally_static_primary();
  IIR_Boolean _is_static_expression();

  /** Sets the index for the equation nodes of the simultaneous stmt. */
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);

  /** Sets the index for quantities appearing in the parameter list of the
      function.
     
      @param index Index number variable of the quantity.
      @param quantity_set List holding the list of quantities in a
        simultaneous statement. */ 
  void _set_stmt_qty_index(IIR_Int32 *index, set<IIR_Declaration> *quantity_set);  

  /** Sets the index for signals appearing in the parameter list of the
      function. 

      @param index Index number variable of the signal.
      @param quantity_set List holding the list of signals in a
      simultaneous statement. */
  void _set_stmt_signal_index(IIR_Int32 *index, set<IIR_Declaration> *quantity_set);  

  /** Resets the index values and the list of quantity and signal
      indexes. */
  void _flush_stmt_index();

  set<IIR_Declaration> *_get_implicit_declarations( );
  void _set_implicit_declarations( set<IIR_Declaration> * );
  const string _get_cc_kernel_type( );

protected:
  IIRScram_FunctionCall(){
    has_been_type_checked = FALSE;
  }
  virtual ~IIRScram_FunctionCall() = 0;
    
private:
  IIR_Boolean has_been_type_checked;
  IIR_Int32 _stmt_node_index;
};
#endif
