// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_InterfaceDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table *cgen_sym_tab_ptr;

IIRScram_InterfaceDeclaration::~IIRScram_InterfaceDeclaration() {}

void
IIRScram_InterfaceDeclaration::_publish_vhdl_mode(ostream &_vhdl_out){
  switch( get_mode() ) {
  case IIR_IN_MODE:
    _vhdl_out << "in";
    break;
  case IIR_OUT_MODE:
    _vhdl_out << "out";
    break;
  case IIR_INOUT_MODE:
    _vhdl_out << "inout";
    break;
  case  IIR_BUFFER_MODE:
    _vhdl_out << "buffer";
    break;
  case  IIR_LINKAGE_MODE:
    _vhdl_out << "linkage";
    break;
  case  IIR_UNKNOWN_MODE:
    break;
  default:
    cerr << "Wrong mode specification in" << get_kind_text() << endl;
    break;
  }
  _vhdl_out << " ";
}


IIR_Mode
IIRScram_InterfaceDeclaration::_get_mode(){
  return get_mode();
}

void 
IIRScram_InterfaceDeclaration::_type_check(){
  IIR_ObjectDeclaration::_type_check();

  if( get_mode() == IIR_LINKAGE_MODE && get_value() != NULL ){
    ostringstream err;
    err << "Interface |" << *get_declarator() << "| has been declared with linkage "
	<< "mode and therefore cannot have a default expression.";
    report_error( this, err.str() );
  }
}

IIR_Boolean 
IIRScram_InterfaceDeclaration::_is_array_type(){
  return get_subtype()->_is_array_type();
}

IIR_Boolean
IIRScram_InterfaceDeclaration::_is_record_type() {
  return get_subtype()->_is_record_type();
}

IIR_Boolean 
IIRScram_InterfaceDeclaration::_is_readable(){
  if( get_mode() == IIR_IN_MODE || get_mode() == IIR_INOUT_MODE || get_mode() == IIR_BUFFER_MODE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_InterfaceDeclaration::_is_writable(){
  if( get_mode() == IIR_OUT_MODE || get_mode() == IIR_INOUT_MODE || get_mode() == IIR_BUFFER_MODE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


ostream &
IIRScram_InterfaceDeclaration::_print( ostream &os ){
  os << *get_declarator();
  return os;
}

IIR_Int32 
IIRScram_InterfaceDeclaration::_get_num_indexes(){
  return get_subtype()->_get_num_indexes();
}

IIR_TypeDefinition *
IIRScram_InterfaceDeclaration::_get_type_of_element( int index ){
  if( index > _get_num_indexes() ){
    return NULL;
  }

  IIR_TypeDefinition *current_subtype = get_subtype();
  if( index == 0 ){
    return current_subtype;
  }

  int i;
  for( i = 0; i < index - 1; i++ ){
    ASSERT( current_subtype->_is_array_type() == TRUE );

    current_subtype = current_subtype->_get_element_subtype();
      
  }
  
  IIR_TypeDefinition *retval = current_subtype->_get_element_subtype();
  
  return retval;
}

void 
IIRScram_InterfaceDeclaration::_publish_cc_decl_subprogram_arg( published_file &_cc_out, 
								IIR_Boolean _to_publish_default_argument ){

  SCRAM_CC_REF( _cc_out, "IIRScram_InterfaceDeclaration::_publish_cc_decl_subprogram_arg" );

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }

  if (get_mode() == IIR_IN_MODE) {
    _cc_out << "const ";
  }

  _cc_out << get_subtype()->_get_cc_type_name();
  
  _cc_out << " &";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  
  if ((_get_currently_publishing_unit() == IIRScram::PROCEDURE) &&
      (get_mode() == IIR_IN_MODE))  {
    _cc_out << "_in";
  }
  
  if(_to_publish_default_argument == TRUE) {
    if(get_value() != NULL) {
      _cc_out << " = ";
      get_value()->_publish_cc_lvalue( _cc_out );
    }
  }
}


void 
IIRScram_InterfaceDeclaration::_publish_cc_constructor_args( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_InterfaceDeclaration::_publish_cc_decl_constructor_args" );

  _cc_out << OS("(ObjectBase::" + _get_cc_object_type());
  get_subtype()->_publish_cc_constructor_args_type_info( _cc_out,
							 get_value() );
  _cc_out << CS(")");
}

void
IIRScram_InterfaceDeclaration::_publish_cc_bounds( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_InterfaceDeclaration::_publish_cc_bounds" );

  ASSERT(get_subtype() != NULL);
  ASSERT(get_subtype()->_is_iir_type_definition() == TRUE);
  get_subtype()->_publish_cc_bounds( _cc_out );
}

void
IIRScram_InterfaceDeclaration::_publish_cc_universal_type( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_InterfaceDeclaration::_publish_cc_universal_type" );

  ASSERT(get_subtype() != NULL);
  ASSERT(get_subtype()->_is_iir_type_definition() == TRUE);
  get_subtype()->_publish_cc_universal_type( _cc_out );
}

void
IIRScram_InterfaceDeclaration::_publish_cc_value( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_InterfaceDeclaration::_publish_cc_value" );
  _publish_cc_rvalue( _cc_out );
  // In case this is a constant Interface then we have a pointer in case its a generate for statement
  if ( get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION && 
       _get_currently_publishing_unit() == IIRScram::GENERATE_FOR) {
    _cc_out << "->";
  } else {
    _cc_out << ".";
  }
  _cc_out << "getIntValue()";
}

void 
IIRScram_InterfaceDeclaration::_publish_cc_include( published_file &_cc_out ){
  get_subtype()->_publish_cc_include( _cc_out );
}

void
IIRScram_InterfaceDeclaration::_add_declarations_in_initializations() {
  if(get_value() != NULL) {
    get_value()->_add_decl_into_cgen_symbol_table();
  }
  if(get_subtype() != NULL) {
    get_subtype()->_add_decl_into_cgen_symbol_table();
  }
}


void 
IIRScram_InterfaceDeclaration::_add_decl_into_cgen_symbol_table() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  if(get_value() != NULL) {
    get_value()->_add_decl_into_cgen_symbol_table();
  }
}


void
IIRScram_InterfaceDeclaration::_clone( IIR *copy_into ) {
  ASSERT( copy_into->_is_iir_interface_declaration() == TRUE );
  IIRScram_Declaration::_clone( copy_into );

  IIR_InterfaceDeclaration *as_interface = (IIR_InterfaceDeclaration *)copy_into;

  as_interface->set_mode( get_mode() );
  as_interface->set_subtype( get_subtype() );
  as_interface->set_value( get_value() );
  as_interface->attributes = attributes;
}


IIR_Boolean 
IIRScram_InterfaceDeclaration::_is_optional(){
  if( get_value() == NULL ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}
