#ifndef IIRSCRAM_LIBRARY_DECLARATION_HH
#define IIRSCRAM_LIBRARY_DECLARATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_LibraryDeclaration.hh"

class IIR_List ;

/**
   The extension base for library declarations.
 */

class IIRScram_LibraryDeclaration : public IIRBase_LibraryDeclaration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  declaration_type _get_type();

  IIR_TypeDefinition *get_subtype( ){ return NULL; }

  IIR_Boolean _is_iir_library_declaration(){ return TRUE; }

  void _publish_vhdl_decl( ostream & );

  void _add_to_declarative_region( set<IIR_Declaration> * );

  void _set_path_to_directory( const string new_path );
  const string _get_path_to_directory(){ return path_to_directory; }

  /** Publishes the path into the stream that a C++ compiler needs to
      include in order to get the header files for this library. */
  void _publish_cc_include_path( ostream &os );

  /** Publishes the file name where that should be the result of code
      generation/compilation of this library. Doesn't publish anything
      for the standard library. */
  void _publish_cc_library_file_name( ostream &os );
  void _mangle_declarator();

protected:
  IIRScram_LibraryDeclaration() : path_to_directory( "" ){  }
  virtual ~IIRScram_LibraryDeclaration() = 0;
    
private:
  // This is a path (either relative or absolute, depending on how the
  // library manager was able to find it) to the directory that this declaration
  // is representing...
  string path_to_directory;
};
#endif
