#ifndef IIRSCRAM_LITERAL_HH
#define IIRSCRAM_LITERAL_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_Literal.hh"
class IIR_DesignatorList;
template <class type> class set;
class IIRScram_Literal : public IIRBase_Literal {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  IIR_Boolean _is_literal();
  IIR_Boolean _is_resolved();
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  IIR_Boolean _is_static_expression() { return TRUE;}

  IIR_Int32 _char_to_int(IIR_Char);
  void _get_list_of_input_signals( set<IIR> * ){}
  void _build_sensitivity_list(IIR_DesignatorList*){}
  virtual void _publish_cc_condition( published_file &_cc_out );
  virtual void _publish_cc_headers( published_file & ) {};
  
  virtual IIR_TypeDefinition *get_subtype();

  virtual void _set_subtype( IIR_TypeDefinition * );

  IIR *_rval_to_decl( IIR_TypeDefinition * );

  IIR_Boolean _is_locally_static_primary();
  // Inferred from the rules in 7.4.1 and 7.4.2 all literals are globally static.
  IIR_Boolean _is_globally_static_primary(){ return TRUE; }

protected:
  IIRScram_Literal(){
    my_type = NULL;
  };
  virtual ~IIRScram_Literal() = 0;
    
private:
  IIR_TypeDefinition *my_type;
};
#endif
