// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajsek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Magnus Danielson    cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_FloatingSubtypeDefinition.hh"
#include "StandardPackage.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_PhysicalTypeDefinition::~IIRScram_PhysicalTypeDefinition() {}

void 
IIRScram_PhysicalTypeDefinition::_publish_vhdl_type_decl(ostream &_vhdl_out) {
  _vhdl_out << " range ";
  get_left()->_publish_vhdl(_vhdl_out);

  ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);

  if( _is_ascending_range() == TRUE ){
    _vhdl_out << " to ";
  }
  else{
    _vhdl_out << " downto ";
  }

  get_right()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "\n";
  _vhdl_out << "  units\n    ";
  get_primary_unit()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
  units._publish_vhdl(_vhdl_out);
  _vhdl_out << "  end units";
}


bool
IIRScram_PhysicalTypeDefinition::_is_time() {
  int i = IIR_Identifier::_cmp((IIR_Identifier*)(_get_declaration()->get_declarator()), "time");
  return (i == 0);
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_elaborate( published_file &_cc_out ){
//   if (_is_time()) {
//     _cc_out << "PhysicalType";
//   }
//   else {
//     _cc_out << "Savant";
//     _get_declaration()->_get_declarator()->_publish_cc_elaborate( _cc_out );
//     _cc_out << "Type";
//   }

  _cc_out << "PhysicalType";
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_left( published_file &_cc_out ) {
  if (_is_scalar_type() == TRUE)  {
    _cc_out << _get_cc_kernel_type();
  }
  else {
    _cc_out << _get_cc_type_name();
  }
  _cc_out << OS("(ObjectBase::VARIABLE,");
  _cc_out << OS("(");
  if(_is_time() == TRUE) {
    _cc_out << "0";
  } else {
    _publish_cc_universal_type( _cc_out );
    _cc_out << OS("(");
    get_left()->_publish_cc_value( _cc_out );
    _cc_out << CS(")");
  }
  if(_is_subtype_decl() == FALSE) {
    _cc_out << " * ";		// All physical literals are LONG's
    ASSERT(get_primary_unit() != NULL);
    get_primary_unit()->_publish_cc_value( _cc_out );
  }
  
  _cc_out << CS(")");
  _publish_cc_object_type_info( _cc_out );
  _cc_out << CS(")");
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_right( published_file &_cc_out ) {
  _cc_out << _get_cc_type_name();
  _cc_out << OS("(ObjectBase::VARIABLE,");
  _cc_out << OS("(");
  if(_is_time() == TRUE) {
    _publish_cc_universal_type( _cc_out );
    _cc_out << "::getMax()";
  } else {
    _publish_cc_universal_type( _cc_out );
    _cc_out << OS("(");
    get_right()->_publish_cc_value( _cc_out );
    _cc_out << CS(")");
  }
  if(_is_subtype_decl() == FALSE) {
    _cc_out << " * ";		// All physical literals are LONG's
    ASSERT(get_primary_unit() != NULL);
    get_primary_unit()->_publish_cc_value( _cc_out );
  }
  _cc_out << CS("),");
  _publish_cc_object_type_info( _cc_out );
  _cc_out << CS(")");
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {
  _cc_out << "UniversalLongLongInteger";
}

const string  
IIRScram_PhysicalTypeDefinition::_get_cc_kernel_type(){
  return "PhysicalType";
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_data_members( published_file &_cc_out ) {
  // Publish the imageMap array
  int unit_counter=0;
  _cc_out << "  static UniversalLongLongInteger ";
  get_primary_unit()->_publish_cc_object_name( _cc_out );
  _cc_out << ";\n";
  _cc_out << "  static LONG sInfo[];\n";
  _cc_out << "  static char* uInfo[];\n";
 
  //Publish the function getFactor(char*)
  _cc_out << "static UniversalLongLongInteger getFactor(char* ptr) {\n";
  _cc_out << "if (strcmp(ptr, \"";
  get_primary_unit()->_publish_cc_object_name( _cc_out );
  _cc_out << "\") == 0) {\n";
  _cc_out << "return ";
  get_primary_unit()->_publish_cc_object_name( _cc_out );
  _cc_out << ";\n}\n";
  
  unit_counter = 0;
  IIR_PhysicalUnit* node = units.first();
  while(node != NULL) {
    unit_counter++;
    _cc_out << "if (strcmp(ptr, \"";
    node->_publish_cc_object_name( _cc_out );
    _cc_out << "\") == 0) {\n";
    _cc_out << "return ";
    _cc_out << _get_cc_type_name();
    _cc_out << "_info.scaleInfo[" << unit_counter << "] * ";
    get_primary_unit()->_publish_cc_object_name( _cc_out );
    _cc_out << ";\n}\n";
    node = units.successor(node);
  }
  _cc_out << "return 0;\n";
  _cc_out << "}\n";
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ) {
  int unit_counter=0;
  ostringstream classStream;
  string className;
  IIR_PhysicalUnit *node;

  _publish_cc_class_name( classStream );
  className = classStream.str();
  _get_declaration()->_publish_cc_include( _cc_out );
  _cc_out << "\n";

  if(_is_subtype_decl() == FALSE) {
    node = get_primary_unit();
    _cc_out << "UniversalLongLongInteger " << className << "::";
    node->_publish_cc_object_name( _cc_out );
    _cc_out << " = 1;\n";
    //Publishing UnitInfo
    IIR_PhysicalUnit* nodetemp = units.first();
    while(nodetemp != NULL){
      nodetemp = units.successor(nodetemp);
      unit_counter++;
    }
    _cc_out << "char *" << className << "::uInfo[" 
	    << unit_counter + 1 << "] = {\"";
    get_primary_unit()->_publish_cc_object_name( _cc_out );
    _cc_out << "\"";
     nodetemp = units.first();
     while(nodetemp != NULL){
       _cc_out << ", ";
       _cc_out << "\"";
       nodetemp->_publish_cc_object_name( _cc_out );
       _cc_out << "\"";
       nodetemp = units.successor(nodetemp);
     }
     _cc_out << "};\n";
     //Publishing ScaleInfo
     _cc_out << "LONG " << className << "::sInfo[" 
	     << unit_counter + 1<< "] = { 1";
    for (node = units.first(); node != NULL; node = units.successor(node)){
      _cc_out << ", ";
      nodetemp = node;
      ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_value( _cc_out );
      while(((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_unit_name() != get_primary_unit()){
	_cc_out << " * ";
	nodetemp = ((IIR_PhysicalLiteral *)nodetemp->get_multiplier())->get_unit_name();
      ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_value( _cc_out );
      }
    }
    _cc_out << "};\n";
  }
}


void 
IIRScram_PhysicalTypeDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  int unit_counter = 1;
  IIR_PhysicalUnit *node;

  SCRAM_CC_REF( _cc_out, "IIRScram_PhysicalTypeDefinition::_publish_cc_type_info" );
  
  IIR_PhysicalUnit* nodetemp = units.first();
  while(nodetemp != NULL){
    nodetemp = units.successor(nodetemp);
    unit_counter++;
  }
  
  if (_is_anonymous() == FALSE) {
    
    // The type info structure is published here...

    if( _get_currently_publishing_unit() == PROCEDURE ||
	_get_currently_publishing_unit() == FUNCTION  ||
	_get_currently_publishing_unit() == PACKAGE_BODY ||
	_get_currently_publishing_unit() == PACKAGE_PUB ){
      _cc_out << "  PhysicalTypeInfo ";
    }
    else {
      _cc_out << "  ";
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info(" << unit_counter << ", (LONG) ";
    get_left()->_publish_cc_value( _cc_out );
    _cc_out << ", ";

    if (get_direction()->_is_ascending_range() == TRUE) {
      _cc_out << "ArrayInfo::to";
    }
    else {
      _cc_out << "ArrayInfo::downto";
    }

    _cc_out << ", (LONG) ";
    get_right()->_publish_cc_value( _cc_out );

    //Publishing ScaleInfo
    _cc_out << ", PhysicalTypeInfo::createScaleMap(" << unit_counter
	    << ", LONG(1)";
    for (node = units.first(); node != NULL; node = units.successor(node)) {
      _cc_out << ", ";
      nodetemp = node;
      
      ASSERT (nodetemp->get_multiplier() != NULL);
      ASSERT (nodetemp->get_multiplier()->get_kind() == IIR_PHYSICAL_LITERAL);
      
      IIR_PhysicalLiteral *tempLit = (IIR_PhysicalLiteral *)
	node->get_multiplier();
      
      _cc_out << "LONG(";
      
      if (tempLit->get_abstract_literal() != NULL)  {
	tempLit->_publish_cc_universal_value( _cc_out );
      }
      else {
	_cc_out << " 1 ";
      }
      _cc_out << ")";
    }
    
    // Publishing unit info, .ie. imageMap string.s..
    _cc_out << "), TypeInfo::createImageMap("
	    << unit_counter;

    _cc_out << ", \"";

    ASSERT ( get_primary_unit() != NULL );
    
    get_primary_unit()->_publish_cc_object_name( _cc_out );
    _cc_out << "\"";
    
    nodetemp = units.first();
    while(nodetemp != NULL){
      _cc_out << ", \"";
      nodetemp->_publish_cc_object_name( _cc_out );
      _cc_out << "\"";
      nodetemp = units.successor(nodetemp);
    }
    
    _cc_out << "))\n";
  }
  
  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";\n  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    _cc_out << " {\n"
	    << "    return ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n"
	    << "  }\n\n";
  }
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_extern_type_info" );
  
  ASSERT ( _is_scalar_type() == TRUE );
  
  if (_is_anonymous() == FALSE) {
    if ((_get_currently_publishing_unit() == PACKAGE_PUB) ||
	(_get_currently_publishing_unit() == PACKAGE_BODY)) {
      _cc_out << "  extern PhysicalTypeInfo ";
      
    }
    else {
      _cc_out << "  PhysicalTypeInfo ";
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n";
    
    
    _cc_out << "  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    
    if ((_get_currently_publishing_unit() != PACKAGE_PUB) &&
	(_get_currently_publishing_unit() != PACKAGE_BODY)) {
      _cc_out << " const {\n"
	      << "    return (TypeInfo &) ";
      _publish_cc_lvalue( _cc_out );
      _cc_out << "_info;\n"
	      << "  }\n\n";
    }
    else {
      _cc_out << ";\n";
    }
  }
  else {
    ASSERT (_get_base_type() != NULL);
    if (_get_base_type()->_is_anonymous() == FALSE) {
      _get_base_type()->_publish_cc_extern_type_info( _cc_out );
    }
  }
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_type_string( published_file &_cc_out ){
  _cc_out << "PhysicalType";
}


IIR_TypeDefinition *
IIRScram_PhysicalTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}

IIR *
IIRScram_PhysicalTypeDefinition::_clone(){
  IIR_PhysicalTypeDefinition *retval = new IIR_PhysicalTypeDefinition();
  _clone( retval );
  return retval;
}

void 
IIRScram_PhysicalTypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_physical_type_definition() == TRUE );
  IIR_PhysicalTypeDefinition *as_physical_type = 
    (IIR_PhysicalTypeDefinition *)copy_into;

  as_physical_type->set_primary_unit( get_primary_unit() );
  as_physical_type->units = units;
  
  IIRScram_ScalarTypeDefinition::_clone( copy_into );
}

IIR_TypeDefinition *
IIRScram_PhysicalTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
							 IIR_ScalarTypeDefinition *new_constraint){
  IIR_PhysicalSubtypeDefinition *retval = 0;
  IIR_TypeDefinition *temp = 
    IIR_ScalarTypeDefinition::_construct_new_subtype( resolution_function,
						      new_constraint );
  ASSERT( temp->get_kind() == IIR_PHYSICAL_SUBTYPE_DEFINITION );
  retval = (IIR_PhysicalSubtypeDefinition *)temp;
  retval->set_primary_unit( get_primary_unit() );
  retval->units = units;

  return retval;
}


void 
IIRScram_PhysicalTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );

  IIR_TypeDefinition *integer_type = StandardPackage::get_integer_type();
  IIR_TypeDefinition *real_type =  StandardPackage::get_real_type();

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						this,
						integer_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						this,
						real_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						integer_type,
						this );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
					        real_type,
						this );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						this,
						this,
					        integer_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						this,
						this,
						real_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						StandardPackage::get_savant_universal_integer(),
						this,
					        this );
}

void 
IIRScram_PhysicalTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_PhysicalTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with an physical type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}


visitor_return_type *
IIRScram_PhysicalTypeDefinition::_accept_visitor( node_visitor *visitor, 
						  visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PhysicalTypeDefinition(this, arg);
}
