
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Kathiresan Nellayappan
//          Vasudevan Shanmugasundaram

#include "error_func.hh"
#include "IIRScram_SimpleSimultaneousStatement.hh"
#include "IIR_Identifier.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "IIR_Label.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_SubprogramDeclaration.hh"
#include "IIR_AssociationList.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_AssociationElement.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_AssociationList.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_ReferenceAttribute.hh"
#include "IIR_ContributionAttribute.hh"
#include "IIR_TerminalDeclaration.hh"
#include "IIR_MultiplicationOperator.hh"
#include "IIR_FloatingPointLiteral.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_ReferenceAttribute.hh"
#include "IIR_ContributionAttribute.hh"
#include "IIR_DotAttribute.hh"
#include "dl_list.hh"
#include "IIR_Attribute.hh"
#include "symbol_table.hh"
#include "published_file.hh"
#include "IIR_IndexedName.hh"
#include "sstream-wrap.hh"
#include <iostream>

using std::endl;
using std::ends;

extern symbol_table *cgen_sym_tab_ptr;
extern symbol_table *cgen_arch_sym_tab_ptr;

IIRScram_SimpleSimultaneousStatement::~IIRScram_SimpleSimultaneousStatement() {}

IIRScram_SimpleSimultaneousStatement::IIRScram_SimpleSimultaneousStatement() {
  enclosingRegion = NULL;
  _free_quantity_present = false;
  _stmt_qty_index = 0;
  _stmt_signal_index = 0;
  _stmt_node_index = 1;
}

void
IIRScram_SimpleSimultaneousStatement::_publish_vhdl(ostream &_vhdl_out) {
  if( get_label() != NULL ){
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " : ";
  }
  get_left_expression()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " == ";
  get_right_expression()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ; " << endl;

}

void
IIRScram_SimpleSimultaneousStatement::_type_check() {

  set<IIR_TypeDefinition> *lexp_lvals = get_left_expression()->_get_rval_set();
  if( lexp_lvals == NULL ){
    report_undefined_symbol( get_left_expression() );
    return;
  }
  set_right_expression(get_right_expression()->_semantic_transform(lexp_lvals));

  set<IIR_TypeDefinition> *rexp_rvals= get_right_expression()->_get_rval_set();

  if( rexp_rvals == NULL ){
    report_undefined_symbol( get_right_expression() );
    return;
  }

  set_left_expression( get_left_expression()->_semantic_transform( rexp_rvals ));

  delete lexp_lvals;
  delete rexp_rvals;

  lexp_lvals = get_left_expression()->_get_rval_set();
  rexp_rvals= get_right_expression()->_get_rval_set();

  reconcile_sets( lexp_lvals, rexp_rvals);
  switch ( lexp_lvals->num_elements() ){
  case 0: {
    ostringstream err;
    err << "Incompatible types in simultaneous statement : " << *get_left_expression()
        << " == " << *get_right_expression();
    report_error( this, err.str());
    break;
  }
  case 1: {
    set_right_expression( get_right_expression()->_rval_to_decl(rexp_rvals->get_element() ) );
    set_left_expression( get_left_expression()->_rval_to_decl(lexp_lvals->get_element() ) );
    break;
  }
  default:
    ostringstream err;
    err << "Ambiguous assignment - cannot resolve types";
    report_error(this, err.str());
    break;
  }
  delete lexp_lvals;
  delete rexp_rvals;
}

void
IIRScram_SimpleSimultaneousStatement::_publish_cc( published_file  &){
  cgen_sym_tab_ptr = &cgen_sym_tab;
}

void
IIRScram_SimpleSimultaneousStatement::_publish_cc_ams_function_prototype(
                                           published_file &_cc_out) {
  string design_unit_name;
  ostringstream ent_arch;
  _publish_cc(_cc_out);
   
  ent_arch << _get_current_architecture_name() << ends;
  design_unit_name = ent_arch.str();
 
  _cc_out << "equationNode *" << NL();
  _cc_out << "ams_rhs_expr_";
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << "( component *, bool& );" << NL();
}

void
IIRScram_SimpleSimultaneousStatement::_publish_cc_ams_function_body(published_file &_cc_out) {
 
  string design_unit_name;
  ostringstream ent_arch;
  IIR_Declaration *current_generic_constant = NULL;
  ent_arch << _get_current_architecture_name();
  design_unit_name = ent_arch.str();

  IIR *left_expr = get_left_expression();
  IIR *right_expr = get_right_expression();
    
  left_expr->_set_stmt_qty_index(&_stmt_qty_index, &_unique_qtys);
  right_expr->_set_stmt_qty_index(&_stmt_qty_index, &_unique_qtys);
  
  left_expr->_set_stmt_signal_index(&_stmt_signal_index, &_unique_signals);
  right_expr->_set_stmt_signal_index(&_stmt_signal_index, &_unique_signals);
 
  bool reducibleFlag = true; // all SSS are assumed reducible until they encounter a attr class
  left_expr->_set_stmt_node_index(&_stmt_node_index, false, reducibleFlag);
  right_expr->_set_stmt_node_index(&_stmt_node_index, true, reducibleFlag);

  // the following function call ensures that all the generic
  // parameters that are appearing in this particular statement
  // are declared as static variables in the function that we are publishing

  left_expr->_build_generic_parameter_set(&_unique_generic_constants);
  right_expr->_build_generic_parameter_set(&_unique_generic_constants);
  
  PublishedUnit _temp_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(SIMULTANEOUS_STATEMENT);

  _cc_out << "equationNode *" << NL();
  _cc_out << "ams_rhs_expr_";
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << "( component *currentEquation, bool &reducible ) {" << NL();

  left_expr->_publish_cc_ams_function_call_in_simult_stmt(_cc_out);
  right_expr->_publish_cc_ams_function_call_in_simult_stmt(_cc_out);

  //  to publish the generics in the component if any.
  for(current_generic_constant = _unique_generic_constants.get_element();
      current_generic_constant != NULL;
      current_generic_constant = _unique_generic_constants.get_next_element()) {
  
    _cc_out<<current_generic_constant->get_subtype()->_get_cc_type_name();
    _cc_out << " ";
    current_generic_constant->_get_declarator()->_publish_cc_lvalue(_cc_out);
    _cc_out << " = (("<<design_unit_name;
    _cc_out << "_elab*)currentEquation->getEnclosingBlock())->";
    current_generic_constant->_get_declarator()->_publish_cc_lvalue(_cc_out);
    _cc_out << "_info;" << NL();
  }

  _cc_out << "  equationNode *";
  _cc_out << "node1 = new equationNode('O',2,NULL);" << NL();

  left_expr->_publish_cc_ams_function(_cc_out);
  right_expr->_publish_cc_ams_function(_cc_out);

  _cc_out <<"  reducible = ";
  if ( reducibleFlag == true ) {
   _cc_out << "true;" << NL();
  }
  else {
   _cc_out << "false;" << NL();
  }
  _cc_out <<"  return node1;" << NL();
  _cc_out <<" }" << NL();

  left_expr->_flush_stmt_index();
  right_expr->_flush_stmt_index();
        
  _set_currently_publishing_unit(_temp_publishing_unit);

}

void
IIRScram_SimpleSimultaneousStatement::
_publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::SimultaneousIfPublishingPart current_part,
                                       published_file &_cc_out) {
  IIR_Declaration *is_Q2S = NULL;
  is_Q2S  = _unique_signals.get_element();

  for ( IIR_Declaration *temp  = _unique_qtys.get_element();
	temp != NULL;
	temp = _unique_qtys.get_next_element() ) {
    if ( temp->get_kind() == IIR_FREE_QUANTITY_DECLARATION ) {
      _free_quantity_present = true;
    }
  }
  if (_is_free_quantity_present()) {
    // For simultaneous Statements without signals..
    if (is_Q2S == NULL) {
      // this is a freeEquation ...
      _cc_out << "  equation = new freeEquation(";
      _cc_out << " this, parent_equation,";
      
      switch (current_part) {
      case IIRScram_ArchitectureStatement::None: {
        _cc_out << " -1 ,\"";
      }
	break;
      case IIRScram_ArchitectureStatement::IF_PART: {
        _cc_out << " YES,\"";
      }
	break;
      case IIRScram_ArchitectureStatement::ELSE_PART: {
        _cc_out << " NO,\"";
      }           
	break;
      default: {
        cerr << "Wrong enumeration for publishing simultaneous "
             << "if/elsif statement!!" << endl;
        cerr << "Aborting VHDL-AMS to C++ code generation ..." << endl;
        abort();
      }
	break;
      }
      _publish_cc_ams_equation_constructor(current_part,_cc_out);
    }
    else {  
      _cc_out << "  equation = new freeEquation(\"";
      _publish_cc_ams_equation_constructor(current_part,_cc_out);
    }
  }
  else {    
    // Simple sim statements without signal
    if (is_Q2S == NULL) {
      _cc_out << "equation = new branchEquation(this, parent_equation ,";
      switch (current_part) {
      case IIRScram_ArchitectureStatement::None: {
        _cc_out << " -1 ,\"";
      }
	break;
      case IIRScram_ArchitectureStatement::IF_PART: {
        _cc_out << " YES,\"";
      }
	break;
      case IIRScram_ArchitectureStatement::ELSE_PART: {
        _cc_out << " NO,\"";
      }
	break;
      default: {
        cerr << "Wrong enumeration for publishing simultaneous "
             << "if/elsif statement!!" << endl;
        cerr << "Aborting VHDL-AMS to C++ code generation ..." << endl;
        abort();
      }
	break;
      }
      _publish_cc_ams_equation_constructor(current_part,_cc_out);
      _cc_out <<NL();
    }
    else {
      _cc_out << "equation = new branchEquation(\"";
      _publish_cc_ams_equation_constructor(current_part,_cc_out);
    }
  }
  _publish_cc_implicit_reference_equations(_cc_out);
  _publish_cc_implicit_contribution_equations(_cc_out);
  _publish_cc_implicit_differential_equations(_cc_out);
}

void
IIRScram_SimpleSimultaneousStatement::
_publish_cc_ams_equation_constructor( SimultaneousIfPublishingPart current_part,
				      published_file &_cc_out ){
  IIR_Int32 temp = _unique_qtys.num_elements();
  IIR_Declaration *current_set_qty = NULL;
  
  IIR_Declaration *is2_Q2S = NULL;
  is2_Q2S  = _unique_signals.get_element();
      
  _get_label()->_publish_cc_lvalue(_cc_out);
    
  _cc_out << "\", ";
  _cc_out << "ams_rhs_expr_";
  _get_label()->_publish_cc_lvalue(_cc_out);

  if(is2_Q2S != NULL) {
    _cc_out << ",NULL,NULL";
  }  
  current_set_qty = _unique_qtys.get_element();
  _cc_out << ", "<<_unique_qtys.num_elements();
  if(_unique_qtys.num_elements() > 0 ) {
    _cc_out << ", ";
  }
  for( current_set_qty = _unique_qtys.get_element();
       current_set_qty != NULL;
       current_set_qty = _unique_qtys.get_next_element() ) {
     
    if( temp > 0 ) {
      _cc_out << "&(";
      current_set_qty->_publish_cc_lvalue(_cc_out);
      _cc_out << ") ";
      if( temp > 1 ) {
        _cc_out << ", ";
      }
      temp--;
    }
  } 
  _cc_out << " );" << NL();
           
  // add all the signals that appeared in this simultaneous statement
  /* for(current_set_signal = _unique_signals.get_element();
      current_set_signal != NULL;
      current_set_signal = _unique_signals.get_next_element() ) {
    
   //_cc_out << "equationSignal = new signalDS(&(";
   //current_set_signal->_publish_cc_elaborate(_cc_out);
   // the signals in the stmt are now published as
   // heap allocated objects in the architecture class.
   // hence the leading & has been removed.
   _cc_out << "), (";
   current_set_signal->_publish_cc_lvalue(_cc_out);
   _cc_out << ") );\n";
   _cc_out << "equation->addSignal(equationSignal);\n";
   _cc_out << "add(equation);\n";
  } */  
}
 
IIR_Boolean
IIRScram_SimpleSimultaneousStatement::_is_simultaneous_statement() {
  return TRUE;
}

IIR_Boolean
IIRScram_SimpleSimultaneousStatement::_is_free_quantity_present() {
  return _free_quantity_present;
}

void
IIRScram_SimpleSimultaneousStatement::_publish_cc_implicit_reference_equations(published_file &_cc_out) {
  IIR_ReferenceAttribute *current_reference_attribute = NULL;
  dl_list<IIR_ReferenceAttribute> reference_quantity_list;
    
  IIR *lhs_expr = get_left_expression();
  if( lhs_expr->_reference_quantity_found() == TRUE ) {
    lhs_expr->_build_reference_quantity_list(&reference_quantity_list);
  }  
  IIR *rhs_expr = get_right_expression();
  if( rhs_expr->_reference_quantity_found() == TRUE ) {
    rhs_expr->_build_reference_quantity_list(&reference_quantity_list);
  }
  for(current_reference_attribute = reference_quantity_list.first();
      current_reference_attribute != NULL;
      current_reference_attribute =
        reference_quantity_list.successor(current_reference_attribute)) {
    _cc_out << "  equation = new freeEquation( this,parent_equation,-1,\"referEqn\",referFunction";
    _cc_out << ", &(";
    
    ((IIR_Attribute*)current_reference_attribute)->_get_implicit_declaration()->_publish_cc_lvalue(_cc_out);
    _cc_out << "), ";
    if(current_reference_attribute->get_prefix()->_is_interface() == FALSE) {
      _cc_out << "&(";
      current_reference_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")";
    }
    else {
      _cc_out << "(";
      current_reference_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")"; 
    }
    _cc_out << ");" << NL();
  }
}

void
IIRScram_SimpleSimultaneousStatement::_publish_cc_implicit_contribution_equations(published_file &_cc_out) {
  IIR_ContributionAttribute *current_contribution_attribute = NULL;
  dl_list<IIR_ContributionAttribute> contribution_quantity_list;
  IIR *lhs_expr = get_left_expression();
  if( lhs_expr->_contribution_quantity_found() == TRUE ) {
    lhs_expr->_build_contribution_quantity_list(&contribution_quantity_list);
  }  
  IIR *rhs_expr = get_right_expression();
  if( rhs_expr->_contribution_quantity_found() == TRUE ) {
    rhs_expr->_build_contribution_quantity_list(&contribution_quantity_list);
  } 
  for(current_contribution_attribute = contribution_quantity_list.first();
      current_contribution_attribute != NULL;
      current_contribution_attribute =
        contribution_quantity_list.successor(current_contribution_attribute)) {
    _cc_out << "  equation = new freeEquation( this,parent_equation,-1,\"contrEqn\",contribFunction";
    _cc_out << ", &(";
    
    ((IIR_Attribute*)current_contribution_attribute)->_get_implicit_declaration()->_publish_cc_lvalue(_cc_out);
    _cc_out << "), ";
    if(current_contribution_attribute->get_prefix()->_is_interface() == FALSE) {
      _cc_out << "&(";
      current_contribution_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")";
    }
    else {
      _cc_out << "(";
      current_contribution_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")";
    }
    _cc_out << ");" << NL();
  }
}
      
void
IIRScram_SimpleSimultaneousStatement::_publish_cc_implicit_differential_equations(published_file &_cc_out) {
  IIR_DotAttribute *current_dot_attribute = NULL;
  dl_list<IIR_DotAttribute> differential_quantity_list;
  
  IIR *lhs_expr = get_left_expression(); 
  if( lhs_expr->_differential_quantity_found() == TRUE ) {
    lhs_expr->_build_differential_quantity_list(&differential_quantity_list);
     }
  
  IIR *rhs_expr = get_right_expression();
  if( rhs_expr->_differential_quantity_found() == TRUE ) {
         rhs_expr->_build_differential_quantity_list(&differential_quantity_list);
     }
  
  for(current_dot_attribute = differential_quantity_list.first();
      current_dot_attribute != NULL;
      current_dot_attribute =
	differential_quantity_list.successor(current_dot_attribute)) {
    
    _cc_out << "  equation = new differentialEquation( parent_equation,\"";
    _get_label()->_publish_cc_lvalue(_cc_out);
    _cc_out << "\", &(";
    ((IIR_Attribute*)current_dot_attribute)->_get_implicit_declaration()->_publish_cc_lvalue(_cc_out);
    _cc_out << "), ";
    if(current_dot_attribute->get_prefix()->_is_interface() == FALSE) {
      _cc_out << "&(";
      current_dot_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")";
    }
    else {
      _cc_out << "(";
      current_dot_attribute->get_prefix()->_publish_cc_lvalue(_cc_out);
      _cc_out << ")";
    }
    _cc_out << ");" << NL();
  }
}
