
#ifndef IIRSCRAM_TYPE_CONVERSION_HH
#define IIRSCRAM_TYPE_CONVERSION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur    
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan
//          Krishnan Subramani  

#include "IIRBase_TypeConversion.hh"

template <class type> class set;

class IIR_DesignatorList;

class IIRScram_TypeConversion : public IIRBase_TypeConversion {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );

  /** Publishes the 'pos attribute appearing in a simultaneous
      statement. */
  void _publish_cc_ams_function( published_file &_cc_out );

  /** Sets the equation node values for the simultanesous statement. */
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);

  void _get_list_of_input_signals( set<IIR> * );
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  void _type_check( set<IIR_TypeDefinition> * ){}
  IIR_Boolean _is_resolved();
  IIR_TypeDefinition *get_subtype();
  set<IIR_TypeDefinition> *_get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  ostream &_print( ostream & );

  IIR_Declaration *_find_formal_declaration();

  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_globally_static_primary();

protected:
  IIRScram_TypeConversion() {};
  virtual ~IIRScram_TypeConversion() = 0;
    
private:
  IIR_Int32 _stmt_node_index;
};
#endif
