// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_ValAttribute.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_VariableInterfaceDeclaration.hh"
#include "error_func.hh"
#include "set.hh"
#include "StandardPackage.hh"
#include "sstream-wrap.hh"


IIRScram_ValAttribute::~IIRScram_ValAttribute() {}

void 
IIRScram_ValAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL && get_suffix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'VAL (";
  get_suffix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") ";
}


void 
IIRScram_ValAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_type_attribute( _cc_out, "VAL", TRUE );
}


IIR_TextLiteral *
IIRScram_ValAttribute::_build_attribute_name() {
  char *name = "val";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_TypeDefinition *
IIRScram_ValAttribute::get_subtype(){
  return _get_prefix_subtype();
}


IIR_Declaration *
IIRScram_ValAttribute::_get_implicit_declaration( const string &decl_name, 
						  IIR_TypeDefinition *decl_type ){
  IIR_FunctionDeclaration *retval;

  IIR_TypeDefinition *integer_type = (IIR_TypeDefinition*)
    StandardPackage::get_savant_universal_integer();

  retval = new IIR_FunctionDeclaration();
  copy_location( this, retval );
  retval->set_declarator( IIR_Identifier::get( decl_name ));
  retval->set_return_type( decl_type );

  char *param_name = "X";
  IIR_VariableInterfaceDeclaration *param_decl = new IIR_VariableInterfaceDeclaration();
  copy_location( this, param_decl );
  param_decl->set_declarator( IIR_Identifier::get( param_name, strlen(param_name) ) );
  param_decl->set_subtype( integer_type );

  retval->interface_declarations.append( param_decl );

  return retval;
}

void 
IIRScram_ValAttribute::_resolve_suffix_special(){
  if( get_suffix() != NULL && get_suffix()->_is_resolved() == FALSE ){

    ASSERT( get_prefix()->_is_resolved() == TRUE );

    set<IIR_TypeDefinition> *suffix_types = get_suffix()->_get_rval_set();
    if( suffix_types == NULL ){
      report_undefined_symbol( get_suffix() );
    }

    suffix_types->reduce_set( &IIR::_is_integer_type );
    
    switch( suffix_types->num_elements() ){
    case 0:{
      ostringstream err;
      err << "|" << *get_suffix() << "| is not a valid suffix for |" << *this << "|.";
      err << " The suffix must be a locally static expression of an integer type.";
    
      report_error( this, err.str() );
      break;
    }
    case 1:{
      IIR_TypeDefinition *suffix_type = suffix_types->get_element();

      set_suffix( get_suffix()->_semantic_transform( suffix_type ) );
      get_suffix()->_type_check( suffix_type );
      
      set_suffix( get_suffix()->_rval_to_decl( suffix_type ));
      break;
    }
    default:{
      report_ambiguous_error( get_suffix(), suffix_types );
      break;
    }
    }
  }  
}

visitor_return_type *IIRScram_ValAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ValAttribute(this, arg);
};
