/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkframe.h>
#include "sg_toolbox.h"
#include "sg_toolbox_icons.h"
#include "../pixmaps/as.xpm"

#define NROWS 8
#define NCOLS 2

static const gchar *tip_text[8][2] = {{"Select", "Zoom"},
				      {"Select point", "Data Marker"},
				      {"Text", "Line/Arrow"},
				      {"Rectangle", "Ellipse"},
				      {"Autoscale", "Fit page inside window"},
				      {"Zoom in on data", "Zoom out from data"},
		 		      {"Scroll up", "Scroll down"},
				      {"Scroll left", "Scroll right"},
                                     };

static void         sg_toolbox_class_init      (SGtoolboxClass *klass);
static void         sg_toolbox_init            (SGtoolbox      *toolbox);
static void         sg_toolbox_size_allocate   (GtkWidget *widget,
						GtkAllocation *allocation);
static void         select_tool                (GtkWidget *widget, 
                                                gpointer data);

static GtkHandleBoxClass *parent_class = NULL;

static void
sg_toolbox_class_init (SGtoolboxClass * klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  parent_class = (GtkHandleBoxClass *) gtk_type_class (gtk_handle_box_get_type ());
  object_class = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;

  widget_class->size_allocate = sg_toolbox_size_allocate;
}

static void
select_tool(GtkWidget *widget, gpointer data)
{
  gint row, column;
  GdkGC *xor_gc, *selected_gc;
  GdkGCValues values;
  GtkWidget *tool;
  SGtoolbox *toolbox;
 
  toolbox = SG_TOOLBOX(data);

  selected_gc=widget->style->fg_gc[GTK_STATE_SELECTED];

  if (!selected_gc) return;
    
  gdk_gc_get_values(selected_gc, &values);
  values.function = GDK_INVERT;
  values.foreground = widget->style->white;
  values.subwindow_mode = GDK_INCLUDE_INFERIORS;
  xor_gc = gdk_gc_new_with_values(widget->window,
                                  &values,
     (GdkGCValuesMask)(GDK_GC_FOREGROUND | GDK_GC_FUNCTION | GDK_GC_SUBWINDOW));

  gdk_gc_set_foreground(xor_gc, &widget->style->bg[GTK_STATE_SELECTED]);

  for(row = 0; row < NROWS-4; row++){
    for(column = 0; column < NCOLS; column++){
       tool = toolbox->button[row][column];
       if(tool != widget){
          if(GTK_TOGGLE_BUTTON(tool)->active == TRUE)
              gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                                 xor_gc,
                                 TRUE, 2, 2, 28, 28);
          GTK_BUTTON(tool)->button_down=FALSE;
          GTK_TOGGLE_BUTTON(tool)->active=FALSE;
          gtk_widget_set_state(tool, GTK_STATE_NORMAL);
       }else{
          if(GTK_TOGGLE_BUTTON(tool)->active != TRUE)
              gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                                 xor_gc,
                                 TRUE, 2, 2, 28, 28);
          GTK_BUTTON(tool)->button_down=TRUE;
          GTK_TOGGLE_BUTTON(tool)->active=TRUE;
          gtk_widget_set_state(tool, GTK_STATE_ACTIVE);
       }
       if(GTK_TOGGLE_BUTTON(tool)->active == TRUE)
          gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                             xor_gc,
                             TRUE, 2, 2, 28, 28);
       gtk_widget_queue_draw(tool);
    }
   }

}

static void
sg_toolbox_init (SGtoolbox *toolbox)
{
  GtkTable *table;
  GtkWidget *widget;
  GtkWidget *button;
  gint i, j;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GtkWidget *box;
  GtkWidget *spin;
  GtkTooltips *tooltips;
  GdkColormap *colormap;
  GtkAdjustment *adj;

  widget = GTK_WIDGET(toolbox);

  gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(widget), GTK_POS_TOP);
  toolbox->table = gtk_table_new(16, 2, FALSE);

  table = GTK_TABLE(toolbox->table);

  gtk_container_set_border_width(GTK_CONTAINER(widget), 2);
  gtk_container_add(GTK_CONTAINER(widget), toolbox->table);

  colormap = gdk_colormap_get_system();

  for(i = 0; i < NROWS; i++){
    for(j = 0; j < NCOLS; j++){

      if(i < 2){
        toolbox->button[i][j] = gtk_toggle_button_new();

        gtk_table_attach (GTK_TABLE(table),
                          toolbox->button[i][j],
                          j, j+1, i, i+1, GTK_SHRINK, GTK_SHRINK, 0, 0);

        gtk_signal_connect (GTK_OBJECT (toolbox->button[i][j]), "toggled",
                            (GtkSignalFunc) select_tool,
                            toolbox);
      }
      if(i > 1 && i < NROWS-4){
        toolbox->button[i][j] = gtk_toggle_button_new();

        gtk_table_attach (GTK_TABLE(table),
                          toolbox->button[i][j],
                          j, j+1, i+1, i+2, GTK_SHRINK, GTK_SHRINK, 0, 0);

        gtk_signal_connect (GTK_OBJECT (toolbox->button[i][j]), "toggled",
                            (GtkSignalFunc) select_tool,
                            toolbox);
      }
      if(i >= NROWS - 4){
        toolbox->button[i][j] = gtk_button_new();

        gtk_table_attach (GTK_TABLE(table),
                          toolbox->button[i][j],
                          j, j+1, i+2, i+3, GTK_SHRINK, GTK_SHRINK, 0, 0);
      }

      gtk_button_set_relief(GTK_BUTTON(toolbox->button[i][j]),
                            GTK_RELIEF_NONE);


      gtk_widget_set_usize(toolbox->button[i][j], 38, 38);
      gtk_widget_show(toolbox->button[i][j]);

      tooltips = gtk_tooltips_new();
      gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		           toolbox->button[i][j],
                           tip_text[i][j],
		 	   tip_text[i][j]);
      gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
      gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

    }
  }

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[0][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             zoom);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[0][1]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             target);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[1][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             markers_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[1][1]),pixmap);
  gtk_widget_show(pixmap);

  gtk_table_attach(table, gtk_hseparator_new(), 0, 2, 2, 3,
                   GTK_FILL, GTK_SHRINK, 5, 5);
/********************************************************************/

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             text);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[2][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             linearrow_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[2][1]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             rectangle_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[3][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             ellipse_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[3][1]),pixmap);
  gtk_widget_show(pixmap);

  gtk_table_attach(table, gtk_hseparator_new(), 0, 2, 5, 6,
                   GTK_FILL, GTK_SHRINK, 5, 5);
/********************************************************************/

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             as_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[4][0]),pixmap);
  gtk_widget_show(pixmap);

/*
  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             fitpage_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[4][1]),pixmap);
  gtk_widget_show(pixmap);

*/
  gtk_container_remove(GTK_CONTAINER(toolbox->table), toolbox->button[4][1]);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             zoom_plus_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[5][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             zoom_minus_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[5][1]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow_up_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[6][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow_down_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[6][1]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow_left_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[7][0]),pixmap);
  gtk_widget_show(pixmap);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow_right_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[7][1]),pixmap);
  gtk_widget_show(pixmap);

/*************************************************************/
  gtk_table_attach(table, gtk_hseparator_new(), 0, 2, 10, 11,
                   GTK_FILL, GTK_SHRINK, 5, 5);

  button = toolbox->rotate_x = gtk_button_new();
  gtk_button_set_relief(GTK_BUTTON(toolbox->rotate_x), GTK_RELIEF_NONE);
  gtk_table_attach (GTK_TABLE(table),
                    button,
                    0, 1, 11, 12, GTK_SHRINK, GTK_SHRINK, 0, 0);
  tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		       button, "Rotate X", "Rotate X");
  gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
  gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             rotate_x_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(button),pixmap);
  gtk_widget_show(pixmap);

  button = toolbox->rotate_y = gtk_button_new();
  gtk_button_set_relief(GTK_BUTTON(toolbox->rotate_y), GTK_RELIEF_NONE);
  gtk_table_attach (GTK_TABLE(table),
                    button,
                    1, 2, 11, 12, GTK_SHRINK, GTK_SHRINK, 0, 0);
  tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		       button, "Rotate Y", "Rotate Y");
  gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
  gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             rotate_y_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(button),pixmap);
  gtk_widget_show(pixmap);

  button = toolbox->rotate_z = gtk_button_new();
  gtk_button_set_relief(GTK_BUTTON(toolbox->rotate_z), GTK_RELIEF_NONE);
  gtk_table_attach (GTK_TABLE(table),
                    button,
                    0, 1, 12, 13, GTK_SHRINK, GTK_SHRINK, 0, 0);
  tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		       button, "Rotate Z", "Rotate Z");
  gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
  gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             rotate_z_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(button),pixmap);
  gtk_widget_show(pixmap);

  button = toolbox->reset = gtk_button_new();
  gtk_button_set_relief(GTK_BUTTON(toolbox->reset), GTK_RELIEF_NONE);
  gtk_table_attach (GTK_TABLE(table),
                    button,
                    1, 2, 12, 13, GTK_SHRINK, GTK_SHRINK, 0, 0);
  tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		       button, "Reset", "Reset");
  gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
  gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             reset_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(button),pixmap);
  gtk_widget_show(pixmap);

/*    
  gtk_table_attach(GTK_TABLE(table),gtk_hseparator_new(),0,2,14,15,
                   GTK_FILL,GTK_SHRINK,5,5);
  gtk_table_attach(GTK_TABLE(table), box = gtk_hbox_new(0,FALSE),0,2,16,17,
                   GTK_SHRINK,GTK_SHRINK,0,0);
  gtk_box_pack_start(GTK_BOX(box),gtk_label_new("%"), TRUE, TRUE, 0);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 200., 5., 10., 0.);
  toolbox->magnification_spin = spin = gtk_spin_button_new(adj, 5, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin), TRUE);
  gtk_box_pack_start(GTK_BOX(box),spin, TRUE, TRUE, 0);
  gtk_widget_show(spin);
*/
}

guint
sg_toolbox_get_type ()
{
  static guint toolbox_type = 0;

  if (!toolbox_type)
    {
      GtkTypeInfo toolbox_info =
      {
	"SGtoolbox",
	sizeof (SGtoolbox),
	sizeof (SGtoolboxClass),
	(GtkClassInitFunc) sg_toolbox_class_init,
	(GtkObjectInitFunc) sg_toolbox_init,
	NULL,
	NULL,
	(GtkClassInitFunc) NULL,
      };
      toolbox_type = gtk_type_unique (gtk_handle_box_get_type(), &toolbox_info);
    }
  return toolbox_type;
}

GtkWidget *
sg_toolbox_new ()
{
  SGtoolbox *toolbox;

  toolbox = (SGtoolbox *)gtk_type_new (sg_toolbox_get_type ());

  return(GTK_WIDGET(toolbox));
}

static void
sg_toolbox_size_allocate    (GtkWidget *widget, GtkAllocation *allocation)
{
  GtkHandleBox *hb;
  GtkRequisition requisition;
  GtkAllocation child_allocation;
  gint width, height;

  hb = GTK_HANDLE_BOX(widget);
  if(hb->child_detached){
     gtk_widget_size_request(SG_TOOLBOX(widget)->table, &requisition);
     child_allocation.height = requisition.height + 10;
     child_allocation.width = requisition.width;

     child_allocation.height += 2 * GTK_CONTAINER(widget)->border_width + 1;
     child_allocation.width += 2 * GTK_CONTAINER(widget)->border_width;

     child_allocation.x = GTK_CONTAINER(widget)->border_width;
     child_allocation.y = 10 + GTK_CONTAINER(widget)->border_width;
     if (GTK_WIDGET_REALIZED (hb))
       {
         gdk_window_resize (hb->float_window,
                            child_allocation.width,
                            child_allocation.height);
         gdk_window_move_resize (hb->bin_window,
                                 0,
                                 0,
                                 child_allocation.width,
                                 child_allocation.height);
         gdk_window_get_size(widget->window, &width, &height);
       }
      child_allocation.height -= 10;
      gtk_widget_size_allocate(GTK_BIN(widget)->child, &child_allocation); 
  } else {
     GTK_WIDGET_CLASS(parent_class)->size_allocate(widget, allocation);
  }
}

