/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_TOOLBOX_H__
#define __SG_TOOLBOX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define SG_TOOLBOX(obj)			GTK_CHECK_CAST (obj, sg_toolbox_get_type (), SGtoolbox)
#define SG_TOOLBOX_CLASS(klass)	GTK_CHECK_CLASS_CAST (klass, sg_toolbox_get_type (), SGtoolboxClass)
#define SG_IS_TOOLBOX(obj)       GTK_CHECK_TYPE (obj, sg_toolbox_get_type ())

typedef struct _SGtoolbox	SGtoolbox;
typedef struct _SGtoolboxClass	SGtoolboxClass;

/* you should access only the entry and list fields directly */
struct _SGtoolbox {
        GtkHandleBox handle_bar;

	GtkWidget *table;

        GtkWidget *button[8][2];
        GtkWidget *magnification_spin;

        GtkWidget *rotate_x, *rotate_y, *rotate_z, *reset;

        gint nrows;
        gint ncols;
        gint row;
        gint column;
};

struct _SGtoolboxClass {
	GtkHandleBoxClass parent_class;
};

guint      sg_toolbox_get_type              (void);

GtkWidget *sg_toolbox_new                   (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_TOOLBOX_H__ */
