/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include "sg_worksheet_file_ascii.h"

static void write_col_title_ascii		(SGworksheetfile *file,
                                                 gint col); 
static void write_cell_ascii			(SGworksheetfile *file,  
						 gint row, gint col);
static void new_row_ascii			(SGworksheetfile *file,
						 gint row); 

gboolean
sg_worksheet_file_export_ascii (SGworksheet *worksheet, 
                                gchar *filename,
                                GtkSheetRange *range)
{  
  SGworksheetfile *file;
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet->sheet);
  file = sg_worksheet_file_new(worksheet, filename);

  if ((file->file = fopen(file->filename, "w")) == NULL){
       g_warning("ERROR: Cannot write to file: %s", filename);
       g_free(file);
       return FALSE;
  }

  file->write_col_title = write_col_title_ascii; 
  file->write_cell = write_cell_ascii; 
  file->new_row = new_row_ascii; 

  sg_worksheet_file_export(file, range);

  fclose(file->file);

  g_free(file->filename);
  g_free(file);

  return TRUE;
}

static void
new_row_ascii(SGworksheetfile *file, gint row)
{

  fprintf(file->file, "\n"); 

}

static void
write_col_title_ascii(SGworksheetfile *file, gint col) 
{
  gchar *title;

  title = GTK_SHEET(file->worksheet->sheet)->column[col].name;

  fprintf(file->file, " %s", title);
}

static void
write_cell_ascii(SGworksheetfile *file, gint row, gint col)
{
  gchar *text;
  
  text = sg_worksheet_cell_get_text(file->worksheet, row, col); 
  if(text && strlen(text) > 0)
          fprintf(file->file, " %s", text);

}

