/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_WRAP__
#define __SG_WRAP__

#include "sg_worksheet.h"
#include "sg_plot.h"
#include "sg_layer.h"
#include "sg_dataset.h"

enum {
      WRAP_OK,
      WRAP_WARNING,
      WRAP_ERROR,
};

SGworksheet	*new_worksheet			(gchar *name);
gint		update_worksheet		(gchar *old_name); 
gint 		set_cell_value			(gchar *worksheet,
                                                 gchar *col_name,
						 gint row, 
						 gdouble value);
gint 		set_cell_text			(gchar *worksheet,
                                                 gchar *col_name,
						 gint row, 
						 gchar *text);
gdouble 	get_cell_value			(gchar *worksheet,
                                                 gchar *col_name,
						 gint row);
gchar *		get_cell_text			(gchar *worksheet,
                                                 gchar *col_name,
						 gint row);
gint		set_column_name			(gchar *worksheet,
						 gchar *col_name,
						 gchar *new_name);
gint		set_column_values		(gchar *worksheet,
                                                 gchar *col_name,
						 gchar *exp,
						 gint from_row,
						 gint to_row);
gint		set_column_type			(gchar *worksheet,
                                                 gchar *col_name,
						 SGcolumntype type);
gint		set_column_numbers		(gchar *worksheet,
                                                 gchar *col_name,
						 SGcolumninternal internal,
						 SGcolumnformat format,
						 gint precision);
SGplot* 	new_plot			(gchar *name, SGlayerType type);
gint 		remove_layer			(gchar *plot_name, gint nth);
gint 		move_layer			(gchar *plot_name, gint nth, 
						 gdouble x, gdouble y);
gint 		resize_layer			(gchar *plot_name, gint nth, 
						 gdouble w, gdouble h);

GList *get_worksheet_names(void);
GList *get_layer_data_names(SGlayer *layer);
gchar *get_active_worksheet_name(void);
gchar *get_active_plot_name(void);
gint  get_active_layer(SGplot *plot);

gint 		remove_worksheet		(gchar *name);
gint 		rename_worksheet		(gchar *old_name, 
						 gchar *new_name);
gint	 	read_file			(gchar *worksheet,
						 gchar *path);
gint 		remove_plot			(gchar *name);
gint 		rename_plot			(gchar *old_name, 
						 gchar *new_name);
SGlayer* 	new_layer			(gchar *plot_name,
						 SGlayerType type);
gint 		clear_layer			(gchar *plot_name,
						 gint nth);
gint 		clear_plot			(gchar *name);
gint 		show_legends			(gchar *plot_name, 
						 gint nth); 
gint 		hide_legends			(gchar *plot_name, 
						 gint nth); 
gint 		move_legends			(gchar *plot_name, 
						 gint nth,
                                                 gdouble x, gdouble y); 
gint 		set_xrange			(gchar *plot_name, 
						 gint nth, 
						 gdouble xmin, gdouble xmax);
gint 		set_yrange			(gchar *plot_name, 
						 gint nth, 
						 gdouble ymin, gdouble ymax);
gint 		set_zrange			(gchar *plot_name, 
						 gint nth, 
						 gdouble zmin, gdouble zmax);
gint 		set_xticks			(gchar *plot_name, 
						 gint nth, 
						 gdouble major, gint nminor);
gint 		set_yticks			(gchar *plot_name, 
						 gint nth, 
						 gdouble major, gint nminor);
gint 		set_zticks			(gchar *plot_name, 
						 gint nth, 
						 gdouble major, gint nminor);
gint 		set_xtitle			(gchar *plot_name, 
						 gint nth, 
						 gchar *title);
gint 		set_ytitle			(gchar *plot_name, 
						 gint nth, 
						 gchar *title);
gint 		set_ztitle			(gchar *plot_name, 
						 gint nth, 
						 gchar *title);
gint 		show_xgrids			(gchar *plot_name,
						 gint nth);
gint 		show_ygrids			(gchar *plot_name,
						 gint nth);
gint 		show_zgrids			(gchar *plot_name,
						 gint nth);
gint 		hide_xgrids			(gchar *plot_name,
						 gint nth);
gint 		hide_ygrids			(gchar *plot_name,
						 gint nth);
gint 		hide_zgrids			(gchar *plot_name,
						 gint nth); 
gint 		set_symbol			(gchar *plot_name, 
						 gint nth, gint symbol);
gint 		set_symbol_style		(gchar *plot_name, 
						 gint nth, gint style);
gint 		set_symbol_color		(gchar *plot_name, 
						 gint nth, gchar *color);
gint 		set_line_style			(gchar *plot_name, 
						 gint nth, gint style);
gint 		set_line_color			(gchar *plot_name, 
						 gint nth, gchar *color);
gint 		set_connector			(gchar *plot_name, 
						 gint nth, gint connector);
gint 		plot_exp_xy			(gchar *plot_name, 
						 gint nth, 
                                                 gchar *expx, gchar *expy,
                                                 gchar *exp_name);
gint            plot_exp_xy_bars                (gchar *plot_name,
                                                 gint nth, 
                                                 gchar *expx, gchar *expy, gchar *exp_name, 
                                                 SGdataStyle orient, gfloat bin_width);

gint 		plot_exp			(gchar *plot_name, 
						 gint nth, gchar *exp,
                                                 gchar *exp_name);
GList           *get_column_names               (SGworksheet *worksheet);

#endif /* __SG_WRAP__ */

