/*
 * $Id: g_transport.h,v 1.5 2002/03/22 16:19:18 schoenw Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean & Jochen Friedrich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 */

#ifndef _G_TRANSPORT_H_
#define _G_TRANSPORT_H_

#include "g_snmp.h"

/*
 * Enumeration for the SNMP transport domains we care of.
 */

typedef enum {
    G_SNMP_TDOMAIN_NONE		= 0,
    G_SNMP_TDOMAIN_UDP_IPV4	= 1,
    G_SNMP_TDOMAIN_UDP_IPV6	= 2,
    G_SNMP_TDOMAIN_IPX		= 3
} GSnmpTDomain;

/*
 * The maximum datagram size we are prepared to deal with.
 */

#define MAX_DGRAM_SIZE 32768

typedef struct _GSnmpTransport {
    GSnmpTDomain tdomain;	/* transport domain */
    gchar	 *name;		/* name of the transport domain */
    gboolean (*sendMessage) (
	struct sockaddr *transportAddress,
	guchar          *outgoingMessage,
	guint           outgoingMessageLength);
    void     (*receiveMessage) ();
    gboolean (*resolveAddress) (
	gchar           *taddress,
	guint16         port,
	struct sockaddr **address);
    guint    (*getSocket) ();
} GSnmpTransport;

gboolean g_snmp_transport_init(gboolean dobind);

#endif /* _G_TRANSPORT_H_ */
