#ifndef SCREEM_DTD_DB_H
#define SCREEM_DTD_DB_H

#include <glib-object.h>

#include <gtk/gtkliststore.h>
#include <gtk/gtkwidget.h> /* for fill_combo */

#include "screem-dtd.h"

#define SCREEM_TYPE_DTD_DB            (screem_dtd_db_get_type ())
#define SCREEM_DTD_DB(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_DTD_DB, ScreemDTDDB))
#define SCREEM_DTD_DB_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_DTD_DB, ScreemDTDDBClass))
#define SCREEM_IS_DTD_DB(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_DTD_DB))

typedef struct ScreemDTDDBPrivate ScreemDTDDBPrivate;

typedef struct  {
	GObject parent;

	ScreemDTDDBPrivate *priv;
} ScreemDTDDB;

typedef struct {
        GObjectClass parent_class;

} ScreemDTDDBClass;

ScreemDTDDB *screem_dtd_db_new( void );
GType screem_dtd_db_get_type( void );

GtkListStore *screem_dtd_db_get_store( ScreemDTDDB *db );

ScreemDTD *screem_dtd_db_get_default_dtd( ScreemDTDDB *db );

void screem_dtd_db_fill_list( ScreemDTDDB *db, GtkListStore *store );

void screem_dtd_db_override_root( ScreemDTDDB *db,
				  const gchar *publicid,
				  const gchar *root );
void screem_dtd_db_override_systemid( ScreemDTDDB *db,
				 const gchar *publicid,
				 const gchar *uri );

gchar *screem_dtd_db_get_root( ScreemDTDDB *db,
				const gchar *publicid,
				gboolean *override );
gchar *screem_dtd_db_get_system_id( ScreemDTDDB *db,
				const gchar *publicid,
				gboolean *override );


void screem_dtd_db_parse_doctype( ScreemDTDDB *db,
				 const gchar *doctype,
				 gchar **publicid,
				 gchar **systemid,
				 gchar **root );

ScreemDTD *screem_dtd_db_get_dtd_from_doctype( ScreemDTDDB *db,
						const gchar *doctype );
ScreemDTD *screem_dtd_db_get_dtd( ScreemDTDDB *db, 
				  const gchar *publicid,
				  const gchar *systemid );

gchar *screem_dtd_db_resolve_entity( void *db,
				  const gchar *publicid,
				  const gchar *systemid );


#endif
