// Macros

#define version                  "sel alpha-release 0.08.4"
#define debug                    0
#define len_cmd                  1024
#define len_line                 1024
#define len_path                 1024
#define len_uname                10
#define len_filename             255
#define len_time                 20
#define len_size                 10
#define len_perm                 12
#define len_types                8
#define ESC                      27
#define ON                       1
#define OFF                      0
#define lf                       "\n"
#define FLUSH                    fflush(stdout)
#define clrscr                   printf("\033[2J");

#define COLOR_STATUS             1
#define COLOR_POINTER            2
#define COLOR_BACKGND            3
#define COLOR_MSG                4
#define COLOR_BACKGND_TAG        5
#define COLOR_POINTER_TAG        6
#define DEF_COLOR_STATUS_FG      COLOR_GREEN
#define DEF_COLOR_STATUS_BG      COLOR_BLUE
#define DEF_COLOR_POINTER_FG     COLOR_WHITE
#define DEF_COLOR_POINTER_BG     COLOR_GREEN
#define DEF_COLOR_BACKGND_FG     COLOR_BLACK
#define DEF_COLOR_BACKGND_BG     COLOR_WHITE
#define DEF_COLOR_MSG_FG         COLOR_RED
#define DEF_COLOR_MSG_BG         COLOR_WHITE
#define DEF_COLOR_BACKGND_TAG_FG COLOR_RED
#define DEF_COLOR_BACKGND_TAG_BG COLOR_WHITE
#define DEF_COLOR_POINTER_TAG_FG COLOR_RED
#define DEF_COLOR_POINTER_TAG_BG COLOR_GREEN
#define DEF_FILE_SUB             '%'

#define error_ok                 0  // ok, Befehl ausgefhrt
#define error_noaction           1  // ok, Befehl nicht ausgefhrt
#define error_intern             10 // interner Fehler
#define error_terminal           11 // terminated
#define error_cmdline            20 // Fehler beim Aufruf
#define error_signal             30 // Durch Signal gekilled

// Function declarations

void sig_int(int sig);
void sig_term(int sig);
void sig_winch(int sig);
void sig_init();
void error(char *errtxt, int rc);
void sel_exit(int rc);
void help(void);
void help_online(void);
void display_settings(void);
void status_put(char instr[]);
int term_getlines(int fd);
int term_getcols(int fd);
void init(void);
void display_init(void);
void display_limit(void);
short color_get (char instr[]);
void color_init(void);
void listing_sort(void);
char *get_uname(int uid);
char *get_gname(int gid);
char *timestring(time_t t, char * buf);
char type_file(char *filename);
char type_file_l(char *filename);
void stat_file(int file_number);
int listing_get(char *path);
int listing_glob(void);
char* limit_str(char instr[len_line], int maxlen);
void listing_put(void);
int history_exist(char input[]);
void history_add();
void history_update();
void history_restore();
int ask_before_cmd(char cmd[]);
int ask_before_cmd_group(void);
void pause_after_cmd(void);
void execute(int file_nr);
void execute_group(void);
void changedir(char dir[]);
void dir_enter(char dir[]);
void dir_leave();
void scrollup(void);
void scrolldown(void);
int find_next();
void get_command();
void get_file_substitute();
int main(int argc, char *argv[]);

// Structures

typedef struct file_struct
{
    char name[len_filename];
    char type;
    char size[len_size];
    char time[len_time];
    char uname[len_uname];
    char gname[len_uname];
    char perm[len_perm];
    short tagged;
} file_struct;

typedef struct history_struct
{
    char path[len_path];
    int  pointer;
    int  pointer_pos;
    int  start_dsp;
    int  end_dsp;
} history_struct;

