
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (Version 2) as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * In sfront distribution, see file COPYING for the GNU General Public License
 *
 *Automatically generated library file csys

 */

#include "tree.h"



void makeascii(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: ascii kbd control driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <ctype.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <termios.h>";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             ascii keyboard control driver for sfront         */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* terminal and signal vars */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="struct termios csysi_term_default;     /* to restore stdin */";
  z[lc++]="sig_atomic_t csysi_no_interrupt = 1;   /* flags [cntrl-c]  */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* keyboard input buffer */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_INBUFF_SIZE 32";
  z[lc++]="";
  z[lc++]="char csysi_inbuff[CSYSI_INBUFF_SIZE];   /* holds new keypresses */";
  z[lc++]="int csysi_inbuff_cnt;                   ";
  z[lc++]="int csysi_inbuff_len;";
  z[lc++]="";
  z[lc++]="/***********************/";
  z[lc++]="/* keyboard action map */";
  z[lc++]="/***********************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAPSIZE  256";
  z[lc++]="";
  z[lc++]="typedef struct csysi_kinfo {";
  z[lc++]="  unsigned char cmd;          /* CSYS_MIDI_{NOTEON,PROGRAM,CC,NOOP} */";
  z[lc++]="  unsigned char ndata;        /* note number or parameter           */";
  z[lc++]="} csysi_kinfo;";
  z[lc++]="";
  z[lc++]="csysi_kinfo csysi_map[CSYSI_MAPSIZE];";
  z[lc++]="";
  z[lc++]="/**********************/";
  z[lc++]="/* current note state */";
  z[lc++]="/**********************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_NOTESIZE 128";
  z[lc++]="#define CSYSI_DURATION 0.1F";
  z[lc++]="";
  z[lc++]="typedef struct csysi_noteinfo {";
  z[lc++]="";
  z[lc++]="  unsigned char cmd;  ";
  z[lc++]="  float time;";
  z[lc++]="";
  z[lc++]="} csysi_noteinfo;";
  z[lc++]="";
  z[lc++]="csysi_noteinfo csysi_notestate[CSYSI_NOTESIZE];";
  z[lc++]="";
  z[lc++]="int csysi_noteoff_min;   /* lowest pending noteoff     */";
  z[lc++]="int csysi_noteoff_max;   /* highest pending noteoff    */";
  z[lc++]="int csysi_noteoff_num;   /* number of pending noteoffs */";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* timeout list */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="int csysi_noteready[CSYSI_NOTESIZE];";
  z[lc++]="int csysi_noteready_len;";
  z[lc++]="";
  z[lc++]="/***********/";
  z[lc++]="/* volume  */";
  z[lc++]="/***********/";
  z[lc++]="";
  z[lc++]="#define CSYSI_VOLUME_DEFAULT 64";
  z[lc++]="#define CSYSI_VOLUME_MAX 112";
  z[lc++]="#define CSYSI_VOLUME_MIN 32";
  z[lc++]="#define CSYSI_VOLUME_INCREMENT 8";
  z[lc++]="";
  z[lc++]="int csysi_volume = CSYSI_VOLUME_DEFAULT;";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* function externs */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="extern void csysi_signal_handler(int signum);";
  z[lc++]="extern void csysi_kbdmap_init(void);";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: called by sfront engine            */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  struct termios term_info;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* initialize data structures */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  csysi_kbdmap_init();";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYSI_NOTESIZE; i++)";
  z[lc++]="    csysi_notestate[i].cmd = CSYS_MIDI_NOTEOFF;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* set up signal handler */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((NSYS_NET == 0) && (signal(SIGINT, csysi_signal_handler) == SIG_ERR))";
  z[lc++]="    {";
  z[lc++]="      printf(\"Error: Can't set up SIGINT signal handler\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************************************************/";
  z[lc++]="  /* set up terminal: no echo, single-character reads */";
  z[lc++]="  /****************************************************/";
  z[lc++]="";
  z[lc++]="  if (tcgetattr(STDIN_FILENO, &csysi_term_default))";
  z[lc++]="    {";
  z[lc++]="      printf(\"Error: Can't set up terminal (1).\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  term_info = csysi_term_default;";
  z[lc++]="";
  z[lc++]="  term_info.c_lflag &= (~ICANON);   ";
  z[lc++]="  term_info.c_lflag &= (~ECHO);";
  z[lc++]="  term_info.c_cc[VTIME] = 0;        ";
  z[lc++]="  term_info.c_cc[VMIN] = 0;";
  z[lc++]="";
  z[lc++]="  if (tcsetattr(STDIN_FILENO, TCSANOW, &term_info))";
  z[lc++]="    {";
  z[lc++]="      printf(\"Error: Can't set up terminal (2).\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (fcntl(STDIN_FILENO, F_SETFL, O_NONBLOCK))";
  z[lc++]="    {";
  z[lc++]="      printf(\"Error: Can't set stdin to O_NONBLOCK.\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* user instructions */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_OUTDRIVER_LINUX))";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"\\nInput Driver Instructions for -cin ascii:\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"{a-z}: notes, {0-9}: MIDI presets, {+,-} volume, cntrl-C exits.\\n\");";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_OUTDRIVER_COREAUDIO))";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"If autorepeat interferes, try 'xset -r' to disable it.\\n\\n\");";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="  ";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int i, bottom, top;";
  z[lc++]="  int ret = CSYS_NONE;";
  z[lc++]="";
  z[lc++]="  if (csysi_no_interrupt)";
  z[lc++]="    {";
  z[lc++]="      /* see if any NoteOn's ready to be turned off */";
  z[lc++]="";
  z[lc++]="      if (csysi_noteoff_num)";
  z[lc++]="	{";
  z[lc++]="	  csysi_noteready_len = 0;";
  z[lc++]="	  top = bottom = -1;";
  z[lc++]="	  for (i = csysi_noteoff_min; i <= csysi_noteoff_max; i++)";
  z[lc++]="	    if (csysi_notestate[i].cmd == CSYS_MIDI_NOTEON)";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_notestate[i].time > absolutetime)";
  z[lc++]="		  {";
  z[lc++]="		    if (bottom < 0)";
  z[lc++]="		      bottom = i;";
  z[lc++]="		    top = i;";
  z[lc++]="		  }";
  z[lc++]="		else";
  z[lc++]="		  {";
  z[lc++]="		    csysi_notestate[i].cmd = CSYS_MIDI_NOTEOFF;";
  z[lc++]="		    csysi_noteready[csysi_noteready_len++] = i;";
  z[lc++]="		    csysi_noteoff_num--;";
  z[lc++]="		    ret = CSYS_MIDIEVENTS;";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	  csysi_noteoff_min = bottom;";
  z[lc++]="	  csysi_noteoff_max = top;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* check for new keypresses */";
  z[lc++]="";
  z[lc++]="      csysi_inbuff_cnt = 0;";
  z[lc++]="      csysi_inbuff_len = read(STDIN_FILENO, csysi_inbuff, CSYSI_INBUFF_SIZE);";
  z[lc++]="      csysi_inbuff_len = (csysi_inbuff_len >= 0) ? csysi_inbuff_len : 0;";
  z[lc++]="      return (csysi_inbuff_len ? CSYS_MIDIEVENTS : ret);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char i;";
  z[lc++]="";
  z[lc++]="  if (csysi_no_interrupt)";
  z[lc++]="    {";
  z[lc++]="      *extchan = 0;";
  z[lc++]="";
  z[lc++]="      /* check for new NoteOffs */";
  z[lc++]="";
  z[lc++]="      if (csysi_noteready_len)";
  z[lc++]="	{";
  z[lc++]="	  csysi_noteready_len--;";
  z[lc++]="	  *cmd = CSYS_MIDI_NOTEOFF;";
  z[lc++]="	  *ndata = csysi_noteready[csysi_noteready_len];";
  z[lc++]="	  *vdata = 0;";
  z[lc++]="	  return ((csysi_inbuff_len || csysi_noteready_len) ? ";
  z[lc++]="		  CSYS_MIDIEVENTS : CSYS_NONE);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* handle new keypresses */";
  z[lc++]="";
  z[lc++]="      *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="";
  z[lc++]="      while (csysi_inbuff_cnt < csysi_inbuff_len)";
  z[lc++]="	switch (csysi_map[(i = csysi_inbuff[csysi_inbuff_cnt++])].cmd) {";
  z[lc++]="	case CSYS_MIDI_NOTEON:";
  z[lc++]="";
  z[lc++]="	  *ndata = csysi_map[i].ndata;";
  z[lc++]="";
  z[lc++]="	  if (csysi_notestate[*ndata].cmd == CSYS_MIDI_NOTEOFF)";
  z[lc++]="	    {";
  z[lc++]="	      *cmd = CSYS_MIDI_NOTEON;";
  z[lc++]="	      *vdata = csysi_volume;";
  z[lc++]="	      ";
  z[lc++]="	      csysi_notestate[*ndata].cmd = CSYS_MIDI_NOTEON;";
  z[lc++]="	      csysi_notestate[*ndata].time = absolutetime + CSYSI_DURATION;";
  z[lc++]="	      ";
  z[lc++]="	      if (csysi_noteoff_num++)";
  z[lc++]="		{";
  z[lc++]="		  if (*ndata > csysi_noteoff_max)";
  z[lc++]="		    csysi_noteoff_max = *ndata;";
  z[lc++]="		  else";
  z[lc++]="		    if (*ndata < csysi_noteoff_min)";
  z[lc++]="		      csysi_noteoff_min = *ndata;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		csysi_noteoff_min = csysi_noteoff_max = *ndata;";
  z[lc++]="	      return ((csysi_inbuff_cnt < csysi_inbuff_len) ? ";
  z[lc++]="		      CSYS_MIDIEVENTS : CSYS_NONE);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_PROGRAM:";
  z[lc++]="	  *cmd = CSYS_MIDI_PROGRAM;";
  z[lc++]="	  *ndata = csysi_map[i].ndata;";
  z[lc++]="	  return ((csysi_inbuff_cnt < csysi_inbuff_len) ? ";
  z[lc++]="		  CSYS_MIDIEVENTS : CSYS_NONE);";
  z[lc++]="	  break;	";
  z[lc++]="	case CSYS_MIDI_CC:";
  z[lc++]="	  if (csysi_map[i].ndata)";
  z[lc++]="	    {";
  z[lc++]="	      csysi_volume += CSYSI_VOLUME_INCREMENT;";
  z[lc++]="	      if (csysi_volume > CSYSI_VOLUME_MAX)";
  z[lc++]="		csysi_volume = CSYSI_VOLUME_MAX;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      csysi_volume -= CSYSI_VOLUME_INCREMENT;";
  z[lc++]="	      if (csysi_volume < CSYSI_VOLUME_MIN)";
  z[lc++]="		csysi_volume = CSYSI_VOLUME_MIN;";
  z[lc++]="	    }";
  z[lc++]="	  break;	";
  z[lc++]="	case CSYS_MIDI_NOOP:";
  z[lc++]="	  break;";
  z[lc++]="	default:";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* end session if a cntrl-C clears csysi_no_interrupt */";
  z[lc++]="";
  z[lc++]="  *cmd = CSYS_MIDI_ENDTIME;";
  z[lc++]="  *fval = scorebeats;";
  z[lc++]="  return CSYS_NONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  tcsetattr(STDIN_FILENO, TCSANOW, &csysi_term_default);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   mid-level functions: called by top-level driver functions  */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initializes keyboard map                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_kbdmap_init(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /* MIDI note number map */";
  z[lc++]="";
  z[lc++]="  csysi_map['z'].ndata = csysi_map['a'].ndata = csysi_map['q'].ndata = 48; ";
  z[lc++]="  csysi_map['Z'].ndata = csysi_map['A'].ndata = csysi_map['Q'].ndata = 48; ";
  z[lc++]="  csysi_map['x'].ndata = csysi_map['s'].ndata = csysi_map['w'].ndata = 50; ";
  z[lc++]="  csysi_map['X'].ndata = csysi_map['S'].ndata = csysi_map['W'].ndata = 50; ";
  z[lc++]="  csysi_map['c'].ndata = csysi_map['d'].ndata = csysi_map['e'].ndata = 52; ";
  z[lc++]="  csysi_map['C'].ndata = csysi_map['D'].ndata = csysi_map['E'].ndata = 52; ";
  z[lc++]="  csysi_map['v'].ndata = csysi_map['f'].ndata = csysi_map['r'].ndata = 55; ";
  z[lc++]="  csysi_map['V'].ndata = csysi_map['F'].ndata = csysi_map['R'].ndata = 55; ";
  z[lc++]="  csysi_map['b'].ndata = csysi_map['g'].ndata = csysi_map['t'].ndata = 57;";
  z[lc++]="  csysi_map['B'].ndata = csysi_map['G'].ndata = csysi_map['T'].ndata = 57;";
  z[lc++]="  csysi_map['n'].ndata = csysi_map['h'].ndata = csysi_map['y'].ndata = 60; ";
  z[lc++]="  csysi_map['N'].ndata = csysi_map['H'].ndata = csysi_map['Y'].ndata = 60; ";
  z[lc++]="  csysi_map['m'].ndata = csysi_map['j'].ndata = csysi_map['u'].ndata = 62; ";
  z[lc++]="  csysi_map['M'].ndata = csysi_map['J'].ndata = csysi_map['U'].ndata = 62; ";
  z[lc++]="  csysi_map[','].ndata = csysi_map['k'].ndata = csysi_map['i'].ndata = 64; ";
  z[lc++]="  csysi_map['<'].ndata = csysi_map['K'].ndata = csysi_map['I'].ndata = 64; ";
  z[lc++]="  csysi_map['.'].ndata = csysi_map['l'].ndata = csysi_map['o'].ndata = 67; ";
  z[lc++]="  csysi_map['>'].ndata = csysi_map['L'].ndata = csysi_map['O'].ndata = 67; ";
  z[lc++]="  csysi_map['/'].ndata = csysi_map[';'].ndata = csysi_map['p'].ndata = 69;";
  z[lc++]="  csysi_map['\\?'].ndata = csysi_map[':'].ndata = csysi_map['P'].ndata = 69;";
  z[lc++]="  csysi_map['\\''].ndata = csysi_map['['].ndata = 72; ";
  z[lc++]="  csysi_map['\"'].ndata = csysi_map['{'].ndata = 72; ";
  z[lc++]="  csysi_map[']'].ndata = 74; ";
  z[lc++]="  csysi_map['}'].ndata = 74; ";
  z[lc++]="  csysi_map['\\\\'].ndata = csysi_map['\\n'].ndata = 76; ";
  z[lc++]="  csysi_map['|'].ndata = 76; ";
  z[lc++]="  csysi_map[' '].ndata = 48;";
  z[lc++]="";
  z[lc++]="  /* set command type */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYSI_MAPSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_map[i].ndata)";
  z[lc++]="	csysi_map[i].cmd = CSYS_MIDI_NOTEON;";
  z[lc++]="      else";
  z[lc++]="	if (isdigit(i))";
  z[lc++]="	  {";
  z[lc++]="	    csysi_map[i].cmd = CSYS_MIDI_PROGRAM;";
  z[lc++]="	    csysi_map[i].ndata = (i - '0');";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if ((i == '+') || (i == '_') || (i == '-') || (i == '='))";
  z[lc++]="	    {";
  z[lc++]="	      csysi_map[i].cmd = CSYS_MIDI_CC;";
  z[lc++]="	      csysi_map[i].ndata = ((i == '+') || (i == '='));";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    csysi_map[i].cmd = CSYS_MIDI_NOOP;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 low-level functions                          */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 SIGINT signal handler                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_signal_handler(int signum)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (csysi_no_interrupt)";
  z[lc++]="    {";
  z[lc++]="      csysi_no_interrupt = 0;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      exit(129); /* emergency shutdown */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makegliss(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: fast note gliss control driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define CSYSI_BOTTOMNOTE 20";
  z[lc++]="#define CSYSI_TOPNOTE 100";
  z[lc++]="#define CSYSI_VELOCITY 64";
  z[lc++]="#define CSYSI_LENGTH  60";
  z[lc++]="#define CSYSI_NUMPFIELDS 2";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             glissando control driver for sfront              */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_flag = CSYSI_LENGTH;";
  z[lc++]="int csysi_on = 0;";
  z[lc++]="int csysi_note = CSYSI_BOTTOMNOTE;";
  z[lc++]="int csysi_noteinc = 1;";
  z[lc++]="int csysi_instr = 1;";
  z[lc++]="float csysi_pfields[CSYSI_NUMPFIELDS];";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  if (csysi_flag)";
  z[lc++]="    {";
  z[lc++]="      csysi_flag--;";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  csysi_flag = CSYSI_LENGTH;";
  z[lc++]="  if (csysi_noteinc == 1)";
  z[lc++]="    {";
  z[lc++]="      csysi_on = !csysi_on;";
  z[lc++]="      return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    return CSYS_SASLEVENTS;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (csysi_on)";
  z[lc++]="    {";
  z[lc++]="      *cmd = CSYS_MIDI_NOTEON;";
  z[lc++]="      *ndata = csysi_note;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *cmd = CSYS_MIDI_NOTEOFF;";
  z[lc++]="      *ndata = csysi_note;";
  z[lc++]="      csysi_note += csysi_noteinc;";
  z[lc++]="      if ((csysi_note == CSYSI_TOPNOTE)||(csysi_note == CSYSI_BOTTOMNOTE))";
  z[lc++]="	{";
  z[lc++]="	  csysi_noteinc *= -1;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *vdata =  CSYSI_VELOCITY;";
  z[lc++]="  *extchan = 0;";
  z[lc++]="  return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a SASL event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_saslevent(unsigned char * cmd, unsigned char * priority,";
  z[lc++]="		   unsigned short * id, unsigned short * label,";
  z[lc++]="		   float * fval, unsigned int * pnum, float ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (csysi_instr)";
  z[lc++]="    {";
  z[lc++]="      csysi_instr = 0;";
  z[lc++]="      *cmd = CSYS_SASL_INSTR;";
  z[lc++]="      *priority = 0;";
  z[lc++]="      *id = CSYS_SASL_INSTR_spiano;";
  z[lc++]="      *label = 5;";
  z[lc++]="      *fval = 0.10;";
  z[lc++]="      *pnum = CSYSI_NUMPFIELDS;";
  z[lc++]="      csysi_pfields[0] = csysi_note;";
  z[lc++]="      csysi_pfields[1] = CSYSI_VELOCITY;";
  z[lc++]="      *p = &csysi_pfields[0];";
  z[lc++]="      ";
  z[lc++]="      csysi_note += csysi_noteinc;";
  z[lc++]="      if ((csysi_note == CSYSI_TOPNOTE)||(csysi_note == CSYSI_BOTTOMNOTE))";
  z[lc++]="	{";
  z[lc++]="	  csysi_noteinc *= -1;";
  z[lc++]="	}";
  z[lc++]="      return CSYS_SASLEVENTS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      csysi_instr = 1;";
  z[lc++]="      *cmd = CSYS_SASL_CONTROL;";
  z[lc++]="      *priority = 0;";
  z[lc++]="      *id = CSYS_SASL_NOINSTR;";
  z[lc++]="      *label = 5;";
  z[lc++]="      *fval = 0;";
  z[lc++]="      *pnum = CSYS_SASL_GBL_pedal;";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="	";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  printlib(lc);
}


void makelinmidi(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Merged linux/freebsd MIDI Input control driver ";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               MIDI Input control driver for sfront           */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#ifndef CSYSI_MIDIDEV";
  z[lc++]="#define CSYSI_MIDIDEV \"/dev/midi00\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define CSYSI_BUFFSIZE    1024";
  z[lc++]="#define CSYSI_SYSEX_EOX   0xF7";
  z[lc++]="";
  z[lc++]="/* set CSYSI_DELAY to 0 to wait for partially completed MIDI commands */";
  z[lc++]="/* waiting for commands decreases variance of the latency, at the     */";
  z[lc++]="/* expense of losing computation cycles                               */";
  z[lc++]="";
  z[lc++]="#define CSYSI_DELAY 1";
  z[lc++]="";
  z[lc++]="/* variables for SIGALRM for MIDI overrun */";
  z[lc++]="";
  z[lc++]="/* period for interrupt: 320us per MIDI byte @ 128 bytes, minus safety zone */";
  z[lc++]="";
  z[lc++]="#define CSYSI_ALARMPERIOD  40000";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="sigset_t         csysi_overrun_mask;    /* for masking off overrun interrupt */";
  z[lc++]="struct sigaction csysi_overrun_action;  /* for setting up overrun interrupt  */";
  z[lc++]="struct itimerval csysi_overrun_timer;   /* for setting up overrun timer      */";
  z[lc++]="";
  z[lc++]="/* flag for new note on/off */";
  z[lc++]="";
  z[lc++]="int csysi_newnote = 0;";
  z[lc++]="";
  z[lc++]="/* MIDI parsing state variables */";
  z[lc++]="";
  z[lc++]="int csysi_midi = 0;";
  z[lc++]="";
  z[lc++]="unsigned char csysi_hold[CSYSI_BUFFSIZE];";
  z[lc++]="int csysi_holdidx = 0;";
  z[lc++]="";
  z[lc++]="unsigned char csysi_data[CSYSI_BUFFSIZE];";
  z[lc++]="";
  z[lc++]="long csysi_len;";
  z[lc++]="long csysi_cnt;";
  z[lc++]="unsigned char csysi_cmd;";
  z[lc++]="unsigned char csysi_num;";
  z[lc++]="unsigned short csysi_extchan;";
  z[lc++]="unsigned char csysi_ndata = 0xFF;";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking wrappers                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      return CSYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_TERMINATE(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));\\";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- \" x );}  while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler to catch MIDI buffer overruns         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_overrun_handler(int signum) ";
  z[lc++]="";
  z[lc++]="{   ";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  while ((len = read(csysi_midi, &(csysi_hold[csysi_holdidx]), ";
  z[lc++]="	     CSYSI_BUFFSIZE-csysi_holdidx)) < 0)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csysi_overrun_handler\");";
  z[lc++]="";
  z[lc++]="      if (errno == EAGAIN)      /* no data ready */";
  z[lc++]="	break;";
  z[lc++]="      if (errno == EINTR)       /* interrupted, try again */";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (len > 0)";
  z[lc++]="    {";
  z[lc++]="      if ((csysi_holdidx += len) >= CSYSI_BUFFSIZE)";
  z[lc++]="	fprintf(stderr, \"  Warning: MIDI overrun, data lost\\n\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't reset ITIMER_REAL timer\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  csysi_midi = open(CSYSI_MIDIDEV, O_RDONLY|O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if (csysi_midi == -1)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Can't open MIDI input device\");";
  z[lc++]="";
  z[lc++]="  /* set up mask for overrun timer */";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&csysi_overrun_mask) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigemptyset(overrun) OS call\");";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&csysi_overrun_mask, SIGALRM) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigaddset(overrun) OS call\");";
  z[lc++]="";
  z[lc++]="  /* set up signal handler for overrun timer */";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&csysi_overrun_action.sa_mask) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigemptyset(oaction) OS call\");";
  z[lc++]="";
  z[lc++]="  csysi_overrun_action.sa_flags = SA_RESTART;";
  z[lc++]="  csysi_overrun_action.sa_handler = csysi_overrun_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGALRM, &csysi_overrun_action, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't set up SIGALRM signal handler\");";
  z[lc++]="";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="";
  z[lc++]="  csysi_overrun_timer.it_value.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_value.tv_usec = CSYSI_ALARMPERIOD;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't set up ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       unmasks overrun timer at end of MIDI parsing           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_midiparseover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (sigprocmask(SIG_UNBLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't unmask MIDI overrun timer\");";
  z[lc++]="";
  z[lc++]="  return CSYS_NONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  /* block overrun time and reset it */";
  z[lc++]="";
  z[lc++]="  if (sigprocmask(SIG_BLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't mask MIDI overrun timer\");";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't reset ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  if (!csysi_holdidx)";
  z[lc++]="    {";
  z[lc++]="      while ((len = read(csysi_midi, csysi_hold, CSYSI_BUFFSIZE)) < 0)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	    CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csys_newdata(if)\");";
  z[lc++]="";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    return csysi_midiparseover();   /* no data ready, so leave */";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    continue;                       /* interrupted, try again */";
  z[lc++]="";
  z[lc++]="	  /* all other errors fatal */";
  z[lc++]="";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      while ((len = read(csysi_midi, &(csysi_hold[csysi_holdidx]), ";
  z[lc++]="	       CSYSI_BUFFSIZE-csysi_holdidx)) < 0)";
  z[lc++]="	{";
  z[lc++]="	  if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	    CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csys_newdata(el)\");";
  z[lc++]="";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    break;                      /* no data ready, process buffer */";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    continue;                   /* interrupted, try again */";
  z[lc++]="";
  z[lc++]="	  /* all other errors fatal */";
  z[lc++]="";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      len = (len < 0) ? csysi_holdidx : len + csysi_holdidx;";
  z[lc++]="      csysi_holdidx = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  csysi_newnote = csysi_len = csysi_cnt = 0;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < len; i++)";
  z[lc++]="    if (csysi_hold[i] <= CSYSI_SYSEX_EOX)";
  z[lc++]="      csysi_data[csysi_len++] = csysi_hold[i];";
  z[lc++]="";
  z[lc++]="  if (!csysi_len) ";
  z[lc++]="    return csysi_midiparseover();";
  z[lc++]="";
  z[lc++]="  /* leave interrupts locked until all data transferred */";
  z[lc++]="";
  z[lc++]="  return CSYS_MIDIEVENTS;";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             gets one byte from MIDI stream                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char csysi_getbyte(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char d;";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  /* used when we need to risk waiting for the next byte */";
  z[lc++]="";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      if (read(csysi_midi, &d, 1) != 1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN) /* no data ready  */";
  z[lc++]="	    {";
  z[lc++]="	      retry = 0;";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  if (errno == EINTR) /* interrupted */";
  z[lc++]="	    {	  ";
  z[lc++]="	      if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="		CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csysi_getbyte\");";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  retry = 0;";
  z[lc++]="	  if (d <= CSYSI_SYSEX_EOX)";
  z[lc++]="	    break;";
  z[lc++]="	  else";
  z[lc++]="	    continue;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return d;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             flushes MIDI system messages                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_sysflush(unsigned short type)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char byte;";
  z[lc++]="";
  z[lc++]="  if ((type == 6) || /* one-byte messages */";
  z[lc++]="      (type == 1) || /* undefined messages */";
  z[lc++]="      (type == 4) ||";
  z[lc++]="      (type == 5))";
  z[lc++]="    { ";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 3) /* song select -- 1 data byte */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      else";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 2) /* song pointer -- 2 data bytes */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (type == 0) ";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	byte = csysi_data[csysi_cnt++];";
  z[lc++]="      else";
  z[lc++]="	byte = csysi_getbyte();";
  z[lc++]="      while (byte < CSYS_MIDI_NOTEOFF)";
  z[lc++]="	if (csysi_cnt < csysi_len)";
  z[lc++]="	  byte = csysi_data[csysi_cnt++];";
  z[lc++]="	else";
  z[lc++]="	  byte = csysi_getbyte();";
  z[lc++]="      if (byte != CSYSI_SYSEX_EOX) /* non-compliant MIDI */";
  z[lc++]="	{";
  z[lc++]="	  if ((byte&0xF0) != 0xF0)";
  z[lc++]="	    {";
  z[lc++]="	      csysi_cmd = byte&0xF0;";
  z[lc++]="	      csysi_extchan = byte&0x0F;";
  z[lc++]="	    }";
  z[lc++]="	  switch (byte&0xF0) {";
  z[lc++]="	  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	  case CSYS_MIDI_NOTEON:";
  z[lc++]="	  case CSYS_MIDI_PTOUCH:";
  z[lc++]="	  case CSYS_MIDI_WHEEL:";
  z[lc++]="	  case CSYS_MIDI_CC:";
  z[lc++]="	    csysi_num = 2;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_PROGRAM:";
  z[lc++]="	  case CSYS_MIDI_CTOUCH:";
  z[lc++]="	    csysi_num = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 0xF0: ";
  z[lc++]="	    if ((byte&0x0F)==2) /* song pointer -- 2 data bytes */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    if ((byte&0x0F)==3) /* song select -- 1 data byte */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* outside of if {} to catch errant F7 bytes */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt == csysi_len)";
  z[lc++]="    return csysi_midiparseover();";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char overflow[2], oval;";
  z[lc++]="  int len, tot, idx;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (csysi_data[csysi_cnt] > 127)    /* a command byte */";
  z[lc++]="    {";
  z[lc++]="      *cmd = 0xF0 & csysi_data[csysi_cnt];";
  z[lc++]="      *extchan = 0x0F & csysi_data[csysi_cnt];";
  z[lc++]="      if (*cmd != 0xF0)";
  z[lc++]="	{";
  z[lc++]="	  csysi_cmd = *cmd;";
  z[lc++]="	  csysi_extchan = *extchan;";
  z[lc++]="	}";
  z[lc++]="      csysi_cnt++;";
  z[lc++]="      switch (*cmd) {";
  z[lc++]="      case CSYS_MIDI_NOTEOFF:";
  z[lc++]="      case CSYS_MIDI_NOTEON:";
  z[lc++]="      case CSYS_MIDI_PTOUCH:";
  z[lc++]="      case CSYS_MIDI_WHEEL:";
  z[lc++]="      case CSYS_MIDI_CC:";
  z[lc++]="	csysi_num = 2;";
  z[lc++]="	if (CSYSI_DELAY && ((csysi_cnt + 1) == csysi_len)) /* delay cmd */";
  z[lc++]="	  {";
  z[lc++]="	    csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	    return csysi_midiparseover();";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_PROGRAM:";
  z[lc++]="      case CSYS_MIDI_CTOUCH:";
  z[lc++]="	csysi_num = 1;";
  z[lc++]="	break;";
  z[lc++]="      case 0xF0: ";
  z[lc++]="	*cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	return csysi_sysflush(*extchan);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      if (CSYSI_DELAY && (csysi_cnt == csysi_len)) /* delay cmd */";
  z[lc++]="	{";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return csysi_midiparseover();";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else  /* running status or a delayed MIDI command */";
  z[lc++]="    {";
  z[lc++]="      *cmd = csysi_cmd;";
  z[lc++]="      *extchan = csysi_extchan;";
  z[lc++]="      if (CSYSI_DELAY && (csysi_ndata != 0xFF)) /* finish delayed cmd */";
  z[lc++]="	{";
  z[lc++]="	  *ndata = csysi_ndata;";
  z[lc++]="	  csysi_ndata = 0xFF;";
  z[lc++]="	  csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="			    ((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="	  *vdata = csysi_data[csysi_cnt++];";
  z[lc++]="	  if (csysi_cnt == csysi_len)";
  z[lc++]="	    return csysi_midiparseover();";
  z[lc++]="	  else";
  z[lc++]="	    return CSYS_MIDIEVENTS;";
  z[lc++]="	}";
  z[lc++]="      if (CSYSI_DELAY && (csysi_num == 2) && /* (further) delay cmd */";
  z[lc++]="	  (csysi_cnt + 1 == csysi_len))";
  z[lc++]="	{";
  z[lc++]="	  csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return csysi_midiparseover();";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* do complete commands and finish some types of delayed commands */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt + csysi_num <= csysi_len)";
  z[lc++]="    {";
  z[lc++]="      csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="			((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_num == 2)";
  z[lc++]="	*vdata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* should never execute if CSYSI_DELAY is 1 */";
  z[lc++]="";
  z[lc++]="  csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="		    ((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="";
  z[lc++]="  tot = csysi_cnt + csysi_num - csysi_len;";
  z[lc++]="  idx = 0;";
  z[lc++]="  while (tot > 0)";
  z[lc++]="    {";
  z[lc++]="      overflow[idx++] = csysi_getbyte();";
  z[lc++]="      tot--;";
  z[lc++]="    }";
  z[lc++]="  if (csysi_num == 1) ";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      return csysi_midiparseover();";
  z[lc++]="    }";
  z[lc++]="  if (csysi_cnt + 1 == csysi_len)";
  z[lc++]="    {";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      *vdata = overflow[0];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      *vdata = overflow[1];";
  z[lc++]="    }";
  z[lc++]="  return csysi_midiparseover();";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  /* disarm timer */";
  z[lc++]="";
  z[lc++]="  if (sigprocmask(SIG_BLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't mask MIDI overrun time\");";
  z[lc++]="";
  z[lc++]="  csysi_overrun_timer.it_value.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_value.tv_usec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't disarm ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  close(csysi_midi);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#undef CSYSI_MIDIDEV";
  z[lc++]="#undef CSYSI_BUFFSIZE";
  z[lc++]="#undef CSYSI_SYSEX_EOX";
  z[lc++]="#undef CSYSI_DELAY";
  z[lc++]="#undef CSYSI_ALARMPERIOD";
  z[lc++]="#undef CSYSI_ERROR_RETURN";
  z[lc++]="#undef CSYSI_ERROR_TERMINATE";
  z[lc++]="";
  printlib(lc);
}


void makefreebsdmidi(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Merged linux/freebsd MIDI Input control driver ";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               MIDI Input control driver for sfront           */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#ifndef CSYSI_MIDIDEV";
  z[lc++]="#define CSYSI_MIDIDEV \"/dev/midi00\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define CSYSI_BUFFSIZE    1024";
  z[lc++]="#define CSYSI_SYSEX_EOX   0xF7";
  z[lc++]="";
  z[lc++]="/* set CSYSI_DELAY to 0 to wait for partially completed MIDI commands */";
  z[lc++]="/* waiting for commands decreases variance of the latency, at the     */";
  z[lc++]="/* expense of losing computation cycles                               */";
  z[lc++]="";
  z[lc++]="#define CSYSI_DELAY 1";
  z[lc++]="";
  z[lc++]="/* variables for SIGALRM for MIDI overrun */";
  z[lc++]="";
  z[lc++]="/* period for interrupt: 320us per MIDI byte @ 128 bytes, minus safety zone */";
  z[lc++]="";
  z[lc++]="#define CSYSI_ALARMPERIOD  40000";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="sigset_t         csysi_overrun_mask;    /* for masking off overrun interrupt */";
  z[lc++]="struct sigaction csysi_overrun_action;  /* for setting up overrun interrupt  */";
  z[lc++]="struct itimerval csysi_overrun_timer;   /* for setting up overrun timer      */";
  z[lc++]="";
  z[lc++]="/* flag for new note on/off */";
  z[lc++]="";
  z[lc++]="int csysi_newnote = 0;";
  z[lc++]="";
  z[lc++]="/* MIDI parsing state variables */";
  z[lc++]="";
  z[lc++]="int csysi_midi = 0;";
  z[lc++]="";
  z[lc++]="unsigned char csysi_hold[CSYSI_BUFFSIZE];";
  z[lc++]="int csysi_holdidx = 0;";
  z[lc++]="";
  z[lc++]="unsigned char csysi_data[CSYSI_BUFFSIZE];";
  z[lc++]="long csysi_len;";
  z[lc++]="long csysi_cnt;";
  z[lc++]="unsigned char csysi_cmd;";
  z[lc++]="unsigned char csysi_num;";
  z[lc++]="unsigned short csysi_extchan;";
  z[lc++]="unsigned char csysi_ndata = 0xFF;";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking wrappers                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      return CSYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_TERMINATE(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));\\";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- \" x );}  while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler to catch MIDI buffer overruns      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_overrun_handler(int signum) ";
  z[lc++]="";
  z[lc++]="{   ";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  while ((len = read(csysi_midi, &(csysi_hold[csysi_holdidx]), ";
  z[lc++]="	     CSYSI_BUFFSIZE-csysi_holdidx)) < 0)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csysi_overrun_handler\");";
  z[lc++]="";
  z[lc++]="      if (errno == EAGAIN)      /* no data ready */";
  z[lc++]="	break;";
  z[lc++]="      if (errno == EINTR)       /* interrupted, try again */";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (len > 0)";
  z[lc++]="    {";
  z[lc++]="      if ((csysi_holdidx += len) >= CSYSI_BUFFSIZE)";
  z[lc++]="	fprintf(stderr, \"  Warning: MIDI overrun, data lost\\n\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't reset ITIMER_REAL timer\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  csysi_midi = open(CSYSI_MIDIDEV, O_RDONLY|O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if (csysi_midi == -1)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Can't open MIDI input device\");";
  z[lc++]="";
  z[lc++]="  /* set up mask for overrun timer */";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&csysi_overrun_mask) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigemptyset(overrun) OS call\");";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&csysi_overrun_mask, SIGALRM) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigaddset(overrun) OS call\");";
  z[lc++]="";
  z[lc++]="  /* set up signal handler for overrun timer */";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&csysi_overrun_action.sa_mask) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't run sigemptyset(oaction) OS call\");";
  z[lc++]="";
  z[lc++]="  csysi_overrun_action.sa_flags = SA_RESTART;";
  z[lc++]="  csysi_overrun_action.sa_handler = csysi_overrun_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGALRM, &csysi_overrun_action, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't set up SIGALRM signal handler\");";
  z[lc++]="";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="";
  z[lc++]="  csysi_overrun_timer.it_value.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_value.tv_usec = CSYSI_ALARMPERIOD;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Couldn't set up ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       unmasks overrun timer at end of MIDI parsing           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_midiparseover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (sigprocmask(SIG_UNBLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't unmask MIDI overrun timer\");";
  z[lc++]="";
  z[lc++]="  return CSYS_NONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int i = 0;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  /* block overrun time and reset it */";
  z[lc++]="";
  z[lc++]="  if (sigprocmask(SIG_BLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't mask MIDI overrun timer\");";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't reset ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  if (!csysi_holdidx)";
  z[lc++]="    {";
  z[lc++]="      while ((len = read(csysi_midi, csysi_hold, CSYSI_BUFFSIZE)) < 0)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	    CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csys_newdata(if)\");";
  z[lc++]="";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    return csysi_midiparseover();   /* no data ready, so leave */";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    continue;                       /* interrupted, try again */";
  z[lc++]="";
  z[lc++]="	  /* all other errors fatal */";
  z[lc++]="";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      while ((len = read(csysi_midi, &(csysi_hold[csysi_holdidx]), ";
  z[lc++]="	       CSYSI_BUFFSIZE-csysi_holdidx)) < 0)";
  z[lc++]="	{";
  z[lc++]="	  if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="	    CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csys_newdata(el)\");";
  z[lc++]="";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    break;                      /* no data ready, process buffer */";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    continue;                   /* interrupted, try again */";
  z[lc++]="";
  z[lc++]="	  /* all other errors fatal */";
  z[lc++]="";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      len = (len < 0) ? csysi_holdidx : len + csysi_holdidx;";
  z[lc++]="      csysi_holdidx = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  csysi_newnote = csysi_len = csysi_cnt = 0;";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_hold[i] <= CSYSI_SYSEX_EOX)";
  z[lc++]="	csysi_data[csysi_len++] = csysi_hold[i];";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!csysi_len) ";
  z[lc++]="    return csysi_midiparseover();";
  z[lc++]="";
  z[lc++]="  /* leave interrupts locked until all data transferred */";
  z[lc++]="";
  z[lc++]="  return CSYS_MIDIEVENTS;";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             gets one byte from MIDI stream                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char csysi_getbyte(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char d;";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  /* used when we need to risk waiting for the next byte */";
  z[lc++]="";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      if (read(csysi_midi, &d, 1) != 1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN) /* no data ready  */";
  z[lc++]="	    {";
  z[lc++]="	      retry = 0;";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  if (errno == EINTR) /* interrupted */";
  z[lc++]="	    {	  ";
  z[lc++]="	      if (++retry > CSYSI_MAXRETRY)";
  z[lc++]="		CSYSI_ERROR_TERMINATE(\"Too many I/O retries -- csysi_getbyte\");";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  CSYSI_ERROR_TERMINATE(\"Couldn't read MIDI device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  retry = 0;";
  z[lc++]="	  if (d <= CSYSI_SYSEX_EOX)";
  z[lc++]="	    break;";
  z[lc++]="	  else";
  z[lc++]="	    continue;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return d;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             flushes MIDI system messages                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_sysflush(unsigned short type)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char byte;";
  z[lc++]="";
  z[lc++]="  if ((type == 6) || /* one-byte messages */";
  z[lc++]="      (type == 1) || /* undefined messages */";
  z[lc++]="      (type == 4) ||";
  z[lc++]="      (type == 5))";
  z[lc++]="    { ";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 3) /* song select -- 1 data byte */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      else";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 2) /* song pointer -- 2 data bytes */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (type == 0) ";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	byte = csysi_data[csysi_cnt++];";
  z[lc++]="      else";
  z[lc++]="	byte = csysi_getbyte();";
  z[lc++]="      while (byte < CSYS_MIDI_NOTEOFF)";
  z[lc++]="	if (csysi_cnt < csysi_len)";
  z[lc++]="	  byte = csysi_data[csysi_cnt++];";
  z[lc++]="	else";
  z[lc++]="	  byte = csysi_getbyte();";
  z[lc++]="      if (byte != CSYSI_SYSEX_EOX) /* non-compliant MIDI */";
  z[lc++]="	{";
  z[lc++]="	  if ((byte&0xF0) != 0xF0)";
  z[lc++]="	    {";
  z[lc++]="	      csysi_cmd = byte&0xF0;";
  z[lc++]="	      csysi_extchan = byte&0x0F;";
  z[lc++]="	    }";
  z[lc++]="	  switch (byte&0xF0) {";
  z[lc++]="	  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	  case CSYS_MIDI_NOTEON:";
  z[lc++]="	  case CSYS_MIDI_PTOUCH:";
  z[lc++]="	  case CSYS_MIDI_WHEEL:";
  z[lc++]="	  case CSYS_MIDI_CC:";
  z[lc++]="	    csysi_num = 2;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_PROGRAM:";
  z[lc++]="	  case CSYS_MIDI_CTOUCH:";
  z[lc++]="	    csysi_num = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 0xF0: ";
  z[lc++]="	    if ((byte&0x0F)==2) /* song pointer -- 2 data bytes */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    if ((byte&0x0F)==3) /* song select -- 1 data byte */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* outside of if {} to catch errant F7 bytes */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt == csysi_len)";
  z[lc++]="    return csysi_midiparseover();";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char overflow[2], oval;";
  z[lc++]="  int len, tot, idx;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (csysi_data[csysi_cnt] > 127)    /* a command byte */";
  z[lc++]="    {";
  z[lc++]="      *cmd = 0xF0 & csysi_data[csysi_cnt];";
  z[lc++]="      *extchan = 0x0F & csysi_data[csysi_cnt];";
  z[lc++]="      if (*cmd != 0xF0)";
  z[lc++]="	{";
  z[lc++]="	  csysi_cmd = *cmd;";
  z[lc++]="	  csysi_extchan = *extchan;";
  z[lc++]="	}";
  z[lc++]="      csysi_cnt++;";
  z[lc++]="      switch (*cmd) {";
  z[lc++]="      case CSYS_MIDI_NOTEOFF:";
  z[lc++]="      case CSYS_MIDI_NOTEON:";
  z[lc++]="      case CSYS_MIDI_PTOUCH:";
  z[lc++]="      case CSYS_MIDI_WHEEL:";
  z[lc++]="      case CSYS_MIDI_CC:";
  z[lc++]="	csysi_num = 2;";
  z[lc++]="	if (CSYSI_DELAY && ((csysi_cnt + 1) == csysi_len)) /* delay cmd */";
  z[lc++]="	  {";
  z[lc++]="	    csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	    return csysi_midiparseover();";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_PROGRAM:";
  z[lc++]="      case CSYS_MIDI_CTOUCH:";
  z[lc++]="	csysi_num = 1;";
  z[lc++]="	break;";
  z[lc++]="      case 0xF0: ";
  z[lc++]="	*cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	return csysi_sysflush(*extchan);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      if (CSYSI_DELAY && (csysi_cnt == csysi_len)) /* delay cmd */";
  z[lc++]="	{";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return csysi_midiparseover();";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else  /* running status or a delayed MIDI command */";
  z[lc++]="    {";
  z[lc++]="      *cmd = csysi_cmd;";
  z[lc++]="      *extchan = csysi_extchan;";
  z[lc++]="      if (CSYSI_DELAY && (csysi_ndata != 0xFF)) /* finish delayed cmd */";
  z[lc++]="	{";
  z[lc++]="	  *ndata = csysi_ndata;";
  z[lc++]="	  csysi_ndata = 0xFF;";
  z[lc++]="	  csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="			    ((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="	  *vdata = csysi_data[csysi_cnt++];";
  z[lc++]="	  if (csysi_cnt == csysi_len)";
  z[lc++]="	    return csysi_midiparseover();";
  z[lc++]="	  else";
  z[lc++]="	    return CSYS_MIDIEVENTS;";
  z[lc++]="	}";
  z[lc++]="      if (CSYSI_DELAY && (csysi_num == 2) && /* (further) delay cmd */";
  z[lc++]="	  (csysi_cnt + 1 == csysi_len))";
  z[lc++]="	{";
  z[lc++]="	  csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return csysi_midiparseover();";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* do complete commands and finish some types of delayed commands */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt + csysi_num <= csysi_len)";
  z[lc++]="    {";
  z[lc++]="      csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="			((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_num == 2)";
  z[lc++]="	*vdata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return csysi_midiparseover();";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* should never execute if CSYSI_DELAY is 1 */";
  z[lc++]="";
  z[lc++]="  csysi_newnote |= (((*cmd) == CSYS_MIDI_NOTEON) |";
  z[lc++]="		    ((*cmd) == CSYS_MIDI_NOTEOFF));";
  z[lc++]="";
  z[lc++]="  tot = csysi_cnt + csysi_num - csysi_len;";
  z[lc++]="  idx = 0;";
  z[lc++]="  while (tot > 0)";
  z[lc++]="    {";
  z[lc++]="      overflow[idx++] = csysi_getbyte();";
  z[lc++]="      tot--;";
  z[lc++]="    }";
  z[lc++]="  if (csysi_num == 1) ";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      return csysi_midiparseover();";
  z[lc++]="    }";
  z[lc++]="  if (csysi_cnt + 1 == csysi_len)";
  z[lc++]="    {";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      *vdata = overflow[0];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      *vdata = overflow[1];";
  z[lc++]="    }";
  z[lc++]="  return csysi_midiparseover();";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  /* disarm timer */";
  z[lc++]="";
  z[lc++]="  if (sigprocmask(SIG_BLOCK, &csysi_overrun_mask, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't mask MIDI overrun time\");";
  z[lc++]="";
  z[lc++]="  csysi_overrun_timer.it_value.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_value.tv_usec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_sec = 0;";
  z[lc++]="  csysi_overrun_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_REAL, &csysi_overrun_timer, NULL) < 0)";
  z[lc++]="    CSYSI_ERROR_TERMINATE(\"Couldn't disarm ITIMER_REAL timer\");";
  z[lc++]="";
  z[lc++]="  close(csysi_midi);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#undef CSYSI_MIDIDEV";
  z[lc++]="#undef CSYSI_BUFFSIZE";
  z[lc++]="#undef CSYSI_SYSEX_EOX";
  z[lc++]="#undef CSYSI_DELAY";
  z[lc++]="#undef CSYSI_ALARMPERIOD";
  z[lc++]="#undef CSYSI_ERROR_RETURN";
  z[lc++]="#undef CSYSI_ERROR_TERMINATE";
  z[lc++]="";
  printlib(lc);
}


void makewin32(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Win32 Directsound MIDI IN soundcard jack driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Author: Professor John Wawrzynek, UCB CS Division";
  z[lc++]="#    Maintainance Email To: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]=" * WIN32 midi driver for sfront.";
  z[lc++]=" *";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="";
  z[lc++]="#include <stdio.h>";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]=" * Globals";
  z[lc++]=" */";
  z[lc++]="#define  CSYSI_MIDIBUFSIZ 256";
  z[lc++]="";
  z[lc++]="// midi related";
  z[lc++]="";
  z[lc++]="DWORD    csysi_midiBufA[CSYSI_MIDIBUFSIZ];";
  z[lc++]="DWORD    csysi_midiBufB[CSYSI_MIDIBUFSIZ];";
  z[lc++]="";
  z[lc++]="DWORD * csysi_midiWrite;";
  z[lc++]="DWORD * csysi_bufWrPtr;";
  z[lc++]="";
  z[lc++]="DWORD * csysi_bufRdPtr;";
  z[lc++]="DWORD * csysi_midiRdEnd;";
  z[lc++]="";
  z[lc++]="HMIDIIN csysi_hMidiIn;";
  z[lc++]="";
  z[lc++]="// console stuff for graceful exit";
  z[lc++]="";
  z[lc++]="HANDLE csysi_hStdin;";
  z[lc++]="INPUT_RECORD csysi_irInBuf[1];";
  z[lc++]="DWORD csysi_cNumRead, csysi_fdwSaveOldMode;";
  z[lc++]="BOOL csysi_exitFlag;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             Callback routine for incoming events             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void CALLBACK csysi_MidiInProc(HMIDIIN hMidiIn, UINT wMsg, DWORD dwInstance,";
  z[lc++]="                         DWORD dwParam1, DWORD dwParam2)";
  z[lc++]="{";
  z[lc++]="  if (csysi_bufWrPtr==csysi_midiWrite+CSYSI_MIDIBUFSIZ)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Midi input buffer overflow, dropping event.\\n\");";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  *csysi_bufWrPtr++ = dwParam1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="{";
  z[lc++]="  csysi_midiWrite = csysi_bufWrPtr = &csysi_midiBufA;";
  z[lc++]="";
  z[lc++]="  // open first available midi input device";
  z[lc++]="";
  z[lc++]="  if (midiInOpen(&csysi_hMidiIn, (UINT) 0, (DWORD) ";
  z[lc++]="                 &csysi_MidiInProc, 0L, (DWORD) CALLBACK_FUNCTION))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"MidiInOpen error.\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (midiInStart(csysi_hMidiIn))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"MidiInStart error.\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  // Console";
  z[lc++]="";
  z[lc++]="  csysi_hStdin = GetStdHandle(STD_INPUT_HANDLE);";
  z[lc++]="  if (csysi_hStdin == INVALID_HANDLE_VALUE)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"GetStdHandle error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (! GetConsoleMode(csysi_hStdin, &csysi_fdwSaveOldMode) )";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"GetConsoleMode error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (! SetConsoleMode(csysi_hStdin, ENABLE_WINDOW_INPUT | ENABLE_MOUSE_INPUT)";
  z[lc++]=")";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"GetConsoleMode error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  csysi_cNumRead = 0;";
  z[lc++]="  csysi_exitFlag = FALSE;";
  z[lc++]="";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  // check for console input";
  z[lc++]="  PeekConsoleInput(csysi_hStdin, csysi_irInBuf, 1, &csysi_cNumRead);";
  z[lc++]="  if (csysi_cNumRead>0) ";
  z[lc++]="    {";
  z[lc++]="      csysi_exitFlag = TRUE;";
  z[lc++]="      fprintf(stderr, \"exiting ... \\n\");";
  z[lc++]="      return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  // now midi stuff";
  z[lc++]="  csysi_bufRdPtr = csysi_midiWrite;";
  z[lc++]="  csysi_midiRdEnd = csysi_bufWrPtr; ";
  z[lc++]="";
  z[lc++]="  // An input event RIGHT HERE will be lost!";
  z[lc++]="";
  z[lc++]="  // switch write buffer (avoid locking out incoming)";
  z[lc++]="  if (csysi_midiWrite==csysi_midiBufA) ";
  z[lc++]="    csysi_bufWrPtr = csysi_midiWrite = csysi_midiBufB;";
  z[lc++]="  else ";
  z[lc++]="      csysi_bufWrPtr = csysi_midiWrite = csysi_midiBufA;";
  z[lc++]="";
  z[lc++]="  if (csysi_midiRdEnd==csysi_bufRdPtr)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="                   unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="                   float * fval)";
  z[lc++]="{";
  z[lc++]="  DWORD msg;";
  z[lc++]="";
  z[lc++]="  // keyboard exit";
  z[lc++]="  if (csysi_exitFlag)";
  z[lc++]="    {";
  z[lc++]="      *cmd = CSYS_MIDI_ENDTIME;";
  z[lc++]="      *fval = scorebeats;";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  // unpack event";
  z[lc++]="  msg = *csysi_bufRdPtr++;";
  z[lc++]="  *cmd = 0xff & msg;";
  z[lc++]="  *ndata = (0xff00 & msg) >> 8;";
  z[lc++]="  *vdata = (0xff0000 & msg) >> 16;";
  z[lc++]="  *extchan = 0;";
  z[lc++]="";
  z[lc++]="  if (csysi_midiRdEnd==csysi_bufRdPtr)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  // restore console";
  z[lc++]="  if (! SetConsoleMode(csysi_hStdin, csysi_fdwSaveOldMode) )";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"GetConsoleMode error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  //close midi";
  z[lc++]="  if (midiInClose(csysi_hMidiIn))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"MidiInClose error.\\n\");";
  z[lc++]="    }";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  printlib(lc);
}


void makealsamidi(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: ALSA MIDI (Card 0, Device 0) control driver for sfront";
  z[lc++]="#";
  z[lc++]="#    Can anyone think of a way of specifying the card/device number?";
  z[lc++]="#";
  z[lc++]="#    This driver is a small modification of the linmidi.c driver.";
  z[lc++]="#    The modifications were made by Steven Pickles (pix@iname.com)";
  z[lc++]="#";
  z[lc++]="#    The original license information follows:";
  z[lc++]="#";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <sys/asoundlib.h>";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           linux /dev/mid00 control driver for sfront         */";
  z[lc++]="/*     alsamidi doesn't support root mode in -timesync yet      */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_BUFFSIZE  1024";
  z[lc++]="#define CSYSI_SYSEX_EOX 0xF7";
  z[lc++]="";
  z[lc++]="/* set CSYSI_DELAY to 0 to wait for partially completed MIDI commands */";
  z[lc++]="/* waiting for commands decreases variance of the latency, at the     */";
  z[lc++]="/* expense of losing computation cycles                               */";
  z[lc++]="";
  z[lc++]="#define CSYSI_DELAY 1";
  z[lc++]="";
  z[lc++]="void *csysi_handle;";
  z[lc++]="int csysi_card = 0;";
  z[lc++]="int csysi_device = 0;";
  z[lc++]="int csysi_error = 0;";
  z[lc++]="";
  z[lc++]="unsigned char csysi_hold[CSYSI_BUFFSIZE];";
  z[lc++]="unsigned char csysi_data[CSYSI_BUFFSIZE];";
  z[lc++]="long csysi_len;";
  z[lc++]="long csysi_cnt;";
  z[lc++]="unsigned char csysi_cmd;";
  z[lc++]="unsigned char csysi_num;";
  z[lc++]="unsigned short csysi_extchan;";
  z[lc++]="unsigned char csysi_ndata = 0xFF;";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if ((csysi_error = snd_rawmidi_open(&csysi_handle, csysi_card, csysi_device, SND_RAWMIDI_OPEN_INPUT)) < 0) {";
  z[lc++]="    fprintf(stderr, \"ALSAMIDI: open failed: %s\\n\", snd_strerror(csysi_error));";
  z[lc++]="    return CSYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if ((csysi_error = snd_rawmidi_block_mode(csysi_handle, 0)) < 0) {";
  z[lc++]="    fprintf(stderr, \"ALSAMIDI: disabling block mode failed: %s\\n\", snd_strerror(csysi_error));";
  z[lc++]="    return CSYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int i = 0;";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  len = snd_rawmidi_read(csysi_handle, csysi_hold, CSYSI_BUFFSIZE); ";
  z[lc++]="  if (len < 0)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="  csysi_len = csysi_cnt = 0;";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_hold[i] <= CSYSI_SYSEX_EOX)";
  z[lc++]="	csysi_data[csysi_len++] = csysi_hold[i];";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!csysi_len)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  return CSYS_MIDIEVENTS;";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             gets one byte from MIDI stream                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char csysi_getbyte(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char d;";
  z[lc++]="";
  z[lc++]="  while ( !(";
  z[lc++]="	    (snd_rawmidi_read(csysi_handle, &d, 1) == 1) &&";
  z[lc++]="	    (d <= CSYSI_SYSEX_EOX)) );";
  z[lc++]="  return d;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             flushes MIDI system messages                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_sysflush(unsigned short type)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char byte;";
  z[lc++]="";
  z[lc++]="  if ((type == 6) || /* one-byte messages */";
  z[lc++]="      (type == 1) || /* undefined messages */";
  z[lc++]="      (type == 4) ||";
  z[lc++]="      (type == 5))";
  z[lc++]="    { ";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return CSYS_NONE;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 3) /* song select -- 1 data byte */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      else";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return CSYS_NONE;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (type == 2) /* song pointer -- 2 data bytes */";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	csysi_cnt++;";
  z[lc++]="      else";
  z[lc++]="	csysi_getbyte();";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return CSYS_NONE;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (type == 0) ";
  z[lc++]="    {";
  z[lc++]="      if (csysi_cnt < csysi_len)";
  z[lc++]="	byte = csysi_data[csysi_cnt++];";
  z[lc++]="      else";
  z[lc++]="	byte = csysi_getbyte();";
  z[lc++]="      while (byte < CSYS_MIDI_NOTEOFF)";
  z[lc++]="	if (csysi_cnt < csysi_len)";
  z[lc++]="	  byte = csysi_data[csysi_cnt++];";
  z[lc++]="	else";
  z[lc++]="	  byte = csysi_getbyte();";
  z[lc++]="      if (byte != CSYSI_SYSEX_EOX) /* non-compliant MIDI */";
  z[lc++]="	{";
  z[lc++]="	  if ((byte&0xF0) != 0xF0)";
  z[lc++]="	    {";
  z[lc++]="	      csysi_cmd = byte&0xF0;";
  z[lc++]="	      csysi_extchan = byte&0x0F;";
  z[lc++]="	    }";
  z[lc++]="	  switch (byte&0xF0) {";
  z[lc++]="	  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	  case CSYS_MIDI_NOTEON:";
  z[lc++]="	  case CSYS_MIDI_PTOUCH:";
  z[lc++]="	  case CSYS_MIDI_WHEEL:";
  z[lc++]="	  case CSYS_MIDI_CC:";
  z[lc++]="	    csysi_num = 2;";
  z[lc++]="	    break;";
  z[lc++]="	  case CSYS_MIDI_PROGRAM:";
  z[lc++]="	  case CSYS_MIDI_CTOUCH:";
  z[lc++]="	    csysi_num = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 0xF0: ";
  z[lc++]="	    if ((byte&0x0F)==2) /* song pointer -- 2 data bytes */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    if ((byte&0x0F)==3) /* song select -- 1 data byte */";
  z[lc++]="	      {";
  z[lc++]="		if (csysi_cnt < csysi_len)";
  z[lc++]="		  csysi_cnt++;";
  z[lc++]="		else";
  z[lc++]="		  csysi_getbyte();";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* outside of if {} to catch errant F7 bytes */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt == csysi_len)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char overflow[2], oval;";
  z[lc++]="  int len, tot, idx;";
  z[lc++]="";
  z[lc++]="  if (csysi_data[csysi_cnt] > 127)    /* a command byte */";
  z[lc++]="    {";
  z[lc++]="      *cmd = 0xF0 & csysi_data[csysi_cnt];";
  z[lc++]="      *extchan = 0x0F & csysi_data[csysi_cnt];";
  z[lc++]="      if (*cmd != 0xF0)";
  z[lc++]="	{";
  z[lc++]="	  csysi_cmd = *cmd;";
  z[lc++]="	  csysi_extchan = *extchan;";
  z[lc++]="	}";
  z[lc++]="      csysi_cnt++;";
  z[lc++]="      switch (*cmd) {";
  z[lc++]="      case CSYS_MIDI_NOTEOFF:";
  z[lc++]="      case CSYS_MIDI_NOTEON:";
  z[lc++]="      case CSYS_MIDI_PTOUCH:";
  z[lc++]="      case CSYS_MIDI_WHEEL:";
  z[lc++]="      case CSYS_MIDI_CC:";
  z[lc++]="	csysi_num = 2;";
  z[lc++]="	if (CSYSI_DELAY && ((csysi_cnt + 1) == csysi_len)) /* delay cmd */";
  z[lc++]="	  {";
  z[lc++]="	    csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	    return CSYS_NONE;";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_MIDI_PROGRAM:";
  z[lc++]="      case CSYS_MIDI_CTOUCH:";
  z[lc++]="	csysi_num = 1;";
  z[lc++]="	break;";
  z[lc++]="      case 0xF0: ";
  z[lc++]="	*cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	return csysi_sysflush(*extchan);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      if (CSYSI_DELAY && (csysi_cnt == csysi_len)) /* delay cmd */";
  z[lc++]="	{";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return CSYS_NONE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else  /* running status or a delayed MIDI command */";
  z[lc++]="    {";
  z[lc++]="      *cmd = csysi_cmd;";
  z[lc++]="      *extchan = csysi_extchan;";
  z[lc++]="      if (CSYSI_DELAY && (csysi_ndata != 0xFF)) /* finish delayed cmd */";
  z[lc++]="	{";
  z[lc++]="	  *ndata = csysi_ndata;";
  z[lc++]="	  csysi_ndata = 0xFF;";
  z[lc++]="	  *vdata = csysi_data[csysi_cnt++];";
  z[lc++]="	  if (csysi_cnt == csysi_len)";
  z[lc++]="	    return CSYS_NONE;";
  z[lc++]="	  else";
  z[lc++]="	    return CSYS_MIDIEVENTS;";
  z[lc++]="	}";
  z[lc++]="      if (CSYSI_DELAY && (csysi_num == 2) && /* (further) delay cmd */";
  z[lc++]="	  (csysi_cnt + 1 == csysi_len))";
  z[lc++]="	{";
  z[lc++]="	  csysi_ndata = csysi_data[csysi_cnt];";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="	  return CSYS_NONE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* do complete commands and finish some types of delayed commands */";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt + csysi_num <= csysi_len)";
  z[lc++]="    {";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_num == 2)";
  z[lc++]="	*vdata = csysi_data[csysi_cnt++];";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	return CSYS_NONE;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* should never execute if CSYSI_DELAY is 1 */";
  z[lc++]="";
  z[lc++]="  tot = csysi_cnt + csysi_num - csysi_len;";
  z[lc++]="  idx = 0;";
  z[lc++]="  while (tot > 0)";
  z[lc++]="    {";
  z[lc++]="      if ( ";
  z[lc++]="	  //(read(csysi_midi, &oval, 1) == 1) &&";
  z[lc++]="	  (snd_rawmidi_read(csysi_handle, &oval, 1) == 1) &&";
  z[lc++]="	   (oval <= CSYSI_SYSEX_EOX) )";
  z[lc++]="	{";
  z[lc++]="	  tot--;";
  z[lc++]="	  overflow[idx++] = oval;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_num == 1) ";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="  if (csysi_cnt + 1 == csysi_len)";
  z[lc++]="    {";
  z[lc++]="      *ndata = csysi_data[csysi_cnt++];";
  z[lc++]="      *vdata = overflow[0];";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *ndata = overflow[0];";
  z[lc++]="      *vdata = overflow[1];";
  z[lc++]="    }";
  z[lc++]="  return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  snd_rawmidi_close(csysi_handle);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makealsaseq(void)
{
  int lc = 0;

  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: ALSA Sequencer Control driver for Sfront.";
  z[lc++]="#";
  z[lc++]="#    This driver was originaly based on the alsamidi driver, but has";
  z[lc++]="#    been almost completely rewritten.";
  z[lc++]="#";
  z[lc++]="#    Copyright (C) 2001  Enrique Robledo Arnuncio";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <sys/asoundlib.h>";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* Linux ALSA /dev/snd/seq control driver for sfront            */";
  z[lc++]="/* See the alsaseq README file included in the sfman for usage  */";
  z[lc++]="/* tips and some configuration issues.                          */";
  z[lc++]="/* Specific command line options:                               */";
  z[lc++]="/*                                                              */";
  z[lc++]="/*      -csys_alsaseq_subscribe client:port [client:port ...]   */";
  z[lc++]="/*                                                              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#undef CSYSI_DEBUG";
  z[lc++]="";
  z[lc++]="/* Configuration for multiple connections */";
  z[lc++]="#define CSYSI_MAX_DEVS 32";
  z[lc++]="#define CSYSI_MAP2_BITS 6";
  z[lc++]="#define CSYSI_MASK1  0xFFC0";
  z[lc++]="";
  z[lc++]="/* Driver info */";
  z[lc++]="snd_seq_t *csysi_handle;";
  z[lc++]="int        csysi_port;";
  z[lc++]="unsigned short csysi_self_addr;";
  z[lc++]="";
  z[lc++]="/* ALSA address <-> channel device number associative tables interface */";
  z[lc++]="void csysi_init_maps();";
  z[lc++]="int  csysi_new_ext_channel_device(unsigned short  alsa_addr);";
  z[lc++]="int  csysi_read_ext_channel_device(unsigned short alsa_addr);";
  z[lc++]="void csysi_remove_ext_channel_device(unsigned short alsa_addr);";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_parse_address(const char* str)";
  z[lc++]="{";
  z[lc++]="  const char *port = NULL;";
  z[lc++]="  int c,p;";
  z[lc++]="  const char* pt;";
  z[lc++]="  ";
  z[lc++]="  if (str==NULL)";
  z[lc++]="    return -1;";
  z[lc++]="  for (pt=str; *pt!=0; pt++) {";
  z[lc++]="    if (*pt == ':' || *pt == '.')";
  z[lc++]="      if (port==NULL) port = pt+1;";
  z[lc++]="      else return -1;";
  z[lc++]="    else";
  z[lc++]="      if (!isdigit(*pt))";
  z[lc++]="	return -1;";
  z[lc++]="  }";
  z[lc++]="  if (port == NULL)";
  z[lc++]="    return -1;";
  z[lc++]="  c = atoi(str);";
  z[lc++]="  p = atoi(port);";
  z[lc++]="  if (c<0 || c>255 || p<0 || p>255)";
  z[lc++]="    return -1;";
  z[lc++]="  return c<<8|p;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="{";
  z[lc++]="  int res,arg,addr;";
  z[lc++]="  ";
  z[lc++]="  /* Driver connection */";
  z[lc++]="  if ((res = snd_seq_open(&csysi_handle, SND_SEQ_OPEN_IN)) < 0) {";
  z[lc++]="    fprintf(stderr, \"ALSASEQ: Open failed: %s\\n\", snd_strerror(res));";
  z[lc++]="    return CSYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="  if ((res = snd_seq_set_client_name(csysi_handle,";
  z[lc++]="				     \"Sfront SA Synthesizer\")) < 0) {";
  z[lc++]="    fprintf(stderr, \"ALSASEQ: Could not set name: %s\\n\",";
  z[lc++]="	    snd_strerror(res));";
  z[lc++]="    snd_seq_close(csysi_handle);";
  z[lc++]="    return CSYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="  if ((res = snd_seq_create_simple_port(csysi_handle,";
  z[lc++]="					\"MIDI input\",";
  z[lc++]="					SND_SEQ_PORT_CAP_WRITE | ";
  z[lc++]="					SND_SEQ_PORT_CAP_SUBS_WRITE,";
  z[lc++]="					SND_SEQ_PORT_TYPE_SYNTH)) < 0) {";
  z[lc++]="    fprintf(stderr, \"ALSASEQ: Port creation failed: %s\\n\",";
  z[lc++]="	    snd_strerror(res));";
  z[lc++]="    snd_seq_close(csysi_handle);";
  z[lc++]="    return CSYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="  csysi_port = res;";
  z[lc++]="  csysi_self_addr = snd_seq_client_id(csysi_handle) << 8 + res;";
  z[lc++]="  ";
  z[lc++]="  /* Extended channel mapping tables initialization */";
  z[lc++]="  csysi_init_maps();";
  z[lc++]="  ";
  z[lc++]="  /* Command line processing */";
  z[lc++]="  for (arg=1; arg<csys_argc; arg++) {";
  z[lc++]="    if (strcmp(csys_argv[arg],\"-csys_alsaseq_subscribe\"))";
  z[lc++]="      continue;";
  z[lc++]="    while ((arg+1)<csys_argc && csys_argv[arg+1][0] != '-') {";
  z[lc++]="      arg++;";
  z[lc++]="      if ((addr = csysi_parse_address(csys_argv[arg])) < 0) {";
  z[lc++]="	fprintf(stderr,\"ALSASEQ: Warning: Invalid ALSA address: %s\\n\\n\",";
  z[lc++]="		csys_argv[arg]);";
  z[lc++]="	continue;";
  z[lc++]="      }";
  z[lc++]="      if (csysi_new_ext_channel_device(addr) < 0) {";
  z[lc++]="	fprintf(stderr,\"ALSASEQ: Warning: Ignored subscription to %s:\\n\"";
  z[lc++]="		\"         Too many extended channel devices in use.\\n\\n\",";
  z[lc++]="		csys_argv[arg]);";
  z[lc++]="	continue;";
  z[lc++]="      }";
  z[lc++]="      if ((res = snd_seq_connect_from(csysi_handle,";
  z[lc++]="				      csysi_port,";
  z[lc++]="				      (addr&0xFF00)>>8,";
  z[lc++]="				      addr&0x00FF)) < 0) {";
  z[lc++]="	csysi_remove_ext_channel_device(addr);";
  z[lc++]="	fprintf(stderr,";
  z[lc++]="		\"ALSASEQ: Warning: Could not connect\"";
  z[lc++]="		\"to the given address: %s\\n\\n\",";
  z[lc++]="		csys_argv[arg]);";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="  }";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int len;";
  z[lc++]="  ";
  z[lc++]="  len = snd_seq_event_input_pending(csysi_handle,1);";
  z[lc++]="  if (len <= 0)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,";
  z[lc++]="		   unsigned char * ndata, ";
  z[lc++]="		   unsigned char * vdata, ";
  z[lc++]="		   unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  snd_seq_event_t *event;";
  z[lc++]="  int len,res,device;";
  z[lc++]="  unsigned short channel;";
  z[lc++]="  unsigned short alsa_address;";
  z[lc++]="  ";
  z[lc++]="  res = snd_seq_event_input(csysi_handle,&event);";
  z[lc++]="  if (res<0) {";
  z[lc++]="    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="    return CSYS_DONE;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  /* First, we check where does the event come from */";
  z[lc++]="  alsa_address = event->source.client << 8 + event->source.port;";
  z[lc++]="  ";
  z[lc++]="  if (alsa_address == csysi_self_addr) {";
  z[lc++]="    switch (event->type) {";
  z[lc++]="    case SND_SEQ_EVENT_PORT_USED:";
  z[lc++]="      alsa_address = event->data.addr.client << 8 + ";
  z[lc++]="	event->data.addr.port;";
  z[lc++]="      device = csysi_new_ext_channel_device(alsa_address);";
  z[lc++]="#ifdef CSYSI_DEBUG";
  z[lc++]="      if (device < 0)";
  z[lc++]="	fprintf(stderr,\"ALSASEQ: Could not map %d:%d:\"";
  z[lc++]="		\" no extended devices left\\n\",";
  z[lc++]="		event->data.addr.client,";
  z[lc++]="		event->data.addr.port);";
  z[lc++]="      else";
  z[lc++]="	fprintf(stderr,\"ALSASEQ: %d:%d mapped to extended device %d\\n\",";
  z[lc++]="		event->data.addr.client,";
  z[lc++]="		event->data.addr.port,";
  z[lc++]="		device);";
  z[lc++]="#endif				";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="    if ( snd_seq_event_input_pending(csysi_handle,1) <= 0)";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    return CSYS_EVENTS;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  device = csysi_read_ext_channel_device(alsa_address);";
  z[lc++]="  if (device<0) {	/* Unregistered source. Should not happen. */";
  z[lc++]="    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="    if ( snd_seq_event_input_pending(csysi_handle,1) <= 0)";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    return CSYS_EVENTS;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  switch (event->type) {";
  z[lc++]="  case SND_SEQ_EVENT_NOTEON:";
  z[lc++]="    *cmd = CSYS_MIDI_NOTEON;";
  z[lc++]="    *ndata = event->data.note.note;";
  z[lc++]="    *vdata = event->data.note.velocity;";
  z[lc++]="    channel = event->data.note.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_NOTEOFF:";
  z[lc++]="    *cmd = CSYS_MIDI_NOTEOFF;";
  z[lc++]="    *ndata = event->data.note.note;";
  z[lc++]="    channel = event->data.note.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_KEYPRESS: /* Not tested */";
  z[lc++]="    *cmd = CSYS_MIDI_PTOUCH;";
  z[lc++]="    *ndata = event->data.note.note;";
  z[lc++]="    *vdata = event->data.note.velocity;";
  z[lc++]="    channel = event->data.note.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_CONTROLLER:";
  z[lc++]="    *cmd = CSYS_MIDI_CC;";
  z[lc++]="    *ndata = event->data.control.param;";
  z[lc++]="    *vdata = event->data.control.value;";
  z[lc++]="    channel = event->data.control.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_PGMCHANGE:";
  z[lc++]="    *cmd = CSYS_MIDI_PROGRAM;";
  z[lc++]="    *ndata = event->data.control.value;";
  z[lc++]="    channel = event->data.control.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_CHANPRESS:";
  z[lc++]="    *cmd = CSYS_MIDI_CTOUCH;";
  z[lc++]="    *ndata = event->data.control.value;";
  z[lc++]="    channel = event->data.control.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_PITCHBEND:";
  z[lc++]="    *cmd = CSYS_MIDI_WHEEL;";
  z[lc++]="    *ndata =  event->data.control.value &  0x007F;";
  z[lc++]="    *vdata = (event->data.control.value & (0x007F << 7) ) >> 7;";
  z[lc++]="    channel = event->data.control.channel;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_TEMPO: /* ??? Not tested. */";
  z[lc++]="    *cmd = CSYS_MIDI_NEWTEMPO;";
  z[lc++]="    *fval = (float)event->data.queue.param.value;";
  z[lc++]="    break;";
  z[lc++]="  case SND_SEQ_EVENT_PORT_UNUSED:";
  z[lc++]="    csysi_remove_ext_channel_device(alsa_address);";
  z[lc++]="#ifdef CSYSI_DEBUG";
  z[lc++]="    fprintf(stderr,\"ALSASEQ: %d:%d disconected from device %d\\n\",";
  z[lc++]="	    event->data.addr.client,";
  z[lc++]="	    event->data.addr.port,";
  z[lc++]="	    device);";
  z[lc++]="#endif";
  z[lc++]="    break;";
  z[lc++]="    /* No MIDI_ENDTIME event in alsa? */";
  z[lc++]="  default:";
  z[lc++]="    *cmd = CSYS_MIDI_NOOP;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  *extchan = device * 16 + channel;";
  z[lc++]="  ";
  z[lc++]="  len = snd_seq_event_input_pending(csysi_handle,1);";
  z[lc++]="  if (len <= 0)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  return CSYS_EVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="{";
  z[lc++]="  snd_seq_close(csysi_handle);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        ALSA address to extended channel device mapping       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* New alsa subscriptions to our port are asigned an \"extended device";
  z[lc++]=" * number\" (dev). Extended channels will be calculated as:";
  z[lc++]=" *     extchan = dev*16 + MIDI_channel";
  z[lc++]=" * The structures and functions below do the mapping between alsa";
  z[lc++]=" * addresses and extended device number, using an asociative table";
  z[lc++]=" * mechanism. A single level of indirection would require a 64Kb";
  z[lc++]=" * table, so we use two levels of indirection.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="#define CSYSI_MASK2 ~CSYSI_MASK1";
  z[lc++]="#define CSYSI_SIZE1 ( 1 << (16-CSYSI_MAP2_BITS) )";
  z[lc++]="#define CSYSI_SIZE2 ( 1 << CSYSI_MAP2_BITS )";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="unsigned char csysi_is_used_dev[CSYSI_MAX_DEVS];";
  z[lc++]="unsigned char csysi_available_dev;";
  z[lc++]="unsigned short csysi_used_devs;";
  z[lc++]="unsigned char csysi_map1[CSYSI_SIZE1];";
  z[lc++]="unsigned char csysi_map2[CSYSI_MAX_DEVS][CSYSI_SIZE2];";
  z[lc++]="unsigned char csysi_map2_counts[CSYSI_MAX_DEVS];";
  z[lc++]="unsigned char csysi_available_page;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* Initialize Address mapping structures */";
  z[lc++]="void csysi_init_maps()";
  z[lc++]="{";
  z[lc++]="  int i,j;";
  z[lc++]="  ";
  z[lc++]="  for (i=0; i<CSYSI_SIZE1; i++)";
  z[lc++]="    csysi_map1[i]=0xFF;";
  z[lc++]="  for (i=0; i<CSYSI_MAX_DEVS; i++) {";
  z[lc++]="    csysi_is_used_dev[i]=0;";
  z[lc++]="    csysi_map2_counts[i]=0;";
  z[lc++]="    for (j=0; j<CSYSI_SIZE2; j++)";
  z[lc++]="      csysi_map2[i][j]=0xFF;";
  z[lc++]="  }";
  z[lc++]="  csysi_used_devs = 0;";
  z[lc++]="  csysi_available_dev = 0;";
  z[lc++]="  csysi_available_page = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* Get extended channel device number for an alsa address.  ";
  z[lc++]=" * Returns the extended channel number, or -1 if the address was not";
  z[lc++]=" * mapped. */";
  z[lc++]="int csysi_read_ext_channel_device(unsigned short addr)";
  z[lc++]="{";
  z[lc++]="  unsigned short idx1,idx2_1,idx2_2;";
  z[lc++]="";
  z[lc++]="  idx1 = ( addr &  CSYSI_MASK1 ) >> CSYSI_MAP2_BITS;";
  z[lc++]="  idx2_1 = csysi_map1[idx1];";
  z[lc++]="  idx2_2 = ( addr & CSYSI_MASK2 );";
  z[lc++]="  if ( idx2_1 > CSYSI_MAX_DEVS-1 || ";
  z[lc++]="       csysi_map2[idx2_1][idx2_2] > CSYSI_MAX_DEVS-1 )";
  z[lc++]="    return -1;";
  z[lc++]="  return csysi_map2[idx2_1][idx2_2];";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* Add an ALSA address to the asociative tables.  Returns <0 if there";
  z[lc++]=" * was no space left for the new address. Otherwhise, the address is";
  z[lc++]=" * mapped to the first available device number, which is returned.";
  z[lc++]=" * NOTE: In the worst case, the loops used to update the \"available";
  z[lc++]=" * page\" and the \"available device\" pointers can have a length of";
  z[lc++]=" * almost CSYSI_MAX_DEVS. This would happen in a system with most of";
  z[lc++]=" * the available pages/devices used, where a page/device near the";
  z[lc++]=" * begginig is freed, and then a new page/device is requested.";
  z[lc++]=" * Hopefuly this can be asumed to be infrecuent enough, so we can";
  z[lc++]=" * avoid using a more complicated mechanism to track free";
  z[lc++]=" * pages/devices */";
  z[lc++]="int csysi_new_ext_channel_device(unsigned short addr)";
  z[lc++]="{";
  z[lc++]="  unsigned short idx1,idx2_1,idx2_2,dev;";
  z[lc++]="";
  z[lc++]="  if (csysi_used_devs > CSYSI_MAX_DEVS-1)";
  z[lc++]="    return -1;";
  z[lc++]="  ";
  z[lc++]="  idx1 = ( addr & CSYSI_MASK1 ) >> CSYSI_MAP2_BITS;";
  z[lc++]="  idx2_1 = csysi_map1[idx1];";
  z[lc++]="  idx2_2 = ( addr & CSYSI_MASK2 );";
  z[lc++]="  if ( idx2_1 < CSYSI_MAX_DEVS &&";
  z[lc++]="       csysi_map2[idx2_1][idx2_2] < CSYSI_MAX_DEVS )";
  z[lc++]="    return csysi_map2[idx2_1][idx2_2];";
  z[lc++]="  ";
  z[lc++]="  if (idx2_1 > CSYSI_MAX_DEVS-1) {";
  z[lc++]="    idx2_1 = csysi_map1[idx1] = csysi_available_page;";
  z[lc++]="    while (csysi_map2_counts[++csysi_available_page])";
  z[lc++]="      if (csysi_available_page==CSYSI_MAX_DEVS)";
  z[lc++]="	break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  dev = csysi_map2[idx2_1][idx2_2] = csysi_available_dev;";
  z[lc++]="  csysi_used_devs++;";
  z[lc++]="  csysi_map2_counts[idx2_1]++;";
  z[lc++]="  csysi_is_used_dev[csysi_available_dev] = 1;";
  z[lc++]="  while (csysi_is_used_dev[++csysi_available_dev])";
  z[lc++]="    if (csysi_available_dev==CSYSI_MAX_DEVS)";
  z[lc++]="      break;";
  z[lc++]="  ";
  z[lc++]="  return dev;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* Removes an ALSA address to the asociative tables. */";
  z[lc++]="void csysi_remove_ext_channel_device(unsigned short addr)";
  z[lc++]="{";
  z[lc++]="  unsigned short idx1,idx2_1,idx2_2,dev;";
  z[lc++]="  ";
  z[lc++]="  idx1 = ( addr & CSYSI_MASK1 ) >> CSYSI_MAP2_BITS;";
  z[lc++]="  idx2_1 = csysi_map1[idx1];";
  z[lc++]="  idx2_2 = ( addr & CSYSI_MASK2 );";
  z[lc++]="  if ( idx2_1 > CSYSI_MAX_DEVS-1 || ";
  z[lc++]="       csysi_map2[idx2_1][idx2_2] > CSYSI_MAX_DEVS-1 ||";
  z[lc++]="       !csysi_map2_counts[idx2_1] ||";
  z[lc++]="       !csysi_used_devs )";
  z[lc++]="    return;";
  z[lc++]="  ";
  z[lc++]="  dev = csysi_map2[idx2_1][idx2_2];";
  z[lc++]="  csysi_map2[idx2_1][idx2_2] = 0xFF;";
  z[lc++]="  csysi_is_used_dev[dev]=0;";
  z[lc++]="  csysi_used_devs--;";
  z[lc++]="  if (dev < csysi_available_dev)";
  z[lc++]="    csysi_available_dev = dev;";
  z[lc++]="  ";
  z[lc++]="  if (--csysi_map2_counts[idx2_1]==0) {";
  z[lc++]="    csysi_map1[idx1] = 0xFF;";
  z[lc++]="    if (idx2_1 < csysi_available_page)";
  z[lc++]="      csysi_available_page = idx2_1;";
  z[lc++]="  }";
  z[lc++]="}";
  printlib(lc);
}


void makefstr(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Plays streaming data from .mp4 file.";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           streaming file control driver for sfront           */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define SAMP_SR        5";
  z[lc++]="#define SAMP_LOOPSTART 4";
  z[lc++]="#define SAMP_LOOPEND   3";
  z[lc++]="#define SAMP_BASEFREQ  2";
  z[lc++]="#define SAMP_LLMEM     1";
  z[lc++]="#define SAMP_DATABLOCK 5";
  z[lc++]="";
  z[lc++]="FILE * csysi_bitfile;   /* streaming file */";
  z[lc++]="";
  z[lc++]="/* bit-level state variables */";
  z[lc++]="";
  z[lc++]="unsigned char csysi_bitstoread = 0;";
  z[lc++]="int csysi_bitreadpos = - 1;";
  z[lc++]="";
  z[lc++]="/* bit-level parsing constants */";
  z[lc++]="";
  z[lc++]="#define CSYSI_IDENT        0xF0";
  z[lc++]="#define CSYSI_NUMBER       0xF1";
  z[lc++]="#define CSYSI_INTGR        0xF2";
  z[lc++]="#define CSYSI_STRCONST     0xF3";
  z[lc++]="#define CSYSI_BYTE         0xF4";
  z[lc++]="";
  z[lc++]="#define CSYSI_BINORC   0";
  z[lc++]="#define CSYSI_BINSCORE 1";
  z[lc++]="#define CSYSI_BINMIDI  2";
  z[lc++]="#define CSYSI_BINSAMP  3";
  z[lc++]="#define CSYSI_BINSBF   4";
  z[lc++]="#define CSYSI_BINSYM   5";
  z[lc++]="";
  z[lc++]="#define CSYSI_EVSCORE  0";
  z[lc++]="#define CSYSI_EVMIDI   1";
  z[lc++]="#define CSYSI_EVSAMPLE 2";
  z[lc++]="";
  z[lc++]="#define CSYSI_MIDIMASKCOM  0xF0";
  z[lc++]="#define CSYSI_MIDISYSTEM   0xF0";
  z[lc++]="#define CSYSI_MIDIMASKCHAN 0x0F";
  z[lc++]="#define CSYSI_METATEMPO    0x51";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXENDTIME   21600.0F";
  z[lc++]="";
  z[lc++]="/* word-level state variables */";
  z[lc++]="";
  z[lc++]="float csysi_bitaccesstime = 0.0F;  /* current SA_access_unit time */";
  z[lc++]="";
  z[lc++]="int csysi_moreaccessunits = 1;     /* more access_units left to read */";
  z[lc++]="int csysi_endofevent = 1;          /* no more events in access_unit  */";
  z[lc++]="";
  z[lc++]="int csysi_numabstime = 0;          /* number of abs-time sasl events */";
  z[lc++]="int csysi_numscotime = 0;          /* number of rel-time sasl events */";
  z[lc++]="int csysi_nummidi = 0;             /* number of midi events */";
  z[lc++]="";
  z[lc++]="int csysi_absready = 0;            /* abs-time sasl events triggered */";
  z[lc++]="int csysi_scoready = 0;            /* rel-time sasl events triggered */";
  z[lc++]="int csysi_midiready = 0;           /* midi events triggered */";
  z[lc++]="";
  z[lc++]="int csysi_targetvar = -1;         /* pointer into csys_target[] */";
  z[lc++]="int csysi_targetcount = 0;        /* pointer info {instr,var}index  */";
  z[lc++]="";
  z[lc++]="unsigned char csysi_runstat = 0;  /* holds running status byte      */";
  z[lc++]="int csysi_endflag = 0;            /* flag for issuing last end command */";
  z[lc++]="float csysi_compendtime = 0;      /* supplied computed endtime         */";
  z[lc++]="";
  z[lc++]=" ";
  z[lc++]="/* data structures for pending events */";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXSASL 64";
  z[lc++]="";
  z[lc++]="/* add at the head, consume from the tail */";
  z[lc++]="";
  z[lc++]="int csysi_headsco = 0;  /* next available place for data */";
  z[lc++]="int csysi_tailsco = -1; /* first occupied place for data */";
  z[lc++]=" ";
  z[lc++]="int csysi_headabs = 0;  /* next available place for data */";
  z[lc++]="int csysi_tailabs = -1; /* first occupied place for data */";
  z[lc++]=" ";
  z[lc++]="typedef struct csysi_sevent {";
  z[lc++]="  float atime;";
  z[lc++]="  float stime;";
  z[lc++]="  unsigned char cmd;";
  z[lc++]="  unsigned char priority;";
  z[lc++]="  unsigned short id;";
  z[lc++]="  unsigned short label;";
  z[lc++]="  float fval;";
  z[lc++]="  unsigned long pnum;";
  z[lc++]="  float * p;";
  z[lc++]="} csysi_sevent;";
  z[lc++]="";
  z[lc++]="csysi_sevent csysi_scoqueue[CSYSI_MAXSASL];";
  z[lc++]="csysi_sevent csysi_absqueue[CSYSI_MAXSASL];";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXMIDI 64";
  z[lc++]="";
  z[lc++]="/* add at the head, consume from the tail */";
  z[lc++]="";
  z[lc++]="int csysi_headmidi = 0;  /* next available place for data */";
  z[lc++]="int csysi_tailmidi = -1; /* first occupied place for data */";
  z[lc++]=" ";
  z[lc++]="typedef struct csysi_mevent {";
  z[lc++]="  float atime;";
  z[lc++]="  unsigned char cmd;";
  z[lc++]="  unsigned char ndata;";
  z[lc++]="  unsigned char vdata;";
  z[lc++]="  unsigned short extchan;";
  z[lc++]="  float fval;";
  z[lc++]="} csysi_mevent;";
  z[lc++]="";
  z[lc++]="csysi_mevent csysi_midiqueue[CSYSI_MAXMIDI];";
  z[lc++]="";
  z[lc++]="/* data structure for samples */";
  z[lc++]="";
  z[lc++]="typedef struct csysi_sampleunit {";
  z[lc++]="  float atime;";
  z[lc++]="  int token;";
  z[lc++]="  int len;";
  z[lc++]="  float * p;";
  z[lc++]="  struct csysi_sampleunit * next;";
  z[lc++]="} csysi_sampleunit;";
  z[lc++]="";
  z[lc++]="csysi_sampleunit * csysi_samples = NULL;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*                   gets next byte from bitfile                  */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_readnextbyte(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  while (fread(&csysi_bitstoread,sizeof(char),1,csysi_bitfile)!=1)";
  z[lc++]="    {";
  z[lc++]="      if (feof(csysi_bitfile))";
  z[lc++]="	csys_terminate(\"premature end of .mp4 file\");";
  z[lc++]="      if (++retry > IOERROR_RETRY)";
  z[lc++]="	csys_terminate(\"i/o problems during .mp4 file read\");";
  z[lc++]="      clearerr(csysi_bitfile);";
  z[lc++]="    }";
  z[lc++]="  csysi_bitreadpos = 7;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           reads numbits LSBs of bitval from bitfile            */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="unsigned long csysi_readbit(unsigned long numbits)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long ret = 0;";
  z[lc++]="";
  z[lc++]="  while (numbits > 0)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_bitreadpos < 0)";
  z[lc++]="	csysi_readnextbyte();";
  z[lc++]="      ret |= ";
  z[lc++]="	((csysi_bitstoread & (1 << csysi_bitreadpos)) != 0) << (numbits-1);";
  z[lc++]="      numbits--;";
  z[lc++]="      csysi_bitreadpos--;";
  z[lc++]="    }";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*        checks for next accessunit, sets bitaccesstime          */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_readaccesstime()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int numbits = 32;";
  z[lc++]="  union { unsigned long l; float f ; } u;";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  u.l = 0;";
  z[lc++]="  while (numbits > 0)";
  z[lc++]="    {";
  z[lc++]="      while (csysi_bitreadpos >= 0)";
  z[lc++]="	{";
  z[lc++]="	  u.l |= ";
  z[lc++]="	    ((csysi_bitstoread & (1 << csysi_bitreadpos)) != 0) << (numbits-1);";
  z[lc++]="	  csysi_bitreadpos--;";
  z[lc++]="	  if (!(--numbits))";
  z[lc++]="	    {";
  z[lc++]="	      csysi_bitaccesstime = u.f;";
  z[lc++]="	      return 1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      while (fread(&csysi_bitstoread,sizeof(char),1,csysi_bitfile)!=1)";
  z[lc++]="	{";
  z[lc++]="	  if (feof(csysi_bitfile))";
  z[lc++]="	    return 0;";
  z[lc++]="	  if (++retry > IOERROR_RETRY)";
  z[lc++]="	    csys_terminate(\"i/o problems during .mp4 file read\");";
  z[lc++]="	  clearerr(csysi_bitfile);";
  z[lc++]="	}";
  z[lc++]="      csysi_bitreadpos = 7;";
  z[lc++]="    }";
  z[lc++]="  return 0;  /* should never happen */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           flushes numbits of bitval from bitfile                */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void csysi_readflush(unsigned long numbits)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  while (numbits > 0)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_bitreadpos < 0)";
  z[lc++]="	csysi_readnextbyte();";
  z[lc++]="      numbits--;";
  z[lc++]="      csysi_bitreadpos--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past midi_file block                            */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_midifileflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  csysi_readflush(8*csysi_readbit(32));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past symboltable block                          */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_symboltableflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int num;";
  z[lc++]="";
  z[lc++]="  num = csysi_readbit(16);";
  z[lc++]="  while (num > 0)";
  z[lc++]="    {";
  z[lc++]="      csysi_readflush(8*csysi_readbit(4));      ";
  z[lc++]="      num--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past orcfile block                          */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_orcfileflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int num, token;";
  z[lc++]="";
  z[lc++]="  num = csysi_readbit(16);";
  z[lc++]="  while (num > 0)";
  z[lc++]="    {";
  z[lc++]="      token = csysi_readbit(8);";
  z[lc++]="      switch(token) {";
  z[lc++]="      case CSYSI_IDENT:";
  z[lc++]="	csysi_readflush(16);";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_NUMBER:";
  z[lc++]="	csysi_readflush(32);";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_INTGR:";
  z[lc++]="	csysi_readflush(32);";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_STRCONST:";
  z[lc++]="	csysi_readflush(8*csysi_readbit(8));";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BYTE:";
  z[lc++]="	csysi_readflush(8);";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      num--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past one score_line                             */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_scorelineflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int hastime, haslabel, scoretype;";
  z[lc++]="  int numpfields, destroy, refers, sym;";
  z[lc++]="";
  z[lc++]="  hastime = csysi_readbit(1);";
  z[lc++]="  if (hastime)";
  z[lc++]="    csysi_readflush(33);";
  z[lc++]="  csysi_readflush(1);";
  z[lc++]="  scoretype = csysi_readbit(3);";
  z[lc++]="  switch (scoretype) {";
  z[lc++]="  case CSYS_SASL_INSTR:";
  z[lc++]="    haslabel = csysi_readbit(1);";
  z[lc++]="    if (haslabel)";
  z[lc++]="      csysi_readflush(16);";
  z[lc++]="    csysi_readflush(48);";
  z[lc++]="    numpfields = csysi_readbit(8);";
  z[lc++]="    csysi_readflush(32*numpfields);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_CONTROL: ";
  z[lc++]="    haslabel = csysi_readbit(1);";
  z[lc++]="    if (haslabel)";
  z[lc++]="      csysi_readflush(16);";
  z[lc++]="    csysi_readflush(48);";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_TABLE:";
  z[lc++]="    csysi_readflush(16);";
  z[lc++]="    destroy = csysi_readbit(1);";
  z[lc++]="    if (!destroy)";
  z[lc++]="      {";
  z[lc++]="	sym = csysi_readbit(8);";
  z[lc++]="	refers = csysi_readbit(1);";
  z[lc++]="	if (refers)";
  z[lc++]="	  csysi_readflush(16);	";
  z[lc++]="	numpfields = csysi_readbit(16);";
  z[lc++]="	if (sym == CSYS_SASL_TGEN_CONCAT)";
  z[lc++]="	  {";
  z[lc++]="	    csysi_readflush(32);";
  z[lc++]="	    if ((numpfields - 1) > 0)";
  z[lc++]="	      csysi_readflush(16*(numpfields-1));";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  csysi_readflush(32*numpfields);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_ENDTIME:     ";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_TEMPO:   ";
  z[lc++]="    csysi_readflush(32);";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    csys_terminate(\"Unknown score line type in .mp4 file\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past score_file block                           */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_scorefileflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long numlines;";
  z[lc++]="";
  z[lc++]="  numlines = csysi_readbit(20);";
  z[lc++]="  while (numlines > 0)";
  z[lc++]="    {";
  z[lc++]="      csysi_scorelineflush();";
  z[lc++]="      numlines--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*           move past sample block                           */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_sampleflush(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  unsigned long len;";
  z[lc++]="";
  z[lc++]="  csysi_readflush(16);       /* symbol */";
  z[lc++]="  len = csysi_readbit(24);   ";
  z[lc++]="  if (csysi_readbit(1))      /* srate */";
  z[lc++]="    csysi_readflush(17);";
  z[lc++]="  if (csysi_readbit(1))      /* loop */";
  z[lc++]="    csysi_readflush(48);";
  z[lc++]="  if (csysi_readbit(1))      /* base */";
  z[lc++]="    csysi_readflush(32);";
  z[lc++]="  csysi_readflush((16+csysi_readbit(1)*16)*len);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*          flushes StructuredAudioSpecificConfig                 */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="void csysi_flushconfig(void) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int type;";
  z[lc++]="";
  z[lc++]="  while (csysi_readbit(1))";
  z[lc++]="    {";
  z[lc++]="      type = csysi_readbit(3);";
  z[lc++]="      switch (type) {";
  z[lc++]="      case CSYSI_BINORC:";
  z[lc++]="	csysi_orcfileflush();";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BINSCORE:";
  z[lc++]="	csysi_scorefileflush();";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BINMIDI: ";
  z[lc++]="	csysi_midifileflush();";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BINSAMP:";
  z[lc++]="	csysi_sampleflush();";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BINSBF:";
  z[lc++]="	csys_terminate(\".mp4 uses SASBF\");";
  z[lc++]="	break;";
  z[lc++]="      case CSYSI_BINSYM:   ";
  z[lc++]="	csysi_symboltableflush();";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*             puts score data in saslqueue[idx]                   */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_scorelinefill(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  union { unsigned long l; float f ; } u;";
  z[lc++]="  int sym, i, j, sampletoken, size, skip;";
  z[lc++]="  csysi_sampleunit * sidx;";
  z[lc++]="  csysi_sevent * cq;";
  z[lc++]="";
  z[lc++]="  if (csysi_readbit(1))      /* has_time */";
  z[lc++]="    {";
  z[lc++]="      cq = &(csysi_scoqueue[csysi_headsco]);";
  z[lc++]="      cq->atime = csysi_bitaccesstime;";
  z[lc++]="      if (csysi_tailsco == -1)";
  z[lc++]="	csysi_tailsco = csysi_headsco;";
  z[lc++]="      csysi_headsco = (csysi_headsco+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="";
  z[lc++]="      csysi_readflush(1);   /* use_if_late */";
  z[lc++]="      u.l = csysi_readbit(32);";
  z[lc++]="      cq->stime = u.f;";
  z[lc++]="      if (u.f < 0)";
  z[lc++]="	cq->stime = -1.0F;";
  z[lc++]="      csysi_numscotime++;";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      cq = &(csysi_absqueue[csysi_headabs]);";
  z[lc++]="      cq->atime = csysi_bitaccesstime;";
  z[lc++]="      if (csysi_tailabs == -1)";
  z[lc++]="	csysi_tailabs = csysi_headabs;";
  z[lc++]="      csysi_headabs = (csysi_headabs+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="";
  z[lc++]="      csysi_numabstime++;";
  z[lc++]="    }";
  z[lc++]="  cq->priority = csysi_readbit(1);      ";
  z[lc++]="  switch (cq->cmd = csysi_readbit(3)) {";
  z[lc++]="  case CSYS_SASL_INSTR:";
  z[lc++]="    if (csysi_readbit(1)) /* has label */";
  z[lc++]="      cq->label = csysi_readbit(16);";
  z[lc++]="    else";
  z[lc++]="      cq->label = CSYS_NOLABEL;";
  z[lc++]="    cq->cmd = CSYS_SASL_NOOP;";
  z[lc++]="    sym = csysi_readbit(16);  /* token for instr */";
  z[lc++]="    for (i=0; i < CSYS_INSTRNUM; i++)";
  z[lc++]="      if (csys_instr[i].token == sym)";
  z[lc++]="	{";
  z[lc++]="	  cq->cmd = CSYS_SASL_INSTR;";
  z[lc++]="	  cq->id = csys_instr[i].index;";
  z[lc++]="	}";
  z[lc++]="    u.l = csysi_readbit(32);         ";
  z[lc++]="    cq->fval = u.f;  /* duration */";
  z[lc++]=" ";
  z[lc++]="    /* pfields */";
  z[lc++]="    cq->p = malloc((cq->pnum = csysi_readbit(8))*sizeof(float));";
  z[lc++]="    for (i = 0; i < cq->pnum; i++)";
  z[lc++]="      {";
  z[lc++]="	u.l = csysi_readbit(32);  ";
  z[lc++]="	cq->p[i] =  u.f;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_CONTROL:";
  z[lc++]="    if (csysi_readbit(1)) /* has label */";
  z[lc++]="      {";
  z[lc++]="	/* expands into to a set of calls later on */";
  z[lc++]="";
  z[lc++]="	cq->label = csysi_readbit(16);";
  z[lc++]="	cq->pnum = csysi_readbit(16);";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	sym = csysi_readbit(16);";
  z[lc++]="	cq->cmd = CSYS_SASL_NOOP;";
  z[lc++]="	cq->label = CSYS_NOLABEL;";
  z[lc++]="	cq->id = CSYS_SASL_NOINSTR;";
  z[lc++]="	for (i=0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	  if (csys_global[i].token == sym)";
  z[lc++]="	    {";
  z[lc++]="	      cq->cmd = CSYS_SASL_CONTROL;";
  z[lc++]="	      cq->pnum = csys_global[i].index;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="      }";
  z[lc++]="    u.l = csysi_readbit(32);";
  z[lc++]="    cq->fval = u.f;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_TABLE:";
  z[lc++]="    sidx = NULL;";
  z[lc++]="    sym = csysi_readbit(16);";
  z[lc++]="    if (csysi_readbit(1)) /* destroy */";
  z[lc++]="      {";
  z[lc++]="	cq->label = CSYS_SASL_TGEN_DESTROY;";
  z[lc++]="	cq->pnum = 0;";
  z[lc++]="	cq->p = NULL;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	cq->label = csysi_readbit(8); /* generator */";
  z[lc++]="	if (csysi_readbit(1)) /* refers to sample */";
  z[lc++]="	  {";
  z[lc++]="	    sampletoken = csysi_readbit(16);";
  z[lc++]="	    sidx = csysi_samples;";
  z[lc++]="	    while (sidx)";
  z[lc++]="	      {";
  z[lc++]="		if (sidx->token == sampletoken)";
  z[lc++]="		  {";
  z[lc++]="		    while (sidx->next && ";
  z[lc++]="			   (sidx->next->token == sampletoken) &&";
  z[lc++]="			   (sidx->next->atime <= csysi_bitaccesstime))";
  z[lc++]="		      sidx = sidx->next;";
  z[lc++]="		    break;";
  z[lc++]="		  }";
  z[lc++]="		sidx = sidx->next;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	cq->p = malloc((cq->pnum = csysi_readbit(16))*sizeof(float));";
  z[lc++]="	for (i = 0; i < cq->pnum; i++)";
  z[lc++]="	  {";
  z[lc++]="	    if (i && (cq->label == CSYS_SASL_TGEN_CONCAT))";
  z[lc++]="	      {";
  z[lc++]="		u.l = csysi_readbit(16);  ";
  z[lc++]="		cq->p[i] = -1.0F;";
  z[lc++]="		for (j=0; j < CSYS_GLOBALNUM; j++)";
  z[lc++]="		  if ((csys_global[j].token == u.l) &&";
  z[lc++]="		      (csys_global[j].type == CSYS_TABLE))";
  z[lc++]="		    {";
  z[lc++]="		      cq->p[i] = csys_global[j].index;";
  z[lc++]="		      break;";
  z[lc++]="		    }";
  z[lc++]="		if (cq->p[i] == -1.0F)";
  z[lc++]="		  csys_terminate(\"concat uses an unknown table\");";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		u.l = csysi_readbit(32);  ";
  z[lc++]="		cq->p[i] = u.f;";
  z[lc++]="	      }";
  z[lc++]="	  }	";
  z[lc++]="	cq->cmd = CSYS_SASL_NOOP;";
  z[lc++]="	for (i=0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	  if ((csys_global[i].token == sym) &&";
  z[lc++]="	      (csys_global[i].type == CSYS_TABLE))";
  z[lc++]="	    {";
  z[lc++]="	      cq->cmd = CSYS_SASL_TABLE;";
  z[lc++]="	      cq->id = csys_global[i].index;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="	if (cq->label == CSYS_SASL_TGEN_SAMPLE)";
  z[lc++]="	  {";
  z[lc++]="	    if (!sidx)";
  z[lc++]="	      csys_terminate(\"sample block not found\");";
  z[lc++]="";
  z[lc++]="	    size = -1;";
  z[lc++]="	    skip = 0;";
  z[lc++]="	    if (cq->pnum)";
  z[lc++]="	      size = ROUND(cq->p[0]);";
  z[lc++]="	    if (cq->pnum > 2)";
  z[lc++]="	      skip = ROUND(cq->p[2]);";
  z[lc++]="	    /* free (cq->p); */";
  z[lc++]="	    if ( ((size < 0) || (size + SAMP_DATABLOCK <= sidx->len))";
  z[lc++]="		 && (skip <= 0))";
  z[lc++]="	      {";
  z[lc++]="		cq->p = sidx->p;";
  z[lc++]="		if (size < 0)";
  z[lc++]="		  cq->pnum = sidx->len;";
  z[lc++]="		else";
  z[lc++]="		  cq->pnum = size + SAMP_DATABLOCK;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		if (size < 0)";
  z[lc++]="		  cq->pnum = size = sidx->len - skip;";
  z[lc++]="		else";
  z[lc++]="		  cq->pnum = size = size + SAMP_DATABLOCK;";
  z[lc++]="		cq->p = calloc(size, sizeof(float));";
  z[lc++]="		cq->p[size - SAMP_LLMEM] = 1;";
  z[lc++]="		cq->p[size - SAMP_SR] = sidx->p[sidx->len - SAMP_SR];";
  z[lc++]="		cq->p[size - SAMP_LOOPSTART] = ";
  z[lc++]="		  ROUND(sidx->p[sidx->len - SAMP_LOOPSTART]) - skip;";
  z[lc++]="		cq->p[size - SAMP_LOOPEND] =  ";
  z[lc++]="		  ROUND(sidx->p[sidx->len - SAMP_LOOPEND]) - skip;";
  z[lc++]="		cq->p[size - SAMP_BASEFREQ] =  ";
  z[lc++]="		  sidx->p[sidx->len - SAMP_BASEFREQ];";
  z[lc++]="		j = skip;";
  z[lc++]="		i = 0;";
  z[lc++]="		while ((i < (size - SAMP_DATABLOCK)) && (j < (sidx->len - SAMP_DATABLOCK)))";
  z[lc++]="		  cq->p[i++] = sidx->p[j++];";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_ENDTIME:";
  z[lc++]="    csysi_endflag = 1;    /* obey SASL endtime command */";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_TEMPO:      ";
  z[lc++]="    u.l = csysi_readbit(32);";
  z[lc++]="    cq->fval = u.f;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    csys_terminate(\"Unknown score line type in .mp4 file\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*             reads the sample class                             */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_sampleread(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int sym, i, len;";
  z[lc++]="  csysi_sampleunit * sidx, * newsamp;";
  z[lc++]="  union { unsigned long l; float f ; } u;";
  z[lc++]="  union { unsigned short us; signed short ss ; } s;";
  z[lc++]="";
  z[lc++]="  sidx = (csysi_sampleunit *) malloc(sizeof(csysi_sampleunit));";
  z[lc++]="  sidx->token = sym = csysi_readbit(16);";
  z[lc++]="  sidx->len = len = csysi_readbit(24) + SAMP_DATABLOCK;";
  z[lc++]="  sidx->p = (float *) malloc(len*sizeof(float));";
  z[lc++]="";
  z[lc++]="  sidx->p[len - SAMP_LLMEM] = 0;";
  z[lc++]="  if (csysi_readbit(1))  /* sampling rate */";
  z[lc++]="    sidx->p[len - SAMP_SR] = csysi_readbit(17);";
  z[lc++]="  else";
  z[lc++]="    sidx->p[len - SAMP_SR] = ARATE;";
  z[lc++]="";
  z[lc++]="  if (csysi_readbit(1))  /* loop points */";
  z[lc++]="    {";
  z[lc++]="      sidx->p[len - SAMP_LOOPSTART] = csysi_readbit(24);";
  z[lc++]="      sidx->p[len - SAMP_LOOPEND] = csysi_readbit(24);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sidx->p[len - SAMP_LOOPSTART] = -1;";
  z[lc++]="      sidx->p[len - SAMP_LOOPEND] = -1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_readbit(1))  /* base frequency */";
  z[lc++]="    {";
  z[lc++]="      u.l = csysi_readbit(32);";
  z[lc++]="      sidx->p[len - SAMP_BASEFREQ] = u.f;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    sidx->p[len - SAMP_BASEFREQ] = -1;";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  if (csysi_readbit(1))  /* float sample */";
  z[lc++]="    {";
  z[lc++]="      while (i < (len - SAMP_DATABLOCK))";
  z[lc++]="	{";
  z[lc++]="	  u.l = csysi_readbit(32);";
  z[lc++]="	  sidx->p[i++] = u.f;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {      ";
  z[lc++]="      while (i < (len - SAMP_DATABLOCK))";
  z[lc++]="	{";
  z[lc++]="	  s.us = csysi_readbit(16);";
  z[lc++]="	  sidx->p[i++] = s.ss*(1.0F/32767.0F);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  newsamp = sidx;";
  z[lc++]="";
  z[lc++]="  if (!csysi_samples)";
  z[lc++]="    {";
  z[lc++]="      csysi_samples = newsamp;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((sidx = csysi_samples)->token > sym)";
  z[lc++]="    {";
  z[lc++]="      newsamp->next = csysi_samples;";
  z[lc++]="      csysi_samples = newsamp;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (sidx && (sidx->token <= sym))";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      if ((sidx->next == NULL) || ";
  z[lc++]="	  (sidx->next->token > sym))";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      if (sidx->token == sym)";
  z[lc++]="	{";
  z[lc++]="	  while (sidx->next && (sidx->next->token == sym))";
  z[lc++]="	    sidx = sidx->next;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      sidx = sidx->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  newsamp->next = sidx->next;";
  z[lc++]="  sidx->next = newsamp;";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*             checks if buffer is empty                          */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_emptycheck(int len, csysi_mevent * mq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (len)";
  z[lc++]="    return 0;";
  z[lc++]="";
  z[lc++]="  mq->cmd = CSYS_MIDI_NOOP;";
  z[lc++]="  return 1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*             puts midi data in csysi_midiqueue[idx]             */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_midilinefill(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int len, system, bpm;";
  z[lc++]="  unsigned char nextbyte;";
  z[lc++]="  csysi_mevent * mq;";
  z[lc++]="";
  z[lc++]="  mq = &(csysi_midiqueue[csysi_headmidi]);";
  z[lc++]="  mq->atime = csysi_bitaccesstime;";
  z[lc++]="";
  z[lc++]="  if (csysi_tailmidi == -1)";
  z[lc++]="    csysi_tailmidi = csysi_headmidi;";
  z[lc++]="  csysi_headmidi = (csysi_headmidi+1)&(CSYSI_MAXMIDI-1);";
  z[lc++]="";
  z[lc++]="  len = csysi_readbit(24);";
  z[lc++]="";
  z[lc++]="  csysi_nummidi++;";
  z[lc++]="  if (csysi_emptycheck(len, mq))";
  z[lc++]="    return;";
  z[lc++]="  nextbyte = (unsigned char)csysi_readbit(8); ";
  z[lc++]="  len--;";
  z[lc++]="";
  z[lc++]="  if (!(nextbyte & 0x80))";
  z[lc++]="    {";
  z[lc++]="      mq->cmd = csysi_runstat;";
  z[lc++]="      mq->ndata = nextbyte;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      mq->cmd = nextbyte;";
  z[lc++]="      if ((nextbyte & CSYSI_MIDIMASKCOM) != CSYSI_MIDISYSTEM)";
  z[lc++]="	{      ";
  z[lc++]="	  csysi_runstat = nextbyte;";
  z[lc++]="	  if (csysi_emptycheck(len, mq))";
  z[lc++]="	    return;";
  z[lc++]="	  mq->ndata = (unsigned char)csysi_readbit(8);";
  z[lc++]="	  len--;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  mq->extchan = CSYSI_MIDIMASKCHAN & mq->cmd;";
  z[lc++]="";
  z[lc++]="  switch ((mq->cmd)&CSYSI_MIDIMASKCOM) {";
  z[lc++]="  case CSYS_MIDI_NOTEOFF:  /* two byte commands */";
  z[lc++]="  case CSYS_MIDI_NOTEON:";
  z[lc++]="  case CSYS_MIDI_PTOUCH:";
  z[lc++]="  case CSYS_MIDI_WHEEL:";
  z[lc++]="  case CSYS_MIDI_CC:";
  z[lc++]="    if (csysi_emptycheck(len, mq))";
  z[lc++]="      return;";
  z[lc++]="    mq->vdata = (unsigned char)csysi_readbit(8);";
  z[lc++]="    len--;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CTOUCH:   /* one byte commands */";
  z[lc++]="  case CSYS_MIDI_PROGRAM:";
  z[lc++]="    break;";
  z[lc++]="  case CSYSI_MIDISYSTEM:   /* tempo command */";
  z[lc++]="    if (mq->cmd != 0xFF)";
  z[lc++]="      break;";
  z[lc++]="    if (csysi_emptycheck(len, mq))";
  z[lc++]="      return;";
  z[lc++]="    if (((unsigned char)csysi_readbit(8)) != CSYSI_METATEMPO )";
  z[lc++]="      {";
  z[lc++]="	len--;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    len--;";
  z[lc++]="";
  z[lc++]="    if (len >= 4)";
  z[lc++]="      {";
  z[lc++]="	csysi_readflush(8); ";
  z[lc++]="	bpm = csysi_readbit(24); ";
  z[lc++]="	len -= 4;";
  z[lc++]="	if (bpm)";
  z[lc++]="	  {";
  z[lc++]="	    mq->fval = 60e6F/bpm;";
  z[lc++]="	    mq->cmd = CSYS_MIDI_NEWTEMPO;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  mq->cmd = CSYS_MIDI_NOOP;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      mq->cmd = CSYS_MIDI_NOOP;";
  z[lc++]="";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  csysi_readflush(len*8);  /* one command per event, spec says */";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*             finds next streaming score event                   */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_readnewevent(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int type, ret;";
  z[lc++]="";
  z[lc++]="  if (ret = csysi_readbit(1))  /* more data here */";
  z[lc++]="    {";
  z[lc++]="      type = csysi_readbit(2);";
  z[lc++]="      switch (type)";
  z[lc++]="	{";
  z[lc++]="	case CSYSI_EVSCORE:";
  z[lc++]="	  csysi_scorelinefill();";
  z[lc++]="	  break;";
  z[lc++]="	case CSYSI_EVMIDI:";
  z[lc++]="	  csysi_midilinefill();";
  z[lc++]="	  break;";
  z[lc++]="	case CSYSI_EVSAMPLE:";
  z[lc++]="	  csysi_sampleread();";
  z[lc++]="	  break;";
  z[lc++]="	default:";
  z[lc++]="	  csys_terminate(\"Unknown event type in .mp4 file\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*        adds an endtime command to a queue                      */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_setendtime(float fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret = 0;";
  z[lc++]="  ";
  z[lc++]="  if ((csysi_headmidi&(CSYSI_MAXMIDI-1)) != csysi_tailmidi)";
  z[lc++]="    {";
  z[lc++]="      csysi_midiqueue[csysi_headmidi].atime = csysi_bitaccesstime;";
  z[lc++]="      csysi_midiqueue[csysi_headmidi].cmd = CSYS_MIDI_ENDTIME;";
  z[lc++]="      csysi_midiqueue[csysi_headmidi].fval = fval;";
  z[lc++]="      if (csysi_tailmidi == -1)";
  z[lc++]="	csysi_tailmidi = csysi_headmidi;";
  z[lc++]="      csysi_headmidi = (csysi_headmidi+1)&(CSYSI_MAXMIDI-1);";
  z[lc++]="      csysi_nummidi++;";
  z[lc++]="      ret = 1;";
  z[lc++]="    }";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           fill sasl and midi queues with more data           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_fillqueues(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* while data is left in file, and room left in queues, */";
  z[lc++]="  /* fill queues with more data                           */";
  z[lc++]="";
  z[lc++]="  while (csysi_moreaccessunits &&";
  z[lc++]="      ((csysi_headsco&(CSYSI_MAXSASL-1)) != csysi_tailsco) && ";
  z[lc++]="      ((csysi_headabs&(CSYSI_MAXSASL-1)) != csysi_tailabs) && ";
  z[lc++]="      ((csysi_headmidi&(CSYSI_MAXMIDI-1)) != csysi_tailmidi))";
  z[lc++]="    {";
  z[lc++]="      if (csysi_endofevent)";
  z[lc++]="	{";
  z[lc++]="	  csysi_moreaccessunits = csysi_readaccesstime();";
  z[lc++]="	}";
  z[lc++]="      if (csysi_moreaccessunits)";
  z[lc++]="	{";
  z[lc++]="	  csysi_endofevent = !csysi_readnewevent();";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!(CSYS_GIVENENDTIME) && !csysi_moreaccessunits &&";
  z[lc++]="      !(csysi_endflag))";
  z[lc++]="    {";
  z[lc++]="      csysi_endflag = csysi_setendtime(csysi_compendtime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           finds, opens, and seeks streaming file             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_openfile(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  char * name;";
  z[lc++]="";
  z[lc++]="  /* first search ./sa file command line for .mp4 file */";
  z[lc++]="";
  z[lc++]="  for (i=1;i<csys_argc; i++)";
  z[lc++]="    if (!strcmp(csys_argv[i],\"-csys_fstr_file\"))";
  z[lc++]="      {";
  z[lc++]="	i++;";
  z[lc++]="	if (i == csys_argc)";
  z[lc++]="	  csys_terminate(\".mp4 file not specified\");";
  z[lc++]="	if (!(csysi_bitfile = fopen(csys_argv[i],\"rb\")))";
  z[lc++]="	  {";
  z[lc++]="	    name = (char *) calloc(strlen(csys_argv[i])+5, sizeof(char));";
  z[lc++]="	    sprintf(name,\"%s.mp4\",csys_argv[i]);";
  z[lc++]="	    if (!(csysi_bitfile = fopen(name,\"rb\")))";
  z[lc++]="	      csys_terminate(\".mp4 file not found\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  /* then look though sfront command line for -bitc */";
  z[lc++]="";
  z[lc++]="  if (!csysi_bitfile)";
  z[lc++]="    {";
  z[lc++]="      for (i=1;i<csys_sfront_argc; i++)";
  z[lc++]="	if (!strcmp(csys_sfront_argv[i],\"-bitc\"))";
  z[lc++]="	  {";
  z[lc++]="	    i++;";
  z[lc++]="	    if (i == csys_sfront_argc)";
  z[lc++]="	      csys_terminate(\"-bitc file.mp4 unspecified\");";
  z[lc++]="	    if (!(csysi_bitfile = fopen(csys_sfront_argv[i],\"rb\")))";
  z[lc++]="	      {";
  z[lc++]="		name = (char *) calloc(strlen(csys_sfront_argv[i])+5,";
  z[lc++]="				       sizeof(char));";
  z[lc++]="		sprintf(name,\"%s.mp4\",csys_sfront_argv[i]);";
  z[lc++]="		if (!(csysi_bitfile = fopen(name,\"rb\")))";
  z[lc++]="		  csys_terminate(\"-bitc file.mp4 not found\");";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!csysi_bitfile)";
  z[lc++]="    csys_terminate(";
  z[lc++]="	\"Syntax: ./sa -csys_fstr_file file.mp4, or sfront -bitc file.mp4\");";
  z[lc++]="";
  z[lc++]="  /* if an explicit SASL endtime not give, invalidate computed endtime */";
  z[lc++]="";
  z[lc++]="  if (!(CSYS_GIVENENDTIME))";
  z[lc++]="    {";
  z[lc++]="      csysi_compendtime = endtime;";
  z[lc++]="      if (!csysi_setendtime(CSYSI_MAXENDTIME))";
  z[lc++]="	csys_terminate(\"problem setting init endtime\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* skip to access_units, fill up queues */";
  z[lc++]="";
  z[lc++]="  csysi_flushconfig();";
  z[lc++]="  csysi_fillqueues();";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  csysi_openfile();";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int i, found;";
  z[lc++]="";
  z[lc++]="  csysi_absready = 0; ";
  z[lc++]="  csysi_scoready = 0; ";
  z[lc++]="  csysi_midiready = 0; ";
  z[lc++]="";
  z[lc++]="  csysi_fillqueues();";
  z[lc++]="";
  z[lc++]="  /* see if an event is ready */";
  z[lc++]="";
  z[lc++]="  i = csysi_tailsco;";
  z[lc++]="  found = ((i = csysi_tailsco) < 0);";
  z[lc++]="  while (csysi_numscotime && !found)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_scoqueue[i].stime <= scorebeats)";
  z[lc++]="	csysi_scoready++;";
  z[lc++]="      else";
  z[lc++]="	found = 1;";
  z[lc++]="      i = (i+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="      if (i == csysi_headsco)";
  z[lc++]="	found = 1;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  i = csysi_tailabs;";
  z[lc++]="  found = ((i = csysi_tailabs) < 0);";
  z[lc++]="  while (csysi_numabstime && !found)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_absqueue[i].atime < absolutetime)";
  z[lc++]="	csysi_absready++;";
  z[lc++]="      else";
  z[lc++]="	found = 1;";
  z[lc++]="      i = (i+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="      if (i == csysi_headabs)";
  z[lc++]="	found = 1;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  i = csysi_tailmidi;";
  z[lc++]="  found = ((i = csysi_tailmidi) < 0);";
  z[lc++]="  while (csysi_nummidi && !found)";
  z[lc++]="    {";
  z[lc++]="      if (csysi_midiqueue[i].atime < absolutetime)";
  z[lc++]="	csysi_midiready++;";
  z[lc++]="      else";
  z[lc++]="	found = 1;";
  z[lc++]="      i = (i+1)&(CSYSI_MAXMIDI-1);";
  z[lc++]="      if (i == csysi_headmidi)";
  z[lc++]="	found = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_midiready)";
  z[lc++]="    {";
  z[lc++]="      if ((csysi_absready || csysi_scoready))";
  z[lc++]="	return CSYS_EVENTS;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_MIDIEVENTS;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if ((csysi_absready || csysi_scoready))";
  z[lc++]="	return CSYS_SASLEVENTS;";
  z[lc++]="      else";
  z[lc++]="	return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a SASL event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_saslevent(unsigned char * cmd, unsigned char * priority,";
  z[lc++]="		   unsigned short * id, unsigned short * label,";
  z[lc++]="		   float * fval, unsigned int * pnum, float ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, done, j, scofound;";
  z[lc++]="  csysi_sevent * cq;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  done = 1;";
  z[lc++]="  if (csysi_scoready)";
  z[lc++]="    {";
  z[lc++]="      cq = &(csysi_scoqueue[csysi_tailsco]);";
  z[lc++]="      scofound = 1;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (csysi_absready)";
  z[lc++]="	{";
  z[lc++]="	  cq = &(csysi_absqueue[csysi_tailabs]);";
  z[lc++]="	  scofound = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	csys_terminate(\"saslevent() queue error\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *priority = cq->priority;";
  z[lc++]="  *id = cq->id;";
  z[lc++]="  *label = cq->label;";
  z[lc++]="  *fval = cq->fval;";
  z[lc++]="  *pnum = cq->pnum;";
  z[lc++]="  *p = cq->p;";
  z[lc++]="";
  z[lc++]="  switch (*cmd = cq->cmd) {";
  z[lc++]="  case CSYS_SASL_ENDTIME :  ";
  z[lc++]="    *fval = scorebeats;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_NOOP :";
  z[lc++]="  case CSYS_SASL_TEMPO : ";
  z[lc++]="  case CSYS_SASL_TABLE :";
  z[lc++]="  case CSYS_SASL_INSTR :";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_SASL_CONTROL :";
  z[lc++]="    if ((*id) == CSYS_SASL_NOINSTR)";
  z[lc++]="      break;";
  z[lc++]="    if (csysi_targetvar == -1)";
  z[lc++]="      {";
  z[lc++]="	csysi_targetvar=0;";
  z[lc++]="	while (csysi_targetvar < CSYS_TARGETNUM)";
  z[lc++]="	  {";
  z[lc++]="	    if (csys_target[csysi_targetvar].token == (*pnum))";
  z[lc++]="	      break;";
  z[lc++]="	    csysi_targetvar++;";
  z[lc++]="	  }";
  z[lc++]="	if (csysi_targetvar == CSYS_TARGETNUM) ";
  z[lc++]="	  {";
  z[lc++]="	    /* specified variable not imported -- abort command */";
  z[lc++]="	    *cmd = CSYS_SASL_NOOP;";
  z[lc++]="	    csysi_targetvar = -1;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	csysi_targetcount = 0;";
  z[lc++]="      }";
  z[lc++]="    *id = csys_target[csysi_targetvar].instrindex[csysi_targetcount];";
  z[lc++]="    *pnum = csys_target[csysi_targetvar].varindex[csysi_targetcount];";
  z[lc++]="    if ((++csysi_targetcount) < csys_target[csysi_targetvar].numinstr)";
  z[lc++]="      done = 0;";
  z[lc++]="    else";
  z[lc++]="      csysi_targetvar = -1;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (done)";
  z[lc++]="    {";
  z[lc++]="      if (scofound)";
  z[lc++]="	{";
  z[lc++]="	  csysi_scoready--;";
  z[lc++]="	  csysi_numscotime--;";
  z[lc++]="	  csysi_tailsco = (csysi_tailsco+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="	  if (csysi_tailsco == csysi_headsco)  /* empty */";
  z[lc++]="	    {";
  z[lc++]="	      csysi_headsco = 0;";
  z[lc++]="	      csysi_tailsco = -1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  csysi_absready--;";
  z[lc++]="	  csysi_numabstime--;";
  z[lc++]="	  csysi_tailabs = (csysi_tailabs+1)&(CSYSI_MAXSASL-1);";
  z[lc++]="	  if (csysi_tailabs == csysi_headabs)  /* empty */";
  z[lc++]="	    {";
  z[lc++]="	      csysi_headabs = 0;";
  z[lc++]="	      csysi_tailabs = -1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_scoready || csysi_absready)";
  z[lc++]="    return CSYS_SASLEVENTS;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="	";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  int i = csysi_tailmidi;";
  z[lc++]="";
  z[lc++]="  *cmd = csysi_midiqueue[i].cmd;";
  z[lc++]="  *ndata = csysi_midiqueue[i].ndata;";
  z[lc++]="  *vdata = csysi_midiqueue[i].vdata;";
  z[lc++]="  *extchan = csysi_midiqueue[i].extchan;";
  z[lc++]="  *fval = csysi_midiqueue[i].fval;";
  z[lc++]="";
  z[lc++]="  if (*cmd == CSYS_MIDI_ENDTIME)";
  z[lc++]="    *fval = (*fval > scorebeats + 5.0F) ? *fval : scorebeats + 5.0F;";
  z[lc++]="";
  z[lc++]="  csysi_midiready--;";
  z[lc++]="  csysi_nummidi--;";
  z[lc++]="";
  z[lc++]="  csysi_tailmidi = (csysi_tailmidi+1)&(CSYSI_MAXMIDI-1);";
  z[lc++]="  if (csysi_tailmidi == csysi_headmidi)  /* empty */";
  z[lc++]="    {";
  z[lc++]="      csysi_headmidi = 0;";
  z[lc++]="      csysi_tailmidi = -1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_midiready)";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef SAMP_SR ";
  z[lc++]="#undef SAMP_LOOPSTART ";
  z[lc++]="#undef SAMP_LOOPEND ";
  z[lc++]="#undef SAMP_BASEFREQ ";
  z[lc++]="#undef SAMP_DATABLOCK ";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makecoremidi(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: coremidi control driver for sfront";
  z[lc++]="#    Copyright (C) 2002 Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                coremidi control driver for sfront            */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#include <sys/types.h>";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/uio.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="#if !(defined(ASYS_OUTDRIVER_COREAUDIO)||defined(ASYS_INDRIVER_COREAUDIO))";
  z[lc++]="#include <CoreFoundation/CFString.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <CoreMIDI/CoreMIDI.h>";
  z[lc++]="";
  z[lc++]="/***************************/";
  z[lc++]="/* graceful_exit constants */";
  z[lc++]="/***************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_GE_RUNNING  0";
  z[lc++]="#define CSYSI_GE_DOEXIT   1";
  z[lc++]="#define CSYSI_GE_EXITED   2";
  z[lc++]="";
  z[lc++]="#define CSYSI_RETRY_MAX   256    /* retry counter for read() EINTR */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* MIDI source constants */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_MAXPORTS 4       /* must match ../../control.c  */";
  z[lc++]="";
  z[lc++]="/**********************************/";
  z[lc++]="/* buffer constants -- needs work */";
  z[lc++]="/**********************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_BUFFSIZE   1024  /* size of the holding buffer   */";
  z[lc++]="#define CSYSI_SENDSIZE   256   /* maximum size of one packet[] */";
  z[lc++]="#define CSYSI_SYSEXSIZE    128  /* buffer size for F0/F4/F5     */";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* System command constants */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="#define CSYSI_BLOCK_SYSTEM_COMMANDS   0   /* remove 0xF from source */";
  z[lc++]="#define CSYSI_PASS_SYSTEM_COMMANDS    1   /* retain 0xF             */";
  z[lc++]="";
  z[lc++]="#define CSYSI_SYSTEM_GATE CSYSI_PASS_SYSTEM_COMMANDS  /* sets mode */";
  z[lc++]="";
  z[lc++]="#define CSYSI_COMMAND_ONGOING         0   /* arbitrary-length command ongoing   */";
  z[lc++]="#define CSYSI_COMMAND_COMPLETED       1   /* arbitrary-length command completed */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/**********************/";
  z[lc++]="/* preamble constants */";
  z[lc++]="/**********************/";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="";
  z[lc++]=" 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 ";
  z[lc++]="-------------------------------------------------------------------";
  z[lc++]="|    0xF7       |T|R|R|R|  EXT  |  tstamp (T = 1)  ... | MIDI ... |";
  z[lc++]="-------------------------------------------------------------------";
  z[lc++]="";
  z[lc++]="  T is set to 1 if a non-NOW timestamp follows the header octet.";
  z[lc++]="  R's are reserved.";
  z[lc++]="  EXT codes which of 16 16-channel MIDI sources.";
  z[lc++]="";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define CSYSI_PREAMBLE_SIZE    6  /* read_proc preamble w/ timestamp */";
  z[lc++]="#define CSYSI_PREAMBLE_NOWSIZE 2  /* read_proc preamble w/o timestamp */";
  z[lc++]="";
  z[lc++]="#define CSYSI_PREAMBLE_POS_MARKER  0  /* first octet is the marker: 0xFF     */";
  z[lc++]="#define CSYSI_PREAMBLE_POS_CONTROL 1  /* second octet holds control bits     */";
  z[lc++]="#define CSYSI_PREAMBLE_POS_TSTAMP  2  /* last 4 (optional) octets for tstamp */";
  z[lc++]="";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_MARKER  0xF7u  /* marker value: for easy parsing */";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_T       0x80u  /* timestamp follows this octet   */";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_R2      0x40u  /* reserved bits                  */";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_R1      0x20u  ";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_R0      0x10u  ";
  z[lc++]="#define CSYSI_PREAMBLE_FLAGS_EXT     0x0Fu  /* the EXT nibble                 */";
  z[lc++]="";
  z[lc++]="/*****************************/";
  z[lc++]="/* simulated F4/F5 constants */";
  z[lc++]="/*****************************/";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="  SysEx format to simulate undefined commands:";
  z[lc++]="";
  z[lc++]="  | F7 | 7D | code | octone (if bit set) | octtwo (if bit set) | F0 |";
  z[lc++]="";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define CSYSI_UNDEFINED_ID          0x7Du  /* Manufacturers ID */";
  z[lc++]="";
  z[lc++]="#define CSYSI_UNDEFINED_F4          0x40u   /* set is F4, clear is F5 */";
  z[lc++]="#define CSYSI_UNDEFINED_OCTONE      0x20u   /* presence of 1st octet  */";
  z[lc++]="#define CSYSI_UNDEFINED_OCTTWO      0x10u   /* presence of 2nd octet  */   ";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* input port variables */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="MIDIClientRef csysi_inclient;  /* the input client  */";
  z[lc++]="MIDIPortRef   csysi_inport;    /* it's port         */";
  z[lc++]="";
  z[lc++]="typedef struct csysi_portinfo {";
  z[lc++]="  int ext;                 /* EXT field for preamble, also array index */";
  z[lc++]="  int valid;               /* 0 if unused, 1 if online, -1 if offline  */";
  z[lc++]="  MIDIEndpointRef src;     /* current src  (may be invalid if offline) */";
  z[lc++]="  int id;                  /* unique ID of src (currently unused)      */";
  z[lc++]="";
  z[lc++]="#if (CSYSI_SYSTEM_GATE == CSYSI_PASS_SYSTEM_COMMANDS)";
  z[lc++]="  unsigned char sysbuff[CSYSI_SYSEXSIZE];       /* System command buffer */";
  z[lc++]="  int sysex_size;           /* current size of sysbuff[]                 */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="} csysi_portinfo;";
  z[lc++]="";
  z[lc++]="csysi_portinfo csysi_ports[CSYSI_MAXPORTS];";
  z[lc++]="";
  z[lc++]="/**********************************/";
  z[lc++]="/* read_proc pipe data structures */";
  z[lc++]="/**********************************/";
  z[lc++]="";
  z[lc++]="int csysi_readproc_pipepair[2];";
  z[lc++]="int csysi_graceful_exit;";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* command buffer state */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="unsigned char csysi_buffer[CSYSI_BUFFSIZE];";
  z[lc++]="int csysi_len, csysi_cnt;";
  z[lc++]="unsigned short csysi_currext;";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking wrappers                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      return CSYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  CSYSI_ERROR_TERMINATE(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));\\";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- \" x );}  while (0)";
  z[lc++]="";
  z[lc++]="/*******************/";
  z[lc++]="/* forward externs */";
  z[lc++]="/*******************/";
  z[lc++]="";
  z[lc++]="extern void csysi_read_proc(const MIDIPacketList * pktlist,";
  z[lc++]="			    void * readProcRefCon, ";
  z[lc++]="			    void * srcConnRefCon);";
  z[lc++]="";
  z[lc++]="extern void csysi_notify_proc(const MIDINotification * message,";
  z[lc++]="			      void * refcon);";
  z[lc++]="";
  z[lc++]="extern int csysi_bugrecovery(MIDIPacket * p, unsigned char * mdata,";
  z[lc++]="			     int * idx, int len);";
  z[lc++]="";
  z[lc++]="extern int csysi_packet_arblength(MIDIPacket * p, unsigned char * mdata,";
  z[lc++]="				  int * idx, int * len, unsigned char ext);";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: called by sfront engine            */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             initialization routine for control               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_setup(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int connected, numsrc, flags, i, numvsrc;";
  z[lc++]="  MIDIEndpointRef src;";
  z[lc++]="  MIDIEntityRef ent;";
  z[lc++]="  char name[256];";
  z[lc++]="  CFStringRef cf_name;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* create input client and port */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  if (MIDIClientCreate(CFSTR(\"sfront_inclient\"), NULL, ";
  z[lc++]="		       (void *) NULL, &csysi_inclient))";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Could not create CoreMIDI client\");";
  z[lc++]="";
  z[lc++]="  if (MIDIInputPortCreate(csysi_inclient, CFSTR(\"sfront_inport\"),";
  z[lc++]="			  csysi_read_proc, (void *) NULL, ";
  z[lc++]="			  &csysi_inport))";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Could not create CoreMIDI inport\");";
  z[lc++]="";
  z[lc++]="  /********************************************************/";
  z[lc++]="  /* open pipes, since data may start flowing immediately */";
  z[lc++]="  /********************************************************/";
  z[lc++]="";
  z[lc++]="  if (socketpair(AF_UNIX, SOCK_DGRAM, 0, csysi_readproc_pipepair))";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Cannot open readproc pipe\");";
  z[lc++]="";
  z[lc++]="  if ((flags = fcntl(csysi_readproc_pipepair[0], F_GETFL, 0)) == -1)";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Unknown flags for read end of readproc pipe\");";
  z[lc++]="";
  z[lc++]="  if (fcntl(csysi_readproc_pipepair[0], F_SETFL, flags | O_NONBLOCK) == -1) ";
  z[lc++]="    CSYSI_ERROR_RETURN(\"Cannot O_NONBLOCK read end of readproc pipe\");";
  z[lc++]="";
  z[lc++]="  /********************************************************/";
  z[lc++]="  /* for now, connect only one source, exit if no sources */";
  z[lc++]="  /********************************************************/";
  z[lc++]="  ";
  z[lc++]="  for (i = 0; i < CSYSI_MAXPORTS; i++)";
  z[lc++]="    csysi_ports[i].ext = i;";
  z[lc++]="";
  z[lc++]="  numvsrc = connected = 0;";
  z[lc++]="  numsrc = (int) MIDIGetNumberOfSources();";
  z[lc++]="  ";
  z[lc++]="  for (i = 0; i < numsrc; i++)";
  z[lc++]="    if (src = MIDIGetSource((ItemCount) i))";
  z[lc++]="      {";
  z[lc++]="	if (MIDIEndpointGetEntity(src, &ent) || (ent == NULL))";
  z[lc++]="	  {";
  z[lc++]="	    numvsrc++;";
  z[lc++]="	    continue;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	if (MIDIPortConnectSource(csysi_inport, src,";
  z[lc++]="				  &(csysi_ports[connected].ext)))";
  z[lc++]="	  continue;";
  z[lc++]="";
  z[lc++]="	csysi_ports[connected].valid = 1;";
  z[lc++]="	csysi_ports[connected].src = src;";
  z[lc++]="	connected++;";
  z[lc++]="";
  z[lc++]="	if ((connected == CSYSI_MAXPORTS) && (i + 1 != numsrc))";
  z[lc++]="	  {";
  z[lc++]="	    fprintf(stderr, ";
  z[lc++]="		    \"\\nWarning: -cin coremidi configured for %i ports max,\\n\", ";
  z[lc++]="		    CSYSI_MAXPORTS);";
  z[lc++]="	    fprintf(stderr, ";
  z[lc++]="		    \"         skipping the last %i MIDI port(s) in your setup.\\n\", ";
  z[lc++]="		    numsrc - i - 1);";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\nCoreMIDI setup info:\\n\");";
  z[lc++]="";
  z[lc++]="  if (!connected)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"   No CoreMIDI sources to connect with, exiting ...\\n\");";
  z[lc++]="      if (numvsrc)";
  z[lc++]="	fprintf(stderr, \"   (Sfront doesn't support virtual sources yet.)\\n\");";
  z[lc++]="      return CSYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* print out source identities */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < connected; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"   SAOL MIDI channels %i-%i connect to \",";
  z[lc++]="	      16*csysi_ports[i].ext, 16*(csysi_ports[i].ext + 1) - 1);";
  z[lc++]="";
  z[lc++]="      src = csysi_ports[i].src;";
  z[lc++]="      ";
  z[lc++]="      if (MIDIObjectGetStringProperty(src, kMIDIPropertyName, &cf_name))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"(unnamed source).\\n\");";
  z[lc++]="	  continue;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!CFStringGetCString(cf_name, name, 256, CFStringGetSystemEncoding()))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"(unnamed source).\\n\");";
  z[lc++]="	  CFRelease(cf_name);";
  z[lc++]="	  continue;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      CFRelease(cf_name);";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", name);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (numvsrc)";
  z[lc++]="    fprintf(stderr, ";
  z[lc++]="	    \"   (Virtual sources also found; sfront doesn't support them yet.)\\n\");";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\nMIDI Preset Numbers \");";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!(strcmp(csys_sfront_argv[i],\"-bitc\") && ";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-bit\") &&";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-orc\")))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \"for %s \", csys_sfront_argv[i]);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"(use MIDI controller to select):\\n\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_PRESETNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"%3i. %s\", ";
  z[lc++]="	      csys_presets[i].preset,";
  z[lc++]="	      csys_instr[csys_presets[i].index].name);";
  z[lc++]="      if ((i&1))";
  z[lc++]="	fprintf(stderr, \"\\n\");";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"\\t\\t\");";
  z[lc++]="	  if (i == (CSYS_PRESETNUM-1))";
  z[lc++]="	    fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return CSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             polling routine for new data                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_newdata(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  int len, retry;";
  z[lc++]="";
  z[lc++]="  if (((len = read(csysi_readproc_pipepair[0], csysi_buffer, ";
  z[lc++]="		   CSYSI_SENDSIZE)) < 0) && (errno == EAGAIN))";
  z[lc++]="    return CSYS_NONE;  /* fast path */";
  z[lc++]="";
  z[lc++]="  if (csysi_graceful_exit == CSYSI_GE_EXITED)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="";
  z[lc++]="  csysi_len = 0;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      if (len > 0)";
  z[lc++]="	{";
  z[lc++]="	  if ((csysi_len += len) > (CSYSI_BUFFSIZE - CSYSI_SENDSIZE))";
  z[lc++]="	    break;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (len == 0)";
  z[lc++]="	    {";
  z[lc++]="	      fprintf(stderr, \"-cin coremidi: writev() error.\\n\");";
  z[lc++]="	      csysi_graceful_exit = CSYSI_GE_DOEXIT;";
  z[lc++]="	      break;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    if ((errno != EINTR) || (++retry > CSYSI_RETRY_MAX)) ";
  z[lc++]="	      {";
  z[lc++]="		fprintf(stderr, \"-cin coremidi: pipe read() error.\\n\");";
  z[lc++]="		csysi_graceful_exit = CSYSI_GE_DOEXIT;";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      len = read(csysi_readproc_pipepair[0], &(csysi_buffer[csysi_len]),";
  z[lc++]="		 CSYSI_SENDSIZE);";
  z[lc++]="    } ";
  z[lc++]="  while ((len >= 0) || (errno != EAGAIN));";
  z[lc++]="";
  z[lc++]="  csysi_cnt = 0;";
  z[lc++]="  return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 processes a MIDI event                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csys_midievent(unsigned char * cmd,   unsigned char * ndata, ";
  z[lc++]="	           unsigned char * vdata, unsigned short * extchan,";
  z[lc++]="		   float * fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (csysi_graceful_exit == CSYSI_GE_DOEXIT)";
  z[lc++]="    {";
  z[lc++]="      csysi_graceful_exit = CSYSI_GE_EXITED;";
  z[lc++]="      *cmd = CSYS_MIDI_ENDTIME;";
  z[lc++]="      *fval = scorebeats;";
  z[lc++]="      return CSYS_NONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (csysi_buffer[csysi_cnt] == CSYSI_PREAMBLE_FLAGS_MARKER)";
  z[lc++]="    {";
  z[lc++]="      /* later handle semantics of the timestamp bits */";
  z[lc++]="";
  z[lc++]="      csysi_currext = ";
  z[lc++]="	(csysi_buffer[++csysi_cnt] & CSYSI_PREAMBLE_FLAGS_EXT) << 4;";
  z[lc++]="";
  z[lc++]="      /* skip over the rest of the preamble */";
  z[lc++]="";
  z[lc++]="      if ((csysi_buffer[csysi_cnt] & CSYSI_PREAMBLE_FLAGS_T) == 0)";
  z[lc++]="	csysi_cnt++;     ";
  z[lc++]="      else ";
  z[lc++]="	csysi_cnt += 5;";
  z[lc++]="";
  z[lc++]="      if (csysi_cnt == csysi_len)";
  z[lc++]="	{";
  z[lc++]="	  *cmd = CSYS_MIDI_NOOP;  ";
  z[lc++]="	  return CSYS_NONE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* assumes:";
  z[lc++]="   *   1 - integral number of commands";
  z[lc++]="   *   2 - F0, F7, \"specialized\"";
  z[lc++]="   *   3 - F4/F5 has 0, 1, or 2 data bytes";
  z[lc++]="   *   4 - input stream is perfect MIDI + \"specials\"";
  z[lc++]="   */";
  z[lc++]="";
  z[lc++]="  if (csysi_buffer[csysi_cnt] < (unsigned char)(CSYS_MIDI_SYSTEM))";
  z[lc++]="    {";
  z[lc++]="      if ((CSYSI_SYSTEM_GATE == CSYSI_PASS_SYSTEM_COMMANDS) &&";
  z[lc++]="	  (csysi_buffer[csysi_cnt] < (unsigned char) (CSYS_MIDI_NOTEOFF)))";
  z[lc++]="	{";
  z[lc++]="	  *cmd = csysi_buffer[csysi_cnt++];";
  z[lc++]="	  *extchan = csysi_currext;";
  z[lc++]="	  *ndata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	  ";
  z[lc++]="	  if (*cmd != CSYS_MIDI_GMRESET)";
  z[lc++]="	    *vdata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  *cmd = 0xF0u & csysi_buffer[csysi_cnt];";
  z[lc++]="	  *extchan = (0x0Fu & csysi_buffer[csysi_cnt++]) + csysi_currext;";
  z[lc++]="	  *ndata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	  ";
  z[lc++]="	  if ((*cmd != CSYS_MIDI_PROGRAM) && (*cmd != CSYS_MIDI_CTOUCH))";
  z[lc++]="	    *vdata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      *cmd = csysi_buffer[csysi_cnt++];";
  z[lc++]="      *extchan = csysi_currext;";
  z[lc++]="";
  z[lc++]="      if (*cmd < CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	{";
  z[lc++]="	  if ((*cmd == CSYS_MIDI_SYSTEM_QFRAME) || ";
  z[lc++]="	      (*cmd == CSYS_MIDI_SYSTEM_SONG_SELECT) ||";
  z[lc++]="	      (*cmd == CSYS_MIDI_SYSTEM_SONG_PP))";
  z[lc++]="	    *ndata = csysi_buffer[csysi_cnt++];";
  z[lc++]="";
  z[lc++]="	  if (*cmd == CSYS_MIDI_SYSTEM_SONG_PP)";
  z[lc++]="	    *vdata = csysi_buffer[csysi_cnt++];";
  z[lc++]="";
  z[lc++]="	  if ((*cmd == CSYS_MIDI_SYSTEM_UNUSED1) || ";
  z[lc++]="	      (*cmd == CSYS_MIDI_SYSTEM_UNUSED2))";
  z[lc++]="	    {";
  z[lc++]="	      if ((csysi_cnt < csysi_len) && ";
  z[lc++]="		  !(csysi_buffer[csysi_cnt] & 0x80u))";
  z[lc++]="		*ndata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	      else";
  z[lc++]="		*ndata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="";
  z[lc++]="	      if ((csysi_cnt < csysi_len) && ";
  z[lc++]="		  !(csysi_buffer[csysi_cnt] & 0x80u))";
  z[lc++]="		*vdata = csysi_buffer[csysi_cnt++];";
  z[lc++]="	      else";
  z[lc++]="		*vdata = CSYS_MIDI_SYSTEM_SYSEX_END;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (csysi_cnt == csysi_len)";
  z[lc++]="    return CSYS_NONE;";
  z[lc++]="  else";
  z[lc++]="    return CSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  closing routine for control                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csys_shutdown(void)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  close(csysi_readproc_pipepair[0]);";
  z[lc++]="  close(csysi_readproc_pipepair[1]);";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*       callback functions: called by coremidi directly        */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="extern int csysi_packet_shorten(MIDIPacket * p, ";
  z[lc++]="				unsigned char * mdata,";
  z[lc++]="				int * idx, unsigned char ext); ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  callback for MIDI input                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_read_proc(const MIDIPacketList * pktlist,";
  z[lc++]="		     void * readProcRefCon, void * srcConnRefCon)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char preamble[CSYSI_PREAMBLE_NOWSIZE];";
  z[lc++]="  unsigned char mdata[CSYSI_SENDSIZE];";
  z[lc++]="  struct iovec vector[2];";
  z[lc++]="  MIDIPacket * p;";
  z[lc++]="  int num, idx, retry;";
  z[lc++]="  unsigned char ext;";
  z[lc++]="";
  z[lc++]="  /* initialize preamble */";
  z[lc++]="";
  z[lc++]="  preamble[CSYSI_PREAMBLE_POS_MARKER] = CSYSI_PREAMBLE_FLAGS_MARKER;";
  z[lc++]="  preamble[CSYSI_PREAMBLE_POS_CONTROL] = ext = ";
  z[lc++]="    CSYSI_PREAMBLE_FLAGS_EXT & ((unsigned char) *((int *) srcConnRefCon));";
  z[lc++]="";
  z[lc++]="  /* initialize write vector -- update for timestamp support */";
  z[lc++]="";
  z[lc++]="  vector[0].iov_base = (char *) preamble;";
  z[lc++]="  vector[0].iov_len = (size_t) CSYSI_PREAMBLE_NOWSIZE;";
  z[lc++]="  vector[1].iov_base = (char *) mdata;";
  z[lc++]="";
  z[lc++]="  /* loop through packets, send DGRAMs */";
  z[lc++]="";
  z[lc++]="  p = (MIDIPacket *) &(pktlist->packet[0]);";
  z[lc++]="  num = pktlist->numPackets;";
  z[lc++]="";
  z[lc++]="  while (num--)";
  z[lc++]="    {";
  z[lc++]="      retry = idx = 0;";
  z[lc++]="";
  z[lc++]="      do {";
  z[lc++]="	if ((vector[1].iov_len = csysi_packet_shorten(p, mdata, &idx, ext)))";
  z[lc++]="	  while (writev(csysi_readproc_pipepair[1], vector, 2) < 0)";
  z[lc++]="	    if ((errno != EINTR) || (++retry >= CSYSI_RETRY_MAX))";
  z[lc++]="	      {";
  z[lc++]="		close(csysi_readproc_pipepair[0]);";
  z[lc++]="		close(csysi_readproc_pipepair[1]);";
  z[lc++]="		return;";
  z[lc++]="	      }";
  z[lc++]="      } while (idx < p->length);";
  z[lc++]="";
  z[lc++]="      p = MIDIPacketNext(p);";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  callback for MIDI input                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void csysi_notify_proc(const MIDINotification * message,";
  z[lc++]="		       void * refcon)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* not currently registered with MIDIClientCreate() */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   mid-level functions: called by top-level driver functions  */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               copy SA-safe commands into mdata               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_packet_shorten(MIDIPacket * p, unsigned char * mdata,";
  z[lc++]="			 int * idx, unsigned char ext)";
  z[lc++]="{";
  z[lc++]="  int len = 0;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    if (CSYSI_SYSTEM_GATE == CSYSI_PASS_SYSTEM_COMMANDS)";
  z[lc++]="      if (csysi_ports[ext].sysex_size && (p->data[*idx] & 0xF0u))";
  z[lc++]="	if (csysi_packet_arblength(p, mdata, idx, &len, ext) || (*idx == p->length))";
  z[lc++]="	  return len;";
  z[lc++]="";
  z[lc++]="    switch (p->data[*idx] & 0xF0u) {";
  z[lc++]="    case CSYS_MIDI_NOTEOFF:";
  z[lc++]="    case CSYS_MIDI_NOTEON:";
  z[lc++]="    case CSYS_MIDI_PTOUCH:";
  z[lc++]="    case CSYS_MIDI_WHEEL:";
  z[lc++]="    case CSYS_MIDI_CC:";
  z[lc++]="      if ((p->length >= (*idx + 3)) && (p->data[*idx + 1] < 128)";
  z[lc++]="	  && (p->data[*idx + 2] < 128))";
  z[lc++]="	{";
  z[lc++]="	  memcpy(&(mdata[len]), &(p->data[*idx]), 3);";
  z[lc++]="	  if (p->length == (*idx += 3))";
  z[lc++]="	    return len + 3;";
  z[lc++]="	  if ((len += 3) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="	    return len;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	return csysi_bugrecovery(p, mdata, idx, len);";
  z[lc++]="      continue;";
  z[lc++]="    case CSYS_MIDI_PROGRAM:";
  z[lc++]="    case CSYS_MIDI_CTOUCH:";
  z[lc++]="      if ((p->length >= (*idx + 2)) && (p->data[*idx + 1] < 128))";
  z[lc++]="	{";
  z[lc++]="	  memcpy(&(mdata[len]), &(p->data[*idx]), 2);";
  z[lc++]="	  if (p->length == (*idx += 2))";
  z[lc++]="	    return len + 2;";
  z[lc++]="	  if ((len += 2) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="	    return len;     ";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	return csysi_bugrecovery(p, mdata, idx, len);";
  z[lc++]="      continue;";
  z[lc++]="    case CSYS_MIDI_SYSTEM:";
  z[lc++]="      switch (p->data[*idx]) {";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TICK:                                /* 1 octet */ ";
  z[lc++]="      case CSYS_MIDI_SYSTEM_TUNE_REQUEST:                   ";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CLOCK:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_START:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_CONTINUE:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_STOP:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED3:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SENSE:";
  z[lc++]="      case CSYS_MIDI_SYSTEM_RESET:";
  z[lc++]="	if (CSYSI_SYSTEM_GATE == CSYSI_BLOCK_SYSTEM_COMMANDS)";
  z[lc++]="	  {";
  z[lc++]="	    if (p->length == (*idx += 1))";
  z[lc++]="	      return len;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    memcpy(&(mdata[len]), &(p->data[*idx]), 1);";
  z[lc++]="	    if (p->length == (*idx += 1))";
  z[lc++]="	      return len + 1;";
  z[lc++]="	    if ((len += 1) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="	      return len;";
  z[lc++]="	  }";
  z[lc++]="	continue;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SYSEX_END:                      ";
  z[lc++]="	if (p->length == (*idx += 1))";
  z[lc++]="	  return len;";
  z[lc++]="	continue;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_QFRAME:                              /* 2 octets */ ";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_SELECT:";
  z[lc++]="	if (CSYSI_SYSTEM_GATE == CSYSI_BLOCK_SYSTEM_COMMANDS)";
  z[lc++]="	  {";
  z[lc++]="	    if (p->length == (*idx += 2))";
  z[lc++]="	      return len;	 ";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    if ((p->length >= (*idx + 2)) && (p->data[*idx + 1] < 128))";
  z[lc++]="	      {";
  z[lc++]="		memcpy(&(mdata[len]), &(p->data[*idx]), 2);";
  z[lc++]="		if (p->length == (*idx += 2))";
  z[lc++]="		  return len + 2;";
  z[lc++]="		if ((len += 2) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="		  return len;     ";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      return csysi_bugrecovery(p, mdata, idx, len);";
  z[lc++]="	  }";
  z[lc++]="      continue;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SONG_PP:                             /* 3 octets */ ";
  z[lc++]="	if (CSYSI_SYSTEM_GATE == CSYSI_BLOCK_SYSTEM_COMMANDS)";
  z[lc++]="	  {";
  z[lc++]="	    if (p->length == (*idx += 3))";
  z[lc++]="	      return len;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    if ((p->length >= (*idx + 3)) && (p->data[*idx + 1] < 128)";
  z[lc++]="		&& (p->data[*idx + 2] < 128))";
  z[lc++]="	      {";
  z[lc++]="		memcpy(&(mdata[len]), &(p->data[*idx]), 3);";
  z[lc++]="		if (p->length == (*idx += 3))";
  z[lc++]="		  return len + 3;";
  z[lc++]="		if ((len += 3) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="		  return len;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      return csysi_bugrecovery(p, mdata, idx, len);";
  z[lc++]="	  }";
  z[lc++]="	continue;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED1:           /* undefined Common commands */";
  z[lc++]="      case CSYS_MIDI_SYSTEM_UNUSED2:";
  z[lc++]="	if (CSYSI_SYSTEM_GATE == CSYSI_PASS_SYSTEM_COMMANDS)";
  z[lc++]="	  {";
  z[lc++]="	    /* case 1: zero data octets */";
  z[lc++]="	    ";
  z[lc++]="	    if ((((*idx) + 1) == p->length) || (p->data[(*idx) + 1] & 0x80u))";
  z[lc++]="	      {";
  z[lc++]="		memcpy(&(mdata[len]), &(p->data[*idx]), 1);";
  z[lc++]="		if (p->length == (*idx += 1))";
  z[lc++]="		  return len + 1;";
  z[lc++]="		if ((len += 1) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="		  return len;";
  z[lc++]="		continue;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    /* case 2: one data octet */";
  z[lc++]="	    ";
  z[lc++]="	    if ((((*idx) + 2) == p->length) || (p->data[(*idx) + 2] & 0x80u))";
  z[lc++]="	      {";
  z[lc++]="		memcpy(&(mdata[len]), &(p->data[*idx]), 2);";
  z[lc++]="		if (p->length == (*idx += 2))";
  z[lc++]="		  return len + 2;";
  z[lc++]="		if ((len += 2) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="		  return len;";
  z[lc++]="		continue;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    /* case 3: two data octets */";
  z[lc++]="	    ";
  z[lc++]="	    if ((((*idx) + 3) == p->length) || (p->data[(*idx) + 3] & 0x80u))";
  z[lc++]="	      {";
  z[lc++]="		memcpy(&(mdata[len]), &(p->data[*idx]), 3);";
  z[lc++]="		if (p->length == (*idx += 3))";
  z[lc++]="		  return len + 3;";
  z[lc++]="		if ((len += 3) > (CSYSI_SENDSIZE - 3))";
  z[lc++]="		  return len;";
  z[lc++]="		continue;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	*idx += 1;";
  z[lc++]="	while ((*idx < p->length) && !(p->data[(*idx)] & 0x80u))";
  z[lc++]="	  (*idx)++;";
  z[lc++]="	if (*idx == p->length)";
  z[lc++]="	  return len;";
  z[lc++]="	continue;";
  z[lc++]="      case CSYS_MIDI_SYSTEM_SYSEX_START:                 /* SysEx commands */";
  z[lc++]="	if (CSYSI_SYSTEM_GATE == CSYSI_BLOCK_SYSTEM_COMMANDS)";
  z[lc++]="	  {";
  z[lc++]="	    if (p->data[(*idx)] == CSYS_MIDI_SYSTEM_SYSEX_START)";
  z[lc++]="	      *idx += 1;";
  z[lc++]="	    while ((*idx < p->length) && !(p->data[(*idx)] & 0x80u))";
  z[lc++]="	      (*idx)++;";
  z[lc++]="	    if (p->data[(*idx)] == CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	      (*idx)++;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  if (csysi_packet_arblength(p, mdata, idx, &len, ext))";
  z[lc++]="	    return len;";
  z[lc++]="";
  z[lc++]="	if (*idx == p->length)";
  z[lc++]="	  return len;";
  z[lc++]="	continue;";
  z[lc++]="      }";
  z[lc++]="      *idx = p->length;                                /* should never run     */";
  z[lc++]="      return len;";
  z[lc++]="    default:                                           /* a sysex continuation */";
  z[lc++]="      if (CSYSI_SYSTEM_GATE == CSYSI_BLOCK_SYSTEM_COMMANDS)";
  z[lc++]="	{";
  z[lc++]="	  while ((*idx < p->length) && !(p->data[(*idx)] & 0x80u))";
  z[lc++]="	    (*idx)++;";
  z[lc++]="	  if (p->data[(*idx)] == CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	    (*idx)++;";
  z[lc++]="	  if (*idx == p->length)";
  z[lc++]="	    return len;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	if (csysi_packet_arblength(p, mdata, idx, &len, ext))";
  z[lc++]="	  return len;";
  z[lc++]="";
  z[lc++]="      if (*idx == p->length)";
  z[lc++]="	return len;";
  z[lc++]="      continue;";
  z[lc++]="    }";
  z[lc++]="  }";
  z[lc++]="  while (1);";
  z[lc++]="  ";
  z[lc++]="  *idx = p->length;  /* should never run, loop has no exit path */";
  z[lc++]="  return len;";
  z[lc++]="} ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             recover from CoreMIDI legacy bugs                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_bugrecovery(MIDIPacket * p, unsigned char * mdata,";
  z[lc++]="		   int * idx, int len)";
  z[lc++]="{";
  z[lc++]="  mdata[len] = CSYS_MIDI_SYSTEM_RESET;";
  z[lc++]="  *idx = p->length;";
  z[lc++]="  return len + 1;   ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          parse arbitrary-length command bodies               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int csysi_packet_arblength(MIDIPacket * p, unsigned char * mdata,";
  z[lc++]="			   int * idx, int * len, unsigned char ext)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (p->data[(*idx)] == CSYS_MIDI_SYSTEM_SYSEX_START)";
  z[lc++]="    {";
  z[lc++]="      csysi_ports[ext].sysex_size = 0;";
  z[lc++]="      *idx += 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (*idx < p->length)";
  z[lc++]="    if (p->data[(*idx)] & 0x80u)";
  z[lc++]="      {";
  z[lc++]="	if (p->data[(*idx)] == CSYS_MIDI_SYSTEM_SYSEX_END)";
  z[lc++]="	  (*idx)++;";
  z[lc++]="	";
  z[lc++]="	switch (csysi_ports[ext].sysex_size) {";
  z[lc++]="	case 2:";
  z[lc++]="	  if (csysi_ports[ext].sysbuff[0] == 0x7Du)";
  z[lc++]="	    {";
  z[lc++]="	      if (csysi_ports[ext].sysbuff[1] & CSYSI_UNDEFINED_F4)";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED1;";
  z[lc++]="	      else";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED2;";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  break;";
  z[lc++]="	case 3:";
  z[lc++]="	  if (csysi_ports[ext].sysbuff[0] == 0x7Du)";
  z[lc++]="	    {";
  z[lc++]="	      if (csysi_ports[ext].sysbuff[1] & CSYSI_UNDEFINED_F4)";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED1;";
  z[lc++]="	      else";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED2;";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[2];";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  break;";
  z[lc++]="	case 4:";
  z[lc++]="	  if (csysi_ports[ext].sysbuff[0] == 0x7Du)";
  z[lc++]="	    {";
  z[lc++]="	      if (csysi_ports[ext].sysbuff[1] & CSYSI_UNDEFINED_F4)";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED1;";
  z[lc++]="	      else";
  z[lc++]="		mdata[(*len)++] = CSYS_MIDI_SYSTEM_UNUSED2;";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[2];";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[3];";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  if ((csysi_ports[ext].sysbuff[0] == 0x7Eu) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[1] == 0x7Fu) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[2] == 0x09u) &&";
  z[lc++]="	      ((csysi_ports[ext].sysbuff[3] == 0x01u) ||";
  z[lc++]="	       (csysi_ports[ext].sysbuff[3] == 0x02u)))";
  z[lc++]="	    {";
  z[lc++]="	      mdata[(*len)++] = CSYS_MIDI_GMRESET;";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[3];";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  break;";
  z[lc++]="	case 6:   ";
  z[lc++]="	  if ((csysi_ports[ext].sysbuff[0] == 0x7Fu) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[1] == 0x7Fu) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[2] == 0x04u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[3] == 0x01u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[4] < 0x80u)  &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[5] < 0x80u))";
  z[lc++]="	    {";
  z[lc++]="	      mdata[(*len)++] = CSYS_MIDI_MVOLUME;";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[4];";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[5];";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  break;";
  z[lc++]="	case 8:   ";
  z[lc++]="	  if ((csysi_ports[ext].sysbuff[0] == 0x43u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[1] == 0x73u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[2] == 0x7Fu) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[3] == 0x32u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[4] == 0x11u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[5] < 0x80u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[6] < 0x80u) &&";
  z[lc++]="	      (csysi_ports[ext].sysbuff[7] < 0x80u))";
  z[lc++]="	    {";
  z[lc++]="	      mdata[(*len)++] = CSYS_MIDI_MANUEX;";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[6];";
  z[lc++]="	      mdata[(*len)++] = csysi_ports[ext].sysbuff[7];";
  z[lc++]="	      if ((p->length == (*idx)) || ((*len) > (CSYSI_SENDSIZE - 3)))";
  z[lc++]="		return CSYSI_COMMAND_COMPLETED;";
  z[lc++]="	    }";
  z[lc++]="	  break; ";
  z[lc++]="	}";
  z[lc++]="	csysi_ports[ext].sysex_size = 0;";
  z[lc++]="	break;                               /* while */";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	if (csysi_ports[ext].sysex_size < CSYSI_SYSEXSIZE)";
  z[lc++]="	  csysi_ports[ext].sysbuff[csysi_ports[ext].sysex_size++] =";
  z[lc++]="	    p->data[*idx];";
  z[lc++]="	(*idx)++;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return CSYSI_COMMAND_ONGOING;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 low-level functions                          */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


