#include "defines.h"

#ifdef GNOME2
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#include <libgnomeui/libgnomeui.h>
#include <libgnome/libgnome.h>
#include <panel-applet.h>

#include "aquarium.h"
#include "preferences.h"
#ifdef MATRIX
#include "matrix.h"
#endif

#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

gpointer *sher_pointer;


int aquarium_timer;

GdkPixmap *pixmap;
GdkBitmap *mask;

/* Alot of the gnome 2 code comes from the FishApplet */

void gnome_timer_off()
{
  if(aquarium_timer!=0)
    gtk_timeout_remove(aquarium_timer);

}
void gnome_timer_on()
{
  if(aquarium_timer!=0)
    aquarium_timer = gtk_timeout_add(20, aquarium_update, NULL);
}

/* This shouldn't be like this!!! */
void aquarium_quit(GtkWidget *dummy, gpointer d)
{
  AquariumData *a;

  gtk_timeout_remove(aquarium_timer);

  a=get_ad();
  gtk_widget_destroy(a->applet);

  free_all();
#ifdef MATRIX
  free_matrix_all();
#endif

  if(pixmap!=NULL)
    gdk_pixmap_unref(pixmap);
  if(mask!=NULL)
    gdk_bitmap_unref(mask);
  
  g_free(a->rgb);
  g_free(a->bgr);


  /* Kill myself! */
  /* I havn't manage to make it quit in a another way. */
  kill(getpid(),SIGTERM);

}

void gnome_background(int size, int firsttime)
{
  AquariumData *a;
  char *backimage_file;
  GdkPixbuf *backimage, *backimage2;
  GError *err=NULL;

  xmax = ymax = size - 2;
  ymin = xmin = 1;
  
  a=get_ad();
  if(panel_applet_get_orient(PANEL_APPLET(a->applet))
     == PANEL_APPLET_ORIENT_UP
     || panel_applet_get_orient(PANEL_APPLET(a->applet))
     ==PANEL_APPLET_ORIENT_DOWN){

    if(mys.doublewh) xmax *= 2;      
  }
  else{
    if(mys.doublewh) ymax *= 2;
  }

  /* If nothing is changed, then why do it all again? */
  if(a->oldwidth==xmax && a->oldheight==ymax && 
     a->oldbg==((mys.solidcolour<<3)+(mys.shadedblue<<2)+(mys.wateralike<<1)+mys.yourown)) return;
      
  a->oldwidth=xmax;
  a->oldheight=ymax;
  a->oldbg=(mys.solidcolour<<3)+(mys.shadedblue<<2)+(mys.wateralike<<1)+mys.yourown;
  
  virtual_aquarium_x = xmax + 2 * VIRTUAL_AQUARIUM_DX;
  virtual_aquarium_y = ymax + 2 * VIRTUAL_AQUARIUM_DY;

  /* We are resizing! - Alot of stuff must be reallocated. */
  if(!firsttime){

    /* Change the size of allocated memory for background and work area */

    g_free(a->rgb);
    g_free(a->bgr);

    a->rgb=g_malloc0((xmax + 2) * (ymax + 2) * 3);
    a->bgr=g_malloc0((xmax + 2) * (ymax + 2) * 3);

    bubble_state_change = (ymax / 4);

    prepare_backbuffer();
  }
  else{
    /* First time for gnome2 - allock and load images */
    /* Allocated memory for background and work area */
    a->rgb = g_malloc0((xmax + 2) * (ymax + 2) * 3);
    a->bgr = g_malloc0((xmax + 2) * (ymax + 2) * 3);

    bubble_state_change = (ymax / BUBBLES_FRAMES);

#ifdef MATRIX
    if(mys.matrix)
      init_matrix_1();
#endif

    /* update sprite array with sprite data */
    prepare_graphics();


    prepare_backbuffer();

  }


  backimage_file = filename("aquarium/master-gnome.png");

  backimage = gdk_pixbuf_new_from_file(backimage_file, &err);
  if (!backimage) {
      display_file_error(backimage_file,"gnome_background", err);
  }

  bubble_state_change = (ymax / BUBBLES_FRAMES);
  
  g_free(backimage_file);

  backimage2 =
    gdk_pixbuf_scale_simple(backimage, xmax + 2, ymax + 2,
			    GDK_INTERP_HYPER);

  gdk_pixbuf_unref(backimage);
  if(pixmap!=NULL)
    gdk_pixmap_unref(pixmap);
  if(mask!=NULL)
    gdk_bitmap_unref(mask);
  

  gdk_pixbuf_render_pixmap_and_mask(backimage2, &pixmap, &mask, 80);
  gdk_pixbuf_unref(backimage2);


  gtk_widget_set_usize(a->drawingarea, xmax + 2, ymax + 2);

  if(firsttime){

    gtk_container_add (GTK_CONTAINER (a->applet), a->drawingarea);
    gtk_widget_realize(a->drawingarea);

  }
  gdk_window_shape_combine_mask(a->drawingarea->window, mask, 0, 0);
  gdk_window_set_back_pixmap(a->drawingarea->window, pixmap, False);


}

void aquarium_change_pixel_size(GtkWidget *a, int size, gpointer *d)
{
 
    gnome_timer_off();
    gnome_background(size,0);
    gnome_timer_on();
}
void aquarium_change_orient(GtkWidget *aa, PanelAppletOrient o, gpointer *d)
{
  int size;
  AquariumData *a;
  
  if(!mys.doublewh) return;
  a=get_ad();

  gnome_timer_off();
  size = panel_applet_get_size(PANEL_APPLET(a->applet));
  gnome_background(size, 0);
  gnome_timer_on();


}


void help_aquarium(GtkWidget *a, gpointer d)
{
  GtkWidget *help_me;
  
  help_me = gnome_message_box_new("For help, please read the README file\n"
				  "included in the source package.",
				  GNOME_MESSAGE_BOX_INFO,NULL);
  gtk_widget_show(help_me);


}
void about_aquarium(GtkWidget *aa, gpointer d)
{
  char *versionstr;
  char *iconfile;
  AquariumData *a;
  const char *authors[] = {
    "Maintainer: Jonas Aaberg <cja@gmx.net>",
    "See the AUTHORS file for a complete list",
    NULL
  };
  const char *documenters[] = {
    "Jonas Aaberg <cja@gmx.net>",
    NULL
  };
  char *translation = NULL;

  GError *imerr=NULL;
  GdkPixbuf *icon_image;

  a=get_ad();

  if (a->about_box) {
    gtk_widget_show(a->about_box);
    gdk_window_raise(a->about_box->window);
    return;
  }
  
  versionstr = g_strdup_printf("Version %s", VERSION);

  iconfile = filename("aquarium/sherman_icon.png");
  icon_image = gdk_pixbuf_new_from_file(iconfile,&imerr);

  a->about_box = gnome_about_new("Sherman's aquarium", versionstr,
				 "Fish graphics copyrighted by Jim Toomey"
				 "(http://www.slagoon.com)\n"
				 "Applet Copyright Jonas Aaberg<cja@gmx.net>",
				 "Homepage is http://aquariumapplet.sourceforge.net\n",
				 authors,
				 documenters,
				 translation,
				 icon_image);

  gtk_window_set_wmclass(GTK_WINDOW(a->about_box), "shermans_aquarium",
			 "Sherman's aquarium");
  gnome_window_icon_set_from_file(GTK_WINDOW(a->about_box),
				  iconfile);

    

  gtk_signal_connect(GTK_OBJECT(a->about_box), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		     &a->about_box);

  gdk_pixbuf_unref(icon_image);
  g_free(iconfile);

  gtk_widget_show(a->about_box);
    

}

void start_preferences(GtkWidget *aw, gpointer d)
{
  create_preferences(1);
}




static const BonoboUIVerb sherman_menu_verbs [] = {
        BONOBO_UI_UNSAFE_VERB ("ShermanPreferences", start_preferences),
	BONOBO_UI_UNSAFE_VERB ("ShermanHelp",        help_aquarium),
        BONOBO_UI_UNSAFE_VERB ("ShermanAbout",       about_aquarium),

        BONOBO_UI_VERB_END
};


struct eventfunc {
        char *event;
        GtkSignalFunc func;
};
struct eventfunc eventfuncs[] = {
        { "enter_notify_event",GTK_SIGNAL_FUNC(entering_aquarium) },
        { "leave_notify_event",GTK_SIGNAL_FUNC(leaving_aquarium) },
        { "change_size",GTK_SIGNAL_FUNC(aquarium_change_pixel_size) },
        { "change_orient",GTK_SIGNAL_FUNC(aquarium_change_orient) },
        { "destroy",GTK_SIGNAL_FUNC(aquarium_quit) },
        { NULL, NULL }
};


int aquarium_main_gnome2(PanelApplet *panel)
{
  struct eventfunc *func;
  AquariumData *a;

  a=get_ad();

  a->applet=GTK_WIDGET(panel);

  gtk_widget_realize(a->applet);
  a->gc = gdk_gc_new(a->applet->window);
  a->drawingarea = gtk_drawing_area_new();
  gnome_background(panel_applet_get_size(PANEL_APPLET(a->applet)),1);






    /*
    g_snprintf(tmp2,sizeof(tmp2),"Sherman's aquarium v%s",VERSION);
        applet_widget_set_tooltip(APPLET_WIDGET(a->applet),tmp2);
    */



  aquarium_timer = gtk_timeout_add(20, aquarium_update, NULL);

  func = eventfuncs;
  while (func->event != NULL){
    gtk_signal_connect(GTK_OBJECT(a->applet),func->event,
		       func->func,NULL);
    func ++;
  }


  panel_applet_setup_menu_from_file (PANEL_APPLET (a->applet),
				     NULL,
				     "GNOME_ShermansaquariumApplet.xml",
				     NULL,
				     sherman_menu_verbs,
				     NULL);

  gtk_widget_show_all(a->applet);

  return TRUE;
}



int shermans_aquarium_factory (PanelApplet *applet, const gchar *iid, gpointer data)
{
  gboolean retval = FALSE;
  if (!strcmp (iid, "OAFIID:GNOME_ShermansaquariumApplet"))
    retval = aquarium_main_gnome2(applet);
  return retval;                                                          
}



int aquarium_make_new_applet_gnome_with_panel_test(int argc, char *argv[],
						   int test_panel)
{
    char tmp[10];
    AquariumData *a;

    aquarium_timer=0;
    pixmap=NULL;
    mask=NULL;
    a=get_ad();

    g_snprintf(tmp,sizeof(tmp), "%s", VERSION);

    gnome_program_init("Shermans_aquarium",tmp, LIBGNOMEUI_MODULE, argc, argv, 
		       GNOME_PARAM_NONE,NULL);


    panel_applet_factory_main ("OAFIID:GNOME_ShermansaquariumApplet_Factory", PANEL_TYPE_APPLET, 
				      shermans_aquarium_factory,NULL);
    aquarium_quit(a->applet,NULL);
    return 0;
}




int aquarium_make_new_applet_gnome(int argc, char **argv)
{
    return aquarium_make_new_applet_gnome_with_panel_test(argc, argv, 0);
}


/* Detects if the gnome panel is running me */
int detect_gnome2_panel(int argc, char **argv)
{
  if(argc<3) return 0;
  if(strlen(argv[1])<25) return 0;
  if(!strncmp(argv[1],"--oaf-activate-iid=OAFIID:",24)) return 1;
  return 0;
}






#endif
