
/***************************************************************************
                          imagelistview.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307   *
 *   USA.                                                                  *
 *                                                                         *
 *   For license exceptions see LICENSE.EXC file, attached with the source *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef _IMAGELISTVIEW_H_
#define _IMAGELISTVIEW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE 
#include <kfileiconview.h>
#include <ktrader.h>

// QT
#include <qtooltip.h>

// Local 
#include "describe.h"

class FileIconItem;
class MainWindow;
class ImageLoader;
class ImageListView;

class KProcess;
class KPopupMenu;
class KFileViewItem;
class KAction;
class KIconEffect;
class KToggleAction;

class QListViewItem;
class QIconViewItem;
class QFileInfo;

class KToolTip : public QToolTip
{
public:
	KToolTip(QWidget *parent, ImageListView *imageList);
	virtual ~KToolTip(){};

	void maybeTip(const QPoint &pos);
	void tip ( const QRect & r, const QString& text );

private:
	ImageListView *imageList;
};



class ImageListView : public KIconView
{
	Q_OBJECT
public:
	ImageListView (QWidget * parent, const char *name, MainWindow * mw);

	void initMenu(KActionCollection *actionCollection);

	void mousePress (QMouseEvent * e);
	void contentsMouseReleaseEvent ( QMouseEvent * e );
	void contentsMousePressEvent ( QMouseEvent * e );
	void contentsMouseDoubleClickEvent ( QMouseEvent * e );

	virtual void setItemTextPos ( ItemTextPos pos );

	bool doPreload();
	void setPreload(bool p);

	bool doLoop();
	void setLoop(bool loop);

	bool doRandom();
	void setRandom(bool ran);

	bool showMeta();
	void setShowMeta(bool sMeta);
	bool showHexa();
	void setShowHexa(bool sHexa);
	bool getShowMimeType();
	void setShowMimeType(bool s);
	bool getShowSize();
	void setShowSize(bool s);
	bool getShowDate();
	void setShowDate(bool s);
	bool getShowDimension();
	void setShowDimension(bool s);
	bool getShowToolTips();
	void setShowToolTips(bool s);

	void setgimpPath(const QString& gimp);
	QString getgimpPath();

	/**
		return true if it have to show ALL files
	*/
	void setPreloadIm(bool prel);
	bool preloadIm();

	void load(FileIconItem* item);
	void load(const QString& path);
	void reload();


	FileIconItem* firstItem ();
	FileIconItem* currentItem();
	FileIconItem* lastItem();
	FileIconItem* findItem (const QString& text, bool fullname=false);
	FileIconItem* itemAt(const QPoint pos);

	void refresh ();
	void stopLoading ();
	void setThumbnailSize(const QSize newSize, bool refresh=true);

	void sort();
	QString getCurrentKey();

	KPopupMenu* popupOpenWith();

	QString currentItemName();
	void setCurrentItemName(const QString& itemName, bool select=true);
	bool hasSelection();
	bool hasImages();
	bool hasImageSelected();
	bool hasOnlyOneImageSelected();
	int countSelected();
	FileIconItem* firstSelected();

	bool inFullScreen;
	bool preview;
	ImageLoader * il;

	QSize getCurrentIconSize();
	
	QStringList allItems();
	KURL::List allItemsURL();
	QStringList selectedItems();
	KURL::List selectedURLs();
	KURL::List selectedImageURLs();
	QStringList allItemsPath();
	QStringList selectedItemsPath();
	void refreshItems(const QStringList& itemList);
	
	bool currentDragItemAreMovable();

signals:
	void loadFinish();

protected:
	int sortMode;
	
	QDragObject* dragObject();
	void leaveEvent (QEvent *e) ;

protected slots:
	void deletionDone( KIO::Job *);
	void highlight(QIconViewItem *item);
	void onViewport();
	void slotDescribeClose();

	void popup(QIconViewItem *item, const QPoint &point);
	void slotRun(int id);
	
	void forceGenerateThumbnails__( KIO::Job *job=NULL);
	void generateEXIFThumbnails__( KIO::Job *job=NULL);

	void slotEXIFOrientation();
	
public slots:
	void slotByName();
	void slotByExtension();
	void slotBySize();
	void slotByDate();
	void slotByDirName();

	void slotWallpaper ();
	void slotKhexedit ();
	void slotGimp ();
	void slotEndGimp (KProcess *proc);

	void slotSupprimmer ();
	void slotMoveToTrash();
	void slotShred();

	void slotFilesMoveTo();
	void slotFilesCopyTo();

	void slotFileProperty();
	void slotImageInfo();

	void next ();
	void previous ();
	void first ();
	void last ();

	void slotOpenWith();
	void slotRename();

	void slotSetPixmap (const QPixmap pm, QFileInfo *imgFile, bool success, bool force, bool forceEXIF=false);

	void slotLoadFirst (bool force=false, bool forceEXIF=false);
	void slotLoadFirst(FileIconItem *item);
	void slotLoadNext (bool force=false, bool forceEXIF=false);
	void slotResetThumbnail();

	void slotInvertSelection();
	void slotUnselectAll();
	void slotSelectAll();
	virtual void slotUpdate ();

	void selectionChanged();
	
	void slotDisplayExifInformation();
	
	KIO::Job* removeThumbnails(bool allCurrentItems=false);
	void forceGenerateThumbnails();
	void generateEXIFThumbnails();

	
public:
	FileIconItem *curIt;

private:
	QSize *currentIconSize;

	QPixmap *currentIconItem;
	QString currentIconItemName;
	bool currentIconItemHasPreview;
	KIconEffect *iconEffect;
	
	QString lastDestDir;

	Describe *dscr;

	int nbrTh;

	bool loop_; //loop icons
	bool preload_; //preload
	bool random_; //random

	bool sMeta_, sHexa_;
	bool sMimeType_, sSize_, sDate_, sDimension_; 
	bool sToolTips_;
	QString gimpPath_;

	MainWindow *mw;
	
	FileIconItem *imageLoading;
	bool isLoadingThumbnail;

	KPopupMenu *m_popup, *m_popupEmpty, *m_popup_openWith ;
	KTrader::OfferList m_offerList;
	KActionCollection *actionCollection;

	KToolTip *toolTips;

	bool mouseIsPressed;
	bool m_currentDragItemAreMovable;
	
	KToggleAction 
		*aEXIF_Orientation_normal, *aEXIF_Orientation_hflip,
		*aEXIF_Orientation_vflip, *aEXIF_Orientation_rot90,
		*aEXIF_Orientation_rot270;
		
};
#endif
