/* $Id: port_cfe.c,v 1.8 2003/05/30 00:42:39 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "cfe_api.h"
#include "libc.h"

static int cfe_console_handle = -1;


/* This is defined by the linker to be after .bss */
extern unsigned char _end;

unsigned char *lib_heap;
unsigned int lib_heap_size;

void lib_port_init(void *unused)
{
	cfe_console_handle = cfe_getstdhandle(CFE_STDHANDLE_CONSOLE);
	lib_heap = &_end;
	lib_heap_size = 128 * 1024;
	if (cfe_console_handle < 0) {
		lib_exit();
	}
}

void lib_port_uninit(void)
{
}


/* Need to keep pounding character out until cfe says it got it */
static void pound_char(char c)
{  
	int retval = 0;
	int timeout = 0;
	while (retval == 0) {
		retval = cfe_write(cfe_console_handle, &c, 1);
		if (retval < 0) {
				/* XXX error handling */
			return;
		}
		if (++timeout == 100000000) {
			while(1);
		}
	}
}

void lib_putc(char c)
{
	if (c == '\n') {
		pound_char('\r');
	}
	pound_char(c);
}

void lib_port_exit(void)
{
	cfe_exit(1, 0);
}

/* Pretty miserable resolution on this, but should be OK */
uint64_t lib_get_time(void)
{
	return cfe_getticks() * 100000;
}

int   lib_poll_input (char *targ)
{
	int retval = 0;
	if (cfe_inpstat(cfe_console_handle)) {
		retval = 1;
		cfe_read(cfe_console_handle, targ, 1);
	}
	return retval;
}
