//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

#include "data.h"

// Wrap any SV coming from outside Data in newSVsv() to
// make sure we have control of our copy

SigCPerl::Data::Data(const Data &d) throw() : m_data(d.m_data)
{
  for(unsigned int i = 0; i < m_data.size(); ++i)
    SvREFCNT_inc(m_data[i]);
}

SigCPerl::Data::Data(const Iter& i1, const Iter& i2) throw() : m_data(i1.m_i, i2.m_i)
{
 // Have to use Iter::IType instead of Iter, since
 // dereferencing Iter creates a new SV, instead of
 // giving access to the one present in the data.
 for(Iter::IType i = i1.m_i; i != i2.m_i; ++i)
    SvREFCNT_inc(*i);
}

SigCPerl::Data::Data(const Data &d1, const Data &d2) throw()
	: m_data(d1.m_data.size() + d2.m_data.size())
{
  for(unsigned int i = 0; i < d1.m_data.size(); ++i) {
    SvREFCNT_inc(d1.m_data[i]);
    m_data[i] = d1.m_data[i];
  }
  for(unsigned int i = 0; i < d2.m_data.size(); ++i) {
    SvREFCNT_inc(d2.m_data[i]);
    m_data[d1.m_data.size()+i] = d2.m_data[i];
  } 
}

SigCPerl::Data::~Data() throw()
{
  for(unsigned int i = 0; i < m_data.size(); ++i)
    SvREFCNT_dec(m_data[i]);
}

SigCPerl::Data& SigCPerl::Data::operator=(const Data &d) throw()
{
  for(unsigned int i = 0; i < m_data.size(); ++i)
    SvREFCNT_dec(m_data[i]);

  m_data = d.m_data;

  for(unsigned int i = 0; i < m_data.size(); ++i)
    SvREFCNT_inc(m_data[i]);

  return *this;
}

void SigCPerl::Data::push_stack() const throw()
{
  if(m_data.size() == 0)
    return;

  dSP;

  for(unsigned int i = 0; i < m_data.size(); ++i)
    XPUSHs(sv_mortalcopy(m_data[i]));

  PUTBACK;
}

SigCPerl::Data SigCPerl::Data::pop_stack(unsigned int count) throw()
{
  dSP;

  Data data(count);
  while(count > 0)
    data.m_data[--count] = newSVsv(POPs);

  PUTBACK;

  return data;
}
