#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "GraphicToolbox.h"

@implementation GraphicToolbox
/*
static NSArray *
setableItems (void) {
        static NSArray *arr = nil;

	if (!arr) {
	arr = [[NSArray alloc] initWithObjects:
	@"controlColor",
	@"textBackgroundColor",
	@"controlBackgroundColor",
	@"windowBackgroundColor", nil];
	}
	return arr;
}
*/

+ (void) setColor 
{
    /*
    NSUserDefaults* defaults = [NSUserDefaults standardUserDefaults];
    NSMutableDictionary* domain = [[defaults persistentDomainForName: NSGlobalDomain] mutableCopy];
    NSColor* bgc = [NSColor colorWithCalibratedRed: 1.0 green: 1.0 blue: 1.0 alpha: 0.0];
    NSColor* tbgc = [NSColor colorWithCalibratedRed: 0.3 green: 0.8 blue: 0.3 alpha: 0.9];

    //[domain setObject: [NSColor redColor] forKey: @"controlColor"];
    [domain setObject: bgc forKey: @"controlColor"];
    [domain setObject: bgc forKey: @"textBackgroundColor"];
    [domain setObject: bgc forKey: @"controlBackgroundColor"];
    [domain setObject: tbgc forKey: @"windowBackgroundColor"];
    
//    [domain setObject: [NSColor greenColor] forKey: @"textBackgroundColor"];
//    [domain setObject: [NSColor blueColor] forKey: @"controlBackgroundColor"];
//    [domain setObject: [NSColor yellowColor] forKey: @"windowBackgroundColor"];
    [defaults setPersistentDomain: domain forName: NSGlobalDomain];
    //[defaults synchronize];
    */
}

+ (void) drawHorizontalGradientOnRect: (NSRect) rect 
    withStartColor: (NSColor*) begin 
    andEndColor: (NSColor*) end 
{
    int i;
    float x0 = rect.origin.x;
    float x1 = rect.origin.x + rect.size.width;
    float y0 = rect.origin.y;
    float y1 = rect.origin.y + rect.size.height;
    float nb_pas = rect.size.width;
    float pasRed = ([end redComponent] - [begin redComponent]) / nb_pas;
    float pasGreen = ([end greenComponent] - [begin greenComponent]) / nb_pas;
    float pasBlue = ([end blueComponent] - [begin blueComponent]) / nb_pas;
    float pasAlpha = ([end alphaComponent] - [begin alphaComponent]) / nb_pas;
    float red = [begin redComponent];
    float green = [begin greenComponent];
    float blue = [begin blueComponent];
    float alpha = [begin alphaComponent];

    for (i = 0; i < nb_pas; i++)
    {
	red += pasRed;
	green += pasGreen;
	blue += pasBlue;
	alpha += pasAlpha;

	[[NSColor colorWithCalibratedRed: red green: green blue: blue alpha: alpha] set]; 
//	NSRectFill (NSMakeRect (x0+i,y0,1,y1-y0));
	[NSBezierPath fillRect: NSMakeRect (x0+i,y0,1,y1-y0)];
    }
}
+ (void) drawVerticalGradientOnRect: (NSRect) rect 
    withStartColor: (NSColor*) begin
    andEndColor: (NSColor*) end
{
    int i;
    float x0 = rect.origin.x;
    float x1 = rect.origin.x + rect.size.width;
    float y0 = rect.origin.y;
    float y1 = rect.origin.y + rect.size.height;
    float nb_pas = rect.size.height;
    float pasRed = ([end redComponent] - [begin redComponent]) / nb_pas;
    float pasGreen = ([end greenComponent] - [begin greenComponent]) / nb_pas;
    float pasBlue = ([end blueComponent] - [begin blueComponent]) / nb_pas;
    float pasAlpha = ([end alphaComponent] - [begin alphaComponent]) / nb_pas;
    float red = [begin redComponent];
    float green = [begin greenComponent];
    float blue = [begin blueComponent];
    float alpha = [begin alphaComponent];

    for (i = 0; i < nb_pas; i++)
    {
	red += pasRed;
	green += pasGreen;
	blue += pasBlue;
	alpha += pasAlpha;

	[[NSColor colorWithCalibratedRed: red green: green blue: blue alpha: alpha] set]; 
	[NSBezierPath fillRect: NSMakeRect (x0,y0+i,x1-x0,1)];
    }
}
+ (void) drawButtonOnRect: (NSRect) rect pushed: (BOOL) state
{
	[self drawButtonOnRect: rect pushed: state width: 1];
}
+ (void) drawButtonOnRect: (NSRect) rect pushed: (BOOL) state width: (int) width 
{
        NSColor* highlight = [NSColor colorWithCalibratedRed: 1.0 green: 1.0 blue: 1.0 alpha: 0.5];
        NSColor* downlight = [NSColor colorWithCalibratedRed: 0.0 green: 0.0 blue: 0.0 alpha: 0.7];
	[self drawButtonOnRect: rect pushed: state width: width highlight: highlight downlight: downlight flipped: NO];
}
+ (void) drawButtonOnRect: (NSRect) prect pushed: (BOOL) state width: (int) width 
	highlight: (NSColor*) highlight downlight: (NSColor*) downlight flipped: (BOOL) flipped
{
    int i;

    //NSColor* highlight = [NSColor colorWithCalibratedRed: 1.0 green: 0.0 blue: 0.0 alpha: 1.0];
    //NSColor* downlight = [NSColor colorWithCalibratedRed: 0.0 green: 1.0 blue: 0.0 alpha: 1.0];
    NSColor* midlight = [NSColor colorWithCalibratedRed: 0.0 green: 0.0 blue: 0.0 alpha: 0.4];

    NSRect rect = prect;
    //rect.size.width = prect.size.width -1;
    //rect.size.height = prect.size.height -1;
 
    NSBezierPath* cadre = [NSBezierPath bezierPath];
    //NSBezierPath* cadre = [NSBezierPath bezierPathWithRect: prect];
    [highlight set];
    [cadre moveToPoint: NSMakePoint (rect.origin.x, rect.origin.y)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x, rect.origin.y + rect.size.height)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x + rect.size.width, rect.origin.y + rect.size.height)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x + rect.size.width, rect.origin.y)];
    [cadre closePath];
    //[cadre lineToPoint: NSMakePoint (rect.origin.x, rect.origin.y)];
    [cadre setLineWidth: 0];
    //[cadre stroke];

    for (i=0; i<width;i++)
    {
	    NSBezierPath* cadreLight = [NSBezierPath bezierPath];
	    NSBezierPath* cadreDark = [NSBezierPath bezierPath];
	    NSBezierPath* cadreMid = [NSBezierPath bezierPath];

	    [cadreLight setLineWidth: 0];
	    [cadreDark setLineWidth: 0];
	    [cadreMid setLineWidth: 0];

	    if (flipped)
	    {
	    	    [cadreLight moveToPoint: NSMakePoint (rect.origin.x, rect.origin.y + rect.size.height)];
		    [cadreLight lineToPoint: rect.origin];
		    [cadreLight lineToPoint: NSMakePoint (rect.origin.x+rect.size.width, rect.origin.y)];
		    
		    [cadreDark moveToPoint: NSMakePoint (rect.origin.x+rect.size.width, rect.origin.y)];
		    [cadreDark lineToPoint: NSMakePoint (rect.origin.x+rect.size.width, rect.origin.y + rect.size.height)];
		    [cadreDark lineToPoint: NSMakePoint (rect.origin.x, rect.origin.y + rect.size.height)];

		    [cadreMid moveToPoint: NSMakePoint (rect.origin.x+rect.size.width-1, rect.origin.y+1)];
		    [cadreMid lineToPoint: NSMakePoint (rect.origin.x+rect.size.width-1, rect.origin.y + rect.size.height - 1)];
		    [cadreMid lineToPoint: NSMakePoint (rect.origin.x + 1, rect.origin.y + rect.size.height - 1)];
	    }
	    else
	    {
		    [cadreLight moveToPoint: NSMakePoint (rect.origin.x,rect.origin.y)];
		    [cadreLight lineToPoint: NSMakePoint (rect.origin.x,rect.origin.y+rect.size.height)];
		    [cadreLight lineToPoint: NSMakePoint (rect.origin.x+rect.size.width,rect.origin.y+rect.size.height)];

		    [cadreDark moveToPoint: NSMakePoint (rect.origin.x,rect.origin.y)];
		    [cadreDark lineToPoint: NSMakePoint (rect.origin.x+rect.size.width,rect.origin.y)];
		    [cadreDark lineToPoint: NSMakePoint (rect.origin.x+rect.size.width,rect.origin.y+rect.size.height)];

		    [cadreMid moveToPoint: NSMakePoint (rect.origin.x+1, rect.origin.y+1)];
		    [cadreMid lineToPoint: NSMakePoint (rect.origin.x+rect.size.width-1,rect.origin.y+1)];
		    [cadreMid lineToPoint: NSMakePoint (rect.origin.x+rect.size.width-1,rect.origin.y+rect.size.height-1)];
	    }

	    if (state) [downlight set]; else [highlight set];
	    [cadreLight stroke];


	    if (state) [highlight set]; else [downlight set];
	    [cadreDark stroke];

	    [midlight set];
	    [cadreMid stroke];

	    rect = NSMakeRect (rect.origin.x+1,rect.origin.y+1,rect.size.width-2,rect.size.height-2);
    }
}
+ (void) drawButtonWithImage: (NSRect) rect flipped: (BOOL) flip
{
    Theme* theme = [Theme sharedTheme];

    BOOL Size = NO;

    if ((rect.size.width > 20) && (rect.size.height > 20))
	Size = YES;

    NSImage* imageSupLeft;
    NSImage* imageSup;
    NSImage* imageSupRight;
    NSImage* imageLeft;
    NSImage* imageRight;
    NSImage* imageLowLeft;
    NSImage* imageLow;
    NSImage* imageLowRight;

    if (Size)
    {
    	imageSupLeft  = [NSImage imageNamed: @"ButtonSupLeft.tiff"];
	imageSup      = [NSImage imageNamed: @"ButtonSup.tiff"];
	imageSupRight = [NSImage imageNamed: @"ButtonSupRight.tiff"];
	imageLeft     = [NSImage imageNamed: @"ButtonLeft.tiff"];
	imageRight    = [NSImage imageNamed: @"ButtonRight.tiff"];
	imageLowLeft  = [NSImage imageNamed: @"ButtonLowLeft.tiff"];
	imageLow      = [NSImage imageNamed: @"ButtonLow.tiff"];
	imageLowRight = [NSImage imageNamed: @"ButtonLowRight.tiff"];
    }
    else
    {
    	imageSupLeft  = [NSImage imageNamed: @"ButtonSupLeftSmall.tiff"];
	imageSup      = [NSImage imageNamed: @"ButtonSupSmall.tiff"];
	imageSupRight = [NSImage imageNamed: @"ButtonSupRightSmall.tiff"];
	imageLeft     = [NSImage imageNamed: @"ButtonLeftSmall.tiff"];
	imageRight    = [NSImage imageNamed: @"ButtonRightSmall.tiff"];
	imageLowLeft  = [NSImage imageNamed: @"ButtonLowLeftSmall.tiff"];
	imageLow      = [NSImage imageNamed: @"ButtonLowSmall.tiff"];
	imageLowRight = [NSImage imageNamed: @"ButtonLowRightSmall.tiff"];
    }

    [[NSColor colorWithCalibratedRed: 0.589 green: 0.734 blue: 0.89 alpha: 1.0] set];
    //[[NSColor colorWithCalibratedRed: 0.215 green: 0.521 blue: 0.847 alpha: 1.0] set];
    //[[NSColor colorWithCalibratedRed: 0.451 green: 0.643 blue: 0.901 alpha: 1.0] set];
    
    if (flip)
    {
	NSPoint position;

	// We draw the four corners images ...

	position.x = rect.origin.x;
	position.y = rect.origin.y + [imageSupLeft size].height;
	
	[imageSupLeft compositeToPoint: position operation: NSCompositeSourceOver];
	
	position.x = rect.origin.x + rect.size.width - [imageSupRight size].width;

	[imageSupRight compositeToPoint: position operation: NSCompositeSourceOver];

	position.x = rect.origin.x;
	position.y = rect.origin.y + rect.size.height; 

	[imageLowLeft compositeToPoint: position operation: NSCompositeSourceOver];

	position.x = rect.origin.x + rect.size.width - [imageLowRight size].width;

	[imageLowRight compositeToPoint: position operation: NSCompositeSourceOver];

	// Now we draw the middle -- left part

	[NSBezierPath clipRect: NSMakeRect (rect.origin.x, rect.origin.y + 
		[imageSupLeft size].height, rect.size.width, rect.size.height -
		[imageSupLeft size].height - [imageLowLeft size].height)];

	// We fill the middle rect with some color

	NSRectFill (NSMakeRect (rect.origin.x + [imageSupLeft size].width, 
		    rect.origin.y + [imageSupLeft size].height,
		    rect.size.width - [imageSupLeft size].width*2,
		    rect.size.height - [imageSupLeft size].height*2));

	position.x = rect.origin.x;
	int i = rect.origin.y + rect.size.height;
	int h = [imageLeft size].height;
	while (i >= rect.origin.y)
	{
	    position.y = i;
	    [imageLeft compositeToPoint: position operation: NSCompositeSourceOver];
	    i -= h;
	}
	position.x = rect.origin.x + rect.size.width - [imageRight size].width - 1;
	i = rect.origin.y + rect.size.height;
	h = [imageRight size].height;
	while (i >= rect.origin.y)
	{
	    position.y = i;
	    [imageRight compositeToPoint: position operation: NSCompositeSourceOver];
	    i -= h;
	}

	/*

	position.x = rect.origin.x;

	position.y = rect.origin.y + [imageSupLeft size].height;
	int h = [imageLeft size].height;
	int hstart = position.y + h;
	int hend = rect.origin.y + rect.size.height; // - [imageLowLeft size].height;
	int i = hstart;
	//for (i = hstart; i <= hend; i+= h)
	while (i+h <= hend)
	{
	    position.y = i;
	    [imageLeft compositeToPoint: position operation: NSCompositeSourceOver];
	    i += h;
	}
	*/
	//[[NSColor colorWithCalibratedRed: 1.0 green: 0.0 blue: 0.0 alpha: 1.0] set];
	//NSDottedFrameRect (rect);
	/*
	if ( (i+h) > hend )
	{
	    int r = hend - i;
	    NSLog (@"i : %d hend : %d h : %d r : %d", i, hend, h, r);
	    if (r > 0)
	    [imageLeft drawAtPoint: position fromRect: NSMakeRect (0,0,[imageLeft size].width,r)
		operation: NSCompositeSourceOver fraction: 0.0];
	}
	*/
	
	
	/*
	NSRectFill (NSMakeRect (rect.origin.x + [imageSupLeft size].width, 
		    rect.origin.y + [imageSupLeft size].height,
		    rect.size.width - [imageSupLeft size].width*2,
		    rect.size.height - [imageSupLeft size].height*2));

	NSPoint position;
	position.x = rect.origin.x;
	position.y = rect.origin.y +  [imageSupLeft size].height;

	[imageSupLeft compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x + rect.size.width - [imageSupRight size].width;
	[imageSupRight compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x;
	position.y = rect.origin.y + rect.size.height;
	[imageLowLeft compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x + rect.size.width - [imageLowRight size].width;
	[imageLowRight compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x;
	position.y = rect.origin.y + [imageSupLeft size].height;
	int h = [imageLeft size].height;
	int hstart = position.y;
	int hend = rect.origin.y + rect.size.height - [imageLowLeft size].height;
	int i;
	for (i = hstart; i <= hend; i+= h)
	{
	    position.y = i;
	    [imageLeft compositeToPoint: position operation: NSCompositeSourceOver];
	}
	position.x = rect.origin.x + rect.size.width - [imageSupRight size].width;
	for (i = hstart; i <= hend; i+= h)
	{
	    position.y = i;
	    [imageRight compositeToPoint: position operation: NSCompositeSourceOver];
	}
	int w = [imageSup size].width;
	int wstart = rect.origin.x + [imageSupLeft size].width;
	int wend = rect.origin.x + rect.size.width - [imageSupRight size].width;
	position.y = rect.origin.y + [imageSup size].height;
	NSLog (@" w : %d wstart : %d wend : %d", w, wstart, wend);
	for (i = wstart; i < wend; i+= w)
	{
	    position.x = i;
	    [imageSup compositeToPoint: position operation: NSCompositeSourceOver];
	}
	position.y = rect.origin.y + rect.size.height;
	w = [imageLow size].width;
	wstart = rect.origin.x + [imageLowLeft size].width;
	wend = rect.origin.x + rect.size.width - [imageLowRight size].width;
	for (i = wstart; i < wend; i+= w)
	{
	    position.x = i;
	    [imageLow compositeToPoint: position operation: NSCompositeSourceOver];
	}
	*/
    }
    else
    {
	NSRectFill (NSMakeRect (rect.origin.x + [imageSupLeft size].width, 
		    rect.origin.y + [imageLowLeft size].height,
		    rect.size.width - [imageSupLeft size].width*2,
		    rect.size.height - [imageSupLeft size].height*2));

	NSPoint position;
	position.x = rect.origin.x;
	position.y = rect.origin.y + rect.size.height - [imageSupLeft size].height;

	[imageSupLeft compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x + rect.size.width - [imageSupRight size].width;
	[imageSupRight compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x;
	position.y = rect.origin.y;
	[imageLowLeft compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x + rect.size.width - [imageLowRight size].width;
	[imageLowRight compositeToPoint: position operation: NSCompositeSourceOver];
	position.x = rect.origin.x;
	position.y = rect.origin.y + [imageLowLeft size].height;
	int h = [imageLeft size].height;
	int hstart = position.y;
	int hend = rect.origin.y + rect.size.height - [imageSupLeft size].height;
	int i;
	for (i = hstart; i < hend; i+= h)
	{
	    position.y = i;
	    [imageLeft compositeToPoint: position operation: NSCompositeSourceOver];
	}
	position.x = rect.origin.x + rect.size.width - [imageSupRight size].width;
	for (i = hstart; i < hend; i+= h)
	{
	    position.y = i;
	    [imageRight compositeToPoint: position operation: NSCompositeSourceOver];
	}
	int w = [imageSup size].width;
	int wstart = rect.origin.x + [imageSupLeft size].width;
	int wend = rect.origin.x + rect.size.width - [imageSupRight size].width;
	position.y = rect.origin.y + rect.size.height - [imageSup size].height;
	//NSLog (@" w : %d wstart : %d wend : %d", w, wstart, wend);
	for (i = wstart; i < wend; i+= w)
	{
	    position.x = i;
	    [imageSup compositeToPoint: position operation: NSCompositeSourceOver];
	}
	position.y = rect.origin.y;
	w = [imageLow size].width;
	wstart = rect.origin.x + [imageLowLeft size].width;
	wend = rect.origin.x + rect.size.width - [imageLowRight size].width;
	for (i = wstart; i < wend; i+= w)
	{
	    position.x = i;
	    [imageLow compositeToPoint: position operation: NSCompositeSourceOver];
	}
    }

}
+ (void) drawCadre: (NSRect) rect withTextRect: (NSRect) trect
{
    NSBezierPath* cadre = [NSBezierPath bezierPath];
    [cadre moveToPoint: NSMakePoint (trect.origin.x, rect.origin.y + rect.size.height)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x, rect.origin.y + rect.size.height)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x, rect.origin.y)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x + rect.size.width, rect.origin.y)];
    [cadre lineToPoint: NSMakePoint (rect.origin.x + rect.size.width, rect.origin.y + rect.size.height)];
    [cadre lineToPoint: NSMakePoint (trect.origin.x + trect.size.width, rect.origin.y + rect.size.height)];
    [[NSColor blackColor] set];
    [cadre setLineWidth: 0];
    [cadre stroke];
}
+ (void) drawCadre: (NSRect) rect
{
    NSBezierPath* cadreLight;
    NSBezierPath* cadreDark;
    cadreLight = [NSBezierPath bezierPathWithRect: NSMakeRect (rect.origin.x, 
	    rect.origin.y+1, rect.size.width-1, rect.size.height-2)];
    cadreDark = [NSBezierPath bezierPathWithRect: NSMakeRect (rect.origin.x+2, 
	    rect.origin.y,rect.size.width-2, rect.size.height)];
    [[NSColor colorWithCalibratedRed: 1.0 green: 1.0 blue: 1.0 alpha: 1.0] set];
    [cadreLight setLineWidth: 0];
//    [cadreLight stroke];
    [[NSColor colorWithCalibratedRed: 0.0 green: 0.0 blue: 0.0 alpha: 1.0] set];
    [cadreDark setLineWidth: 0];
    [cadreDark stroke];
}

+ (void) drawFrame: (NSRect) rect
{
	NSBezierPath* cadre = [NSBezierPath bezierPathWithRect: rect];
	[[NSColor whiteColor] set];
	[cadre fill];
	[[NSColor colorWithCalibratedRed: 0.55 green: 0.55 blue: 0.55 alpha: 1.0] set];
	[cadre setLineWidth: 0];
	[cadre stroke];
	NSBezierPath* insideCadre = [NSBezierPath bezierPathWithRect: 
		NSMakeRect (rect.origin.x+1,rect.origin.y+1,rect.size.width-2,rect.size.height-2)];
	[[NSColor colorWithCalibratedRed: 0.8 green: 0.8 blue: 0.8 alpha: 1.0] set];
	[insideCadre setLineWidth: 0];
	[insideCadre stroke];
}

+ (void) fillRect: (NSRect) rect withHorizontalImage: (NSImage*) image
{
   if (image != nil)
   {
   	float posX = rect.origin.x;
	float max = rect.origin.x + rect.size.width;
	float width = [image size].width;
   	RETAIN(image);
	
	while (posX <= max)
	{
		[image compositeToPoint: NSMakePoint (posX,rect.origin.y) operation: NSCompositeSourceOver];
		posX += width;
	}	
	RELEASE(image);
   }
}

+ (void) semiRoundPathWithRect: (NSRect) rect andRound: (int) round
{
  int x0 = rect.origin.x;
  int y0 = rect.origin.y;
  int x1 = rect.origin.x + rect.size.width;
  int y1 = rect.origin.y + rect.size.height;
  int w = rect.size.width;
  int h = rect.size.height;
  NSBezierPath* cadre = [NSBezierPath bezierPath];

  [cadre moveToPoint: NSMakePoint (x0, y0)]; 
  [cadre appendBezierPathWithArcWithCenter: NSMakePoint (x0 + round, y0)
      radius: round startAngle: 180 endAngle: 90 clockwise: YES];
  [cadre lineToPoint: NSMakePoint (x1 - round, y1)];
  [cadre appendBezierPathWithArcWithCenter: NSMakePoint (x1 - round, y0)
      radius: round startAngle: 90 endAngle: 0 clockwise: YES];
  [cadre closePath];
  [[NSColor colorWithCalibratedRed: 1.0 green: 1.0 blue: 1.0 alpha: 0.3] set];
  [cadre fill];
}
@end
