<?php
/******************************************************************************
 *  SiteBar 3 - The Bookmark Server for Personal and Team Use.                *
 *  Copyright (C) 2004  Ondrej Brablc <http://brablc.com/mailto?o>            *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 ******************************************************************************/

/**
 * Check http://phplayersmenu.sf.net for the program using this file.
 */

header("Content-Type: text/html; charset=UTF-8");

if (@!include_once('./inc/config.inc.php'))
{
    exit;
}

require_once('./inc/tree.inc.php');
require_once('./inc/usermanager.inc.php');
require_once('./inc/page.inc.php');

class phpLayersMenu
{
    var $um;
    var $tree;
    var $nodes = array();
    var $path = '';
    var $level = 1;
    var $useHitCounter = false;

    function phpLayersMenu()
    {
        $this->um =& UserManager::staticInstance();

        if (!$this->um->getParam('config','backend_server'))
        {
            die(".|Non interactive mode not allowed by administrator!");
        }


        $this->tree =& Tree::staticInstance();

        if (reqChk('email') && reqChk('pass'))
        {
            if (!$this->um->login(reqVal('email'), reqVal('pass')))
            {
                die(".|Invalid connection string to Sitebar!");
            }
        }

        $this->useHitCounter = $this->um->getParam('config','use_hit_counter');
    }

    function run()
    {
        if (!$this->um->setupDone)
        {
            exit;
        }

        header("Content-type: text/plain");

        if (reqChk('root'))
        {
            $root = $this->tree->getNode(reqVal('root'));
            if (!$root)
            {
                die(".|Invalid folder id!");
            }

            $acl = $root->getACL();
            if (!$acl || !$acl['allow_select'])
            {
                die(".|Access denied!");
            }

            $root->level = -1;
            $this->tree->loadNodes($root);
            $this->drawChildren($root);
        }
        else
        {
            foreach ($this->tree->loadRoots() as $root)
            {
                $this->tree->loadNodes($root);
                $this->drawNode($root);
            }
        }
    }

    function drawNode($node)
    {
        array_push($this->nodes, $node->id);
        $this->path = implode('/', $this->nodes);

        $this->write(array
        (
            str_repeat('.',$node->level+$this->level),
            $node->name,
            null,
            $node->comment
        ));

        $this->drawChildren($node);

        array_pop($this->nodes);
        return true;
    }

    function drawChildren($node)
    {
        foreach ($node->getChildren() as $child)
        {
            if ($child->type_flag=='n')
            {
                $this->drawNode($child);
            }
            else
            {
                $this->path = implode('/', $this->nodes);
                $this->drawLink($child, $node->level);
            }
        }
    }

    function drawLink($link, $level)
    {
        $comment = substr(str_replace("\n"," ",$link->comment),0,1024);

        $url = $link->url;

        if (!($url{0}=='j' && strpos($url,'javascript:')!==false) && $this->useHitCounter)
        {
            $url = Page::baseurl().'/go.php?id='.$link->id.'&url='.$link->url;
        }

        if ($link->favicon
        &&  $this->um->getParam('user','use_favicons')
        &&  $this->um->getParam('config','use_favicon_cache'))
        {
            $link->favicon = Page::baseurl(). '/favicon.php?' . md5($link->favicon) . '=' . $link->id;
        }

        $this->write(array
        (
            str_repeat('.',$level+$this->level+1),
            $link->name,
            Page::quoteValue($url),
            $comment,
            $link->favicon,
        ));
    }

    function write($arr)
    {
        $str = implode('|', $arr);
        echo $str . "\n";
    }
}

/*** Run phpLayersMenu Application ********************************************/

$phplm = new phpLayersMenu();
$phplm->run();
?>
