# Note that this is NOT a relocatable package
%define prefix  /usr

Summary: Tool for easily maintaining remote web sites
Name: sitecopy
Version: 0.11.4
Release: 1
Copyright: GPL
Group: Applications/Internet
Source0: http://www.lyra.org/sitecopy/sitecopy-%{version}.tar.gz
URL: http://www.lyra.org/sitecopy/
BuildRoot: /var/tmp/sitecopy-%{version}-root

%description
sitecopy allows you to easily maintain remote Web sites.  The program
will upload files to the server which have changed locally, and delete
files from the server which have been removed locally, to keep the
remote site synchronized with the local site, with a single
command. sitecopy will also optionally try to spot files you move
locally, and move them remotely.  FTP and WebDAV servers are
supported.

%package -n xsitecopy
Summary: GUI tool for easily maintaining remote web sites
Group: X11/Applications/Networking

%description -n xsitecopy
XSitecopy is a GNOME frontend for sitecopy.  Currently it does not
support "resynch" mode, but it does have the advantage of providing
full configuration editing and creation facilities.

%prep
%setup -q

%build
# vanilla sitecopy.
mkdir sitecopy; cd sitecopy

CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ../configure \
	--prefix=%{prefix} \
	--enable-debug
make
cd ..

# xsitecopy.
mkdir xsitecopy; cd xsitecopy
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ../configure \
	--prefix=%{prefix} \
	--enable-gnomefe \
	--enable-debug
make
cd ..

%install
rm -rf $RPM_BUILD_ROOT
(cd sitecopy; make DESTDIR=$RPM_BUILD_ROOT install) || exit 1
(cd xsitecopy; make DESTDIR=$RPM_BUILD_ROOT install) || exit 1

%clean
rm -rf $RPM_BUILD_ROOT

%files -n sitecopy
%defattr(-, root, root)
%{prefix}/bin/sitecopy
%{prefix}/man/man1/*
%{prefix}/share/sitecopy
%{prefix}/share/locale/*/LC_MESSAGES/sitecopy.mo
%doc ABOUT-NLS COPYING ChangeLog FAQ INSTALL NEWS README* THANKS TODO

%files -n xsitecopy
%defattr(-, root, root)
%dir %{prefix}/share/gnome/help/xsitecopy
%dir %{prefix}/share/gnome/help/xsitecopy/C
%{prefix}/share/gnome/help/xsitecopy/C/*.html
%{prefix}/share/gnome/help/xsitecopy/C/topic.dat
%{prefix}/share/gnome/apps/Internet/*.desktop
%{prefix}/share/pixmaps/xsitecopy/*.png
%{prefix}/share/xsitecopy/sitecopy-dialogs.glade
%{prefix}/bin/xsitecopy

%changelog
* Sun Jan 13 2002 Joe Orton <joe@manyfish.co.uk>
- Use DESTDIR in make install.

* Sun Jan  6 2002 Joe Orton <joe@manyfish.co.uk>
- Add -q argument to %setup, better %description, minor cleanups.

* Sun Oct 29 2000 Joe Orton <joe@light.plus.com>
- Fix man page location (Nobuyuki Tsuchimura).

* Tue Jun 27 2000 Nobuyuki Tsuchimura <tutimura@nn.iij4u.or.jp>
- Include 'LC_MESSAGES/sitecopy.mo'.
- Don't install in %build section.
- Add more documents and '/usr/share/sitecopy/*'.
- Correct URL.

* Sat Apr 22 2000 Lee Mallabone <lee0@callnetuk.com>
- Bring up to date for latest xsitecopy stuff

* Mon Jul 26 1999 Joe Orton <joe@orton.demon.co.uk>
- Enabled debugging for sitecopy and xsitecopy.

* Fri May 28 1999 Dobrica Pavlinusic <dpavlin@foi.hr>
- integrated into GNU configure to automaticly pick up version number

* Sat Apr 3 1999 Lee Mallabone <lee0@callnetuk.com>
- After a few tweaks, it now actually works. :)

* Thu Apr 1 1999 Lee Mallabone <lee0@callnetuk.com>
- first attempt.

