/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: k2.c,v 2.0 92/07/18 12:07:09 takahasi Locked $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	k2.c,v $
 * Revision 2.0  92/07/18  12:07:09  takahasi
 * *** empty log message ***
 * 
*/
#include <stdio.h>
#include <string.h>
#include "kakasi.h"

struct k2rom_tbl {
    char kana[5];
    char romaji[7];
}
k2rom_h_table[] = { 
    " ", " ", "!", ".", "\"", "(", "#", ")", "$", ",", "%", ".", "&",
    "wo","'", "a","(", "i",")", "u","*", "e","+", "o",",", "ya","-",
    "yu",".", "yo","/", "tu","/3^", "vvu","/3^'", "vva","/3^(",
    "vvi","/3^*", "vve","/3^+", "vvo","/6", "kka","/6^", "gga","/7",
    "kki","/7,", "kkya","/7-", "kkyu","/7.", "kkyo","/7^", "ggi","/7^,",
    "ggya","/7^-", "ggyu","/7^.", "ggyo","/8", "kku","/8^", "ggu","/9",
    "kke","/9^", "gge","/:", "kko","/:^", "ggo","/;", "ssa","/;^",
    "zza","/<", "sshi","/<,", "ssha","/<-", "sshu","/<.", "ssho","/<^",
    "jji","/<^,", "jja","/<^-", "jju","/<^.", "jjo","/=", "ssu","/=^",
    "zzu","/>", "sse","/>^", "zze","/?", "sso","/?^", "zzo","/@",
    "tta","/@^", "dda","/A", "cchi","/A,", "ccha","/A-", "cchu","/A.",
    "ccho","/A^", "ddi","/A^,", "ddya","/A^-", "ddyu","/A^.", "ddyo","/B",
    "ttsu","/B^", "ddu","/C", "tte","/C^", "dde","/D", "tto","/D^",
    "ddo","/J", "hha","/J^", "bba","/J_", "ppa","/K", "hhi","/K,",
    "hhya","/K-", "hhyu","/K.", "hhyo","/K^", "bbi","/K^,", "bbya","/K^-",
    "bbyu","/K^.", "bbyo","/K_", "ppi","/K_,", "ppya","/K_-",
    "ppyu","/K_.", "ppyo","/L", "ffu","/L'", "ffa","/L(", "ffi","/L*",
    "ffe","/L+", "ffo","/L^", "bbu","/L_", "ppu","/M", "hhe","/M^",
    "bbe","/M_", "ppe","/N", "hho","/N^", "bbo","/N_", "ppo","/T",
    "yya","/U", "yyu","/V", "yyo","/W", "rra","/X", "rri","/X,",
    "rrya","/X-", "rryu","/X.", "rryo","/Y", "rru","/Z", "rre","/[",
    "rro","0", "^","1", "a","2", "i","3", "u","3^", "vu","3^'",
    "va","3^(", "vi","3^*", "ve","3^+", "vo","4", "e","5", "o","6",
    "ka","6^", "ga","7", "ki","7,", "kya","7-", "kyu","7.", "kyo","7^",
    "gi","7^,", "gya","7^-", "gyu","7^.", "gyo","8", "ku","8^", "gu","9",
    "ke","9^", "ge",":", "ko",":^", "go",";", "sa",";^", "za","<",
    "shi","<,", "sha","<-", "shu","<.", "sho","<^", "ji","<^,",
    "ja","<^-", "ju","<^.", "jo","=", "su","=^", "zu",">", "se",">^",
    "ze","?", "so","?^", "zo","@", "ta","@^", "da","A", "chi","A,",
    "cha","A-", "chu","A.", "cho","A^", "di","A^,", "dya","A^-",
    "dyu","A^.", "dyo","B", "tsu","B^", "du","C", "te","C^", "de","D",
    "to","D^", "do","E", "na","F", "ni","F,", "nya","F-", "nyu","F.",
    "nyo","G", "nu","H", "ne","I", "no","J", "ha","J^", "ba","J_",
    "pa","K", "hi","K,", "hya","K-", "hyu","K.", "hyo","K^", "bi","K^,",
    "bya","K^-", "byu","K^.", "byo","K_", "pi","K_,", "pya","K_-",
    "pyu","K_.", "pyo","L", "fu","L'", "fa","L(", "fi","L*", "fe","L+",
    "fo","L^", "bu","L_", "pu","M", "he","M^", "be","M_", "pe","N",
    "ho","N^", "bo","N_", "po","O", "ma","P", "mi","P,", "mya","P-",
    "myu","P.", "myo","Q", "mu","R", "me","S", "mo","T", "ya","U",
    "yu","V", "yo","W", "ra","X", "ri","X,", "rya","X-", "ryu","X.",
    "ryo","Y", "ru","Z", "re","[", "ro","\\", "wa","]", "n",
    "]1", "n'a", "]2", "n'i", "]3", "n'u", "]4", "n'e", "]5", "n'o",
    "^", "\"","_", "(maru)", "", ""
}, k2rom_k_table[] = { 
    " ", " ", "!", ".", "\"", "(", "#", ")", "$", ",", "%", ".", "&",
    "wo", "'", "a", "(", "i", ")", "u", "*", "e", "+", "o", ",", "ya",
    "-", "yu", ".", "yo", "/", "tsu", "/3^", "vvu", "/3^'", "vva", "/3^(",
    "vvi", "/3^*", "vve", "/3^+", "vvo", "/6", "kka", "/6^", "gga", "/7",
    "kki", "/7,", "kkya", "/7-", "kkyu", "/7.", "kkyo", "/7^", "ggi",
    "/7^,", "ggya", "/7^-", "ggyu", "/7^.", "ggyo", "/8", "kku", "/8^",
    "ggu", "/9", "kke", "/9^", "gge", "/:", "kko", "/:^", "ggo", "/;",
    "ssa", "/;^", "zza", "/<", "ssi", "/<,", "ssya", "/<-", "ssyu", "/<.",
    "ssyo", "/<^", "zzi", "/<^,", "zzya", "/<^-", "zzyu", "/<^.", "zzyo",
    "/=", "ssu", "/=^", "zzu", "/>", "sse", "/>^", "zze", "/?", "sso",
    "/?^", "zzo", "/@", "tta", "/@^", "dda", "/A", "tti", "/A,", "ttya",
    "/A-", "ttyu", "/A.", "ttyo", "/A^", "ddi", "/A^,", "ddya", "/A^-",
    "ddyu", "/A^.", "ddyo", "/B", "ttu", "/B^", "ddu", "/C", "tte", "/C^",
    "dde", "/D", "tto", "/D^", "ddo", "/J", "hha", "/J^", "bba", "/J_",
    "ppa", "/K", "hhi", "/K,", "hhya", "/K-", "hhyu", "/K.", "hhyo",
    "/K^", "bbi", "/K^,", "bbya", "/K^-", "bbyu", "/K^.", "bbyo", "/K_",
    "ppi", "/K_,", "ppya", "/K_-", "ppyu", "/K_.", "ppyo", "/L", "hhu",
    "/L'", "ffa", "/L(", "ffi", "/L*", "ffe", "/L+", "ffo", "/L^", "bbu",
    "/L_", "ppu", "/M", "hhe", "/M^", "bbe", "/M_", "ppe", "/N", "hho",
    "/N^", "bbo", "/N_", "ppo", "/T", "yya", "/U", "yyu", "/V", "yyo",
    "/W", "rra", "/X", "rri", "/X,", "rrya", "/X-", "rryu", "/X.", "rryo",
    "/Y", "rru", "/Z", "rre", "/[", "rro", "0", "^", "1", "a", "2", "i",
    "3", "u", "3^", "vu", "3^'", "va", "3^(", "vi", "3^*", "ve", "3^+",
    "vo", "4", "e", "5", "o", "6", "ka", "6^", "ga", "7", "ki", "7,",
    "kya", "7-", "kyu", "7.", "kyo", "7^", "gi", "7^,", "gya", "7^-",
    "gyu", "7^.", "gyo", "8", "ku", "8^", "gu", "9", "ke", "9^", "ge",
    ":", "ko", ":^", "go", ";", "sa", ";^", "za", "<", "si", "<,", "sya",
    "<-", "syu", "<.", "syo", "<^", "zi", "<^,", "zya", "<^-", "zyu",
    "<^.", "zyo", "=", "su", "=^", "zu", ">", "se", ">^", "ze", "?", "so",
    "?^", "zo", "@", "ta", "@^", "da", "A", "ti", "A,", "tya", "A-",
    "tyu", "A.", "tyo", "A^", "di", "A^,", "dya", "A^-", "dyu", "A^.",
    "dyo", "B", "tu", "B^", "du", "C", "te", "C^", "de", "D", "to", "D^",
    "do", "E", "na", "F", "ni", "F,", "nya", "F-", "nyu", "F.", "nyo",
    "G", "nu", "H", "ne", "I", "no", "J", "ha", "J^", "ba", "J_", "pa",
    "K", "hi", "K,", "hya", "K-", "hyu", "K.", "hyo", "K^", "bi", "K^,",
    "bya", "K^-", "byu", "K^.", "byo", "K_", "pi", "K_,", "pya", "K_-",
    "pyu", "K_.", "pyo", "L", "hu", "L'", "fa", "L(", "fi", "L*", "fe",
    "L+", "fo", "L^", "bu", "L_", "pu", "M", "he", "M^", "be", "M_", "pe",
    "N", "ho", "N^", "bo", "N_", "po", "O", "ma", "P", "mi", "P,", "mya",
    "P-", "myu", "P.", "myo", "Q", "mu", "R", "me", "S", "mo", "T", "ya",
    "U", "yu", "V", "yo", "W", "ra", "X", "ri", "X,", "rya", "X-", "ryu",
    "X.", "ryo", "Y", "ru", "Z", "re", "[", "ro", "\\", "wa", "]", "n",
    "]1", "n'a", "]2", "n'i", "]3", "n'u", "]4", "n'e", "]5", "n'o",
    "^", "\"", "_", "(maru)", "", ""};


#define k2rom_buflen 10

static int k2rom(c, n, type)
     Character *c;
     Character *n;
     int type;
{
    static int index_table[0x41];
    static int index_made=0;
    static struct k2rom_tbl *k2rom_ptr;
    struct k2rom_tbl *p;
    int i, clen, ylen;
    char buffer[k2rom_buflen];
    unsigned char c1;
    int max_match, match_more;
    char *max_romaji;

    if (index_made == 0) {
	k2rom_ptr = (romaji_type == HEPBURN) ? k2rom_h_table : k2rom_k_table;
	index_table[0] = 0;
	for (p = k2rom_ptr, i = 0; *(p->kana) != '\0'; ++ p, ++ i) {
	    index_table[*(p->kana)-0x20+1] = i+1;
	}
	index_made = 1;
    }

    buffer[k2rom_buflen] = '\0'; clen = k2rom_buflen;
    for (i = 0; i < k2rom_buflen; ++ i) {
	c1 = c[i].c1;
	if ((0 < c1) && (c1 < 0x20))
	    buffer[i] = ' ';
	else if (0x60 < c1)
	    buffer[i] = ' ';
	else
	    buffer[i] = c1;

	if (c1 == '\0') {
	    clen = i;
	    break;
	}
    }

    if (clen == 0) {
	n[0].type=OTHER;
	n[0].c1 = '\0';
	return 0;
    }

    max_match = 0;
    max_romaji = NULL;
    match_more = 0;
    for (i = index_table[buffer[0]-0x20];
	 i < index_table[buffer[0]-0x20+1];
	 ++ i) {
	ylen = strlen(k2rom_ptr[i].kana);
	if (clen >= ylen) {
	    if (max_match < ylen) {
		if (strncmp(buffer, k2rom_ptr[i].kana, ylen) == 0) {
		    max_match = ylen;
		    max_romaji = k2rom_ptr[i].romaji;
		}
	    }
	} else {
	    if (match_more == 0)
		if (strncmp(buffer, k2rom_ptr[i].kana, clen) == 0)
		    match_more = 1;
	}
    }

    for (i = 0; max_romaji[i] != '\0'; ++ i) {
	n[i].type=type;
	n[i].c1 = max_romaji[i];
    }
    n[i].type=OTHER;
    n[i].c1 = '\0';
    return (match_more == 0) ? max_match : -max_match;
}

int k2a(c, n)
     Character *c;
     Character *n;
{
    return k2rom(c, n, ASCII);
}

int k2j(c, n)
     Character *c;
     Character *n;
{
    return k2rom(c, n, JISROMAN);
}

int k2K(c, n)
     Character *c;
     Character *n;
{
    int c1;
    static unsigned char k2K_table[64][3] = {
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "" };
    static unsigned char k2K_dtable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "", "",   "",   "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };
    static unsigned char k2K_htable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   ""  , "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };

    c1 = c -> c1;
    if (c1 > 0x60) c1 = 0x20;
    if (c[1].type==KATAKANA) {
	if ((c[1].c1==0x5e) && (k2K_dtable[c1-0x20][0] != '\0')) {
	    n[0].type=JIS83;
	    n[0].c1 = k2K_dtable[c1-0x20][0];
	    n[0].c2 = k2K_dtable[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 2;
	} else if ((c[1].c1==0x5f) && (k2K_htable[c1-0x20][0] != '\0')) {
	    n[0].type=JIS83;
	    n[0].c1 = k2K_htable[c1-0x20][0];
	    n[0].c2 = k2K_htable[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 2;
	} else {
	    n[0].type=JIS83;
	    n[0].c1 = k2K_table[c1-0x20][0];
	    n[0].c2 = k2K_table[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 1;
	}
    } else {
	n[0].type=JIS83;
	n[0].c1 = k2K_table[c1-0x20][0];
	n[0].c2 = k2K_table[c1-0x20][1];
	n[1].type=OTHER; n[1].c1 = '\0';
	if (k2K_dtable[c1-0x20][0] == '\0')
	    return 1;
	else
	    return -1;
    }
}
    
int k2H(c, n)
     Character *c;
     Character *n;
{
    int c1;
    static unsigned char k2H_table[64][3] = {
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "" };
    static unsigned char k2H_dtable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };
    static unsigned char k2H_htable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   ""  , "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };

    c1 = c -> c1;
    if (c1 > 0x60) c1 = 0x20;
    if (c[1].type==KATAKANA) {
	if ((c[1].c1==0x5e) && (k2H_dtable[c1-0x20][0] != '\0')) {
	    n[0].type=JIS83;
	    n[0].c1 = k2H_dtable[c1-0x20][0];
	    n[0].c2 = k2H_dtable[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 2;
	} else if ((c[1].c1==0x5f) && (k2H_htable[c1-0x20][0] != '\0')) {
	    n[0].type=JIS83;
	    n[0].c1 = k2H_htable[c1-0x20][0];
	    n[0].c2 = k2H_htable[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 2;
	} else {
	    n[0].type=JIS83;
	    n[0].c1 = k2H_table[c1-0x20][0];
	    n[0].c2 = k2H_table[c1-0x20][1];
	    n[1].type=OTHER; n[1].c1 = '\0';
	    return 1;
	}
    } else {
	n[0].type=JIS83;
	n[0].c1 = k2H_table[c1-0x20][0];
	n[0].c2 = k2H_table[c1-0x20][1];
	n[1].type=OTHER; n[1].c1 = '\0';
	if (k2H_dtable[c1-0x20][0] == '\0')
	    return 1;
	else
	    return -1;
    }
}
