package SliMP3::Buttons::MoodWheel;

# license bla

use strict;
use SliMP3::Buttons::Common;
use SliMP3::MoodLogic;
use SliMP3::Strings qw (string);

# 
my @browseMoodChoices = ();

my %functions = (
	
	'up' => sub  {
		my $client = shift;
                my $count = scalar @browseMoodChoices;
                
		if ($count < 2) {
			SliMP3::Animation::bumpUp($client);
		} else {
                    my $newposition = SliMP3::Buttons::Common::scroll($client, -1, ($#browseMoodChoices + 1), selection($client, 'mood_wheel_index'));
                    setSelection($client, 'mood_wheel_index', $newposition);
                    SliMP3::Display::update($client);
		}
	},
	
	'down' => sub  {
		my $client = shift;
		my $count = scalar @browseMoodChoices;

		if ($count < 2) {
			SliMP3::Animation::bumpDown($client);
		} else {
                    my $newposition = SliMP3::Buttons::Common::scroll($client, +1, ($#browseMoodChoices + 1), selection($client, 'mood_wheel_index'));
                    setSelection($client, 'mood_wheel_index', $newposition);
                    SliMP3::Display::update($client);
		}
	},
	
	'left' => sub  {
		my $client = shift;
		SliMP3::Buttons::Common::popModeRight($client);
	},
	
	'right' => sub  {
		my $client = shift;
	
		my @oldlines = SliMP3::Display::curLines($client);
		SliMP3::Buttons::Common::pushMode($client, 'moodlogic_instant_mix', {'genre' => SliMP3::Buttons::Common::param($client, 'genre'), 'artist' => SliMP3::Buttons::Common::param($client, 'artist'), 'mood' => $browseMoodChoices[selection($client, 'mood_wheel_index')]});
		
		if (SliMP3::Prefs::get('animationLevel') == 3) {
                    SliMP3::Buttons::InstantMix::specialPushLeft($client, 0, @oldlines);
		} else {
                    SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
		}
	}
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;
	my $push = shift;

	if (defined SliMP3::Buttons::Common::param($client, 'genre')) {
            @browseMoodChoices = SliMP3::MoodLogic::getMoodWheel(SliMP3::Info::moodLogicGenreId(SliMP3::Buttons::Common::param($client, 'genre')), 'genre');
	} elsif (defined SliMP3::Buttons::Common::param($client, 'artist')) {
	    @browseMoodChoices = SliMP3::MoodLogic::getMoodWheel(SliMP3::Info::moodLogicArtistId(SliMP3::Buttons::Common::param($client, 'artist')), 'artist');
	} else {
	    die 'no/unknown type specified for mood wheel';
	}

        if ($push eq "push") {
            setSelection($client, 'mood_wheel_index', 0);
        } 
    
	$client->lines(\&lines);
}

#
# figure out the lines to be put up to display
#
sub lines {
	my $client = shift;
	my ($line1, $line2);

	$line1 = string('MOODLOGIC_SELECT_MOOD');
	$line1 .= sprintf(" (%d ".string('OUT_OF')." %s)", selection($client, 'mood_wheel_index') + 1, scalar @browseMoodChoices);	
	$line2 = $browseMoodChoices[selection($client, 'mood_wheel_index')];

	return ($line1, $line2, undef, SliMP3::VFD::symbol('rightarrow'));
}

#	get the current selection parameter from the parameter stack
sub selection {
	my $client = shift;
	my $index = shift;

	my $value = SliMP3::Buttons::Common::param($client, $index);

	if (defined $value  && $value eq '__undefined') {
		undef $value;
	}

	return $value;
}

#	set the current selection parameter from the parameter stack
sub setSelection {
	my $client = shift;
	my $index = shift;
	my $value = shift;

	if (!defined $value) {
		$value = '__undefined';
	}

	SliMP3::Buttons::Common::param($client, $index, $value);
}

1;

__END__
