/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef _SLPIM_ABASE_H
#define _SLPIM_ABASE_H

#include "defs.h"

extern listitem *dirstack;
extern dyntab *dircont;
extern char *ABASE_ERROR;

/* returns:                                 *
 *  -1 - entry/database doesn't exist       *
 *   0 - if entry is an ordinary entry, or  *
 *   1 - if entry is a directory, or        *
 *   2 - if entry is a special entry, or    *
 *   3 - if entry has non-valid ID.         */
extern int slpim_ABASE_get_record_status(char *name);

extern void slpim_ABASE_dir_save(char *name, dyntab *cont);

/* if name == NULL just free the dynamic table */
extern int slpim_ABASE_dir_load(char *name, dyntab **cont);

extern char *slpim_ABASE_dir_name(char *dir);

extern int slpim_ABASE_dir_rename(char *key, char *name);

extern int slpim_ABASE_dir_enter(char *dir);

extern void slpim_ABASE_dir_up(void);

extern char *slpim_ABASE_fetch_field(char *key, int field);

extern int slpim_ABASE_store_field(char *key, int field, char *val);

extern char *slpim_ABASE_add_record(char *dir);

/* this is universal record/dir remove function */
extern int slpim_ABASE_rm_record(char *key, char *dir);

extern char *slpim_ABASE_mkdir(char *dir, char *name);

extern int slpim_ABASE_sort(char *dir, int field);

/* if dir == NULL - search in current dir */
extern int slpim_ABASE_find(char *dir, char *patt, int field, int start, int isnext);

extern dyntab *slpim_ABASE_query(char *patt, int field);

extern int slpim_ABASE_open(void);

extern void slpim_ABASE_close(void);

#endif

