/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <curses.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "defs.h"
#include "screen.h"
#include "abase.h"

char *FSTRING2, *FSTRING3; /* format strings */

WINDOW *abook_window;
int abook_win_size, abook_cbar, abook_offset;
char *abook_s_pattern;
char *redit_cur_key;
dyntab *redit_cur_record;
dyntab *abook_current_dir;

int slpim_abook_win_refresh(void) {
	char *s;
		
	if(abook_window != NULL)
		prefresh(abook_window, abook_offset, 0, 2, 0, LINES - 3, COLS);
	
	attrset(AB_HEAD_COLOR);
	s = malloc(COLS);
	/* FIXME */
	snprintf(s, COLS, FSTRING3, "Name:", "Email:", "Organization:");
	mvaddstr(1, 0, s);
	free(s);
	clrtoeol();
	move(1, 0);
	chgat(COLS, AB_HEAD_COLOR, PAIR_NUMBER(AB_HEAD_COLOR), NULL);
	attrset(NORM_COLOR);
	move(LINES - 1, COLS - 1);
	return(0);
}

int slpim_abook_win_mov_cbar(int mov) {
	int i;

	i = abook_cbar + mov;
	if((i < 0)||(i >= abook_win_size))
		i = abook_cbar;

	if((mov < 0)&&(i < abook_offset + 2))
		abook_offset = i ? i - 1 : 0;

	if(mov >=0) {
		if(i > abook_offset + LINES - 6)
			abook_offset = i + 6 - LINES;
		if(i > abook_win_size - 2)
			abook_offset = abook_win_size + 4 - LINES;
	}

	wmove(abook_window, abook_cbar, 0);
	wchgat(abook_window, COLS, NORM_COLOR, PAIR_NUMBER(NORM_COLOR), NULL);
	wmove(abook_window, i, 0);
	wchgat(abook_window, COLS, CURSORBAR_COLOR, PAIR_NUMBER(CURSORBAR_COLOR), NULL);
	abook_cbar = i;
	return(0);
}

int slpim_abook_win_reload(int cur) {
	char *s, *t, *u, *v;
	int i, a;

	slpim_ABASE_dir_load(dirstack->name, &abook_current_dir);
	if(abook_window != NULL)
		delwin(abook_window);
	abook_win_size = abook_current_dir->i;
	clear();
	abook_window = newpad(abook_win_size ? abook_win_size : 1, COLS);
	wmove(abook_window, 0, 0);
	for(i = 0; i < abook_current_dir->i; i++) {
		a = slpim_ABASE_get_record_status(abook_current_dir->ent[i]);
		switch(a) {
			case 1:
				t = slpim_ABASE_dir_name(abook_current_dir->ent[i]);
				s = malloc(COLS);
				u = malloc(11);
				snprintf(u, 11, "[+] %%-%3ds", COLS - 4);
				snprintf(s, COLS, u, t);
				mvwaddstr(abook_window, i, 0, s);
				free(u);
				free(s);
				free(t);
				break;
			case 0: 
				t = slpim_ABASE_fetch_field(abook_current_dir->ent[i], FIELD_NAME);
				u = slpim_ABASE_fetch_field(abook_current_dir->ent[i], FIELD_EMAIL);
				v = slpim_ABASE_fetch_field(abook_current_dir->ent[i], FIELD_ORG);
				s = malloc(COLS);
				/* FIXME */
				snprintf(s, COLS, FSTRING3, t, u, v);
				mvwaddstr(abook_window, i, 0, s);
				free(s);
				free(t);
				free(u);
				free(v);
				break;
			default:
		}
	}
	if(!cur) {
		abook_cbar = 0;
		abook_offset = 0;
	}
	slpim_abook_win_mov_cbar(0);
	return(0);
}

/* record editor code */

int slpim_redit_refresh(void) {
	char *s;

	if(abook_window != NULL)
		prefresh(abook_window, abook_offset, 0, 2, 0, LINES - 3, COLS);
	attrset(AB_HEAD_COLOR);
	s = malloc(COLS);
	snprintf(s, COLS, FSTRING2, "Field:", "Content:");
	mvaddstr(1, 0, s);
	clrtoeol();
	move(0, 0);
	chgat(COLS, AB_HEAD_COLOR, PAIR_NUMBER(AB_HEAD_COLOR), NULL);
	attrset(NORM_COLOR);
	move(COLS - 1, LINES - 1);
	return(0);
}

int slpim_redit_rewin(void) {
	char *s, *z;
	int i;

	if(abook_window != NULL)
		delwin(abook_window);
	abook_win_size = ABOOK_FIELDS_NO;
	clear();
	abook_window = newpad(abook_win_size ? abook_win_size : 1, COLS);
	wmove(abook_window, 0, 0);
	s = malloc(COLS);
	for(i = 0; i < ABOOK_FIELDS_NO; i++) {
		z = malloc(strlen(ABOOK_FIELD_NAMES->ent[i]) + 2);
		strcpy(z, ABOOK_FIELD_NAMES->ent[i]);
		strcat(z, ":");
		snprintf(s, COLS, FSTRING2, z, redit_cur_record->ent[i]);
		free(z);
		mvwaddstr(abook_window, i, 0, s);
	}
	slpim_abook_win_mov_cbar(0);
	return(0);
}

int slpim_redit_init(void) {
	abook_offset = 0;
	abook_cbar = 0;
	slpim_redit_rewin();

	slpim_string_top = " enter:Edit field  c:Clear field  q:Quit&Save  x:Discard";
	slpim_string_bot = "record editor **";
	return(0);
}

int slpim_redit_clear(void) {
	int i;
	
	i = slpim_input_yesno(" Are you sure?", 0);
	if(i) {
		redit_cur_record->ent[abook_cbar] = "";
		slpim_write_message("Field deleted.", INFO_MESSAGE);
		slpim_redit_rewin();
	}
	return(0);
}

int slpim_redit_edit(void) {
	char *s, *z;

	z = malloc(strlen(ABOOK_FIELD_NAMES->ent[abook_cbar]) + 11);
	strcpy(z, "Enter new ");
	strcat(z, ABOOK_FIELD_NAMES->ent[abook_cbar]);
	s = slpim_input_read(z, redit_cur_record->ent[abook_cbar]);
	free(z);
	if(strcmp(s, redit_cur_record->ent[abook_cbar])) {
		free(redit_cur_record->ent[abook_cbar]);
		redit_cur_record->ent[abook_cbar] = s;
		slpim_write_message("Field changed.", INFO_MESSAGE);
		slpim_redit_rewin();
	} else {
		free(s);
		slpim_write_message("Change cancelled.", INFO_MESSAGE);
	}
	return(0);
}

int slpim_redit_main(char *k) {
	int i, q, old_ao, old_ac;
	char *s;

	old_ao = abook_offset;
	old_ac = abook_cbar;

	if(k == NULL) {
		redit_cur_key = abook_current_dir->ent[abook_cbar];
	} else
		redit_cur_key = k;

	redit_cur_record = malloc(sizeof(dyntab));
	redit_cur_record->ent = malloc(ABOOK_FIELDS_NO * sizeof(char*));
	redit_cur_record->i = ABOOK_FIELDS_NO;
	for(i = 0; i < ABOOK_FIELDS_NO; i++)
		redit_cur_record->ent[i] = slpim_ABASE_fetch_field(redit_cur_key, i);
	
	slpim_redit_init();

	q = 0;
	while(!q) {
		slpim_screen_refresh();
		slpim_redit_refresh();
		i = getch();
		switch(i) {
			case 'c':
				slpim_redit_clear();
				break;
			case KEY_DOWN:
				slpim_abook_win_mov_cbar(1);
				break;
			case KEY_UP:
				slpim_abook_win_mov_cbar(-1);
				break;
			case KEY_RIGHT:
			case 13:
				slpim_redit_edit();
				break;
			case KEY_LEFT:
			case 'q':
				q = 1;
				break;
			case 'x':
				q = 2;
				break;
			default:
		}
	}

	if(q == 1) {
		slpim_write_message("Record changes saved.", INFO_MESSAGE);
		for(i = 0; i < ABOOK_FIELDS_NO; i++) {
			if(redit_cur_record->ent[i] != NULL) {
				s = (*(redit_cur_record->ent[i]) == 0) ? NULL : redit_cur_record->ent[i];
			} else
				s = NULL;
			slpim_ABASE_store_field(redit_cur_key, i, s);
		}
	} else
		slpim_write_message("Record changes NOT saved.", INFO_MESSAGE);
	
	for(i = 0; i < ABOOK_FIELDS_NO; i++)
		free(redit_cur_record->ent[i]);
	free(redit_cur_record->ent);
	free(redit_cur_record);
	clear();
	abook_offset = old_ao;
	abook_cbar = old_ac;
	return(0);
}

/* end of redit code */

int slpim_abook_init(void) {
	slpim_string_top = " q:Quit  enter:Edit  a:Add  r:Remove  /:Search  n:NxtSrch  s:Sort";
	slpim_string_bot = "addressbook module **";
	return(0);
}

int slpim_abook_mailto(void) {
	char *n, *e, *s;
	int i;

	if(dircont->i == 0)
		return(1);

	n = slpim_ABASE_fetch_field(abook_current_dir->ent[abook_cbar], FIELD_NAME);
	e = slpim_ABASE_fetch_field(abook_current_dir->ent[abook_cbar], FIELD_EMAIL);
	delwin(abook_window);
	endwin();
	/* FIXME - this isn't nicest way to do it, but it's working... */
	i = strlen(MAILER) + strlen(n) + strlen(e) + 7;
	s = malloc(i);
	snprintf(s, i, "%s '%s <%s>'", MAILER, n, e);
	system(s);
	free(s);
	free(n);
	free(e);
	slpim_screen_init();
	slpim_abook_init();
	slpim_abook_win_reload(1);
	return(0);
}

int slpim_abook_page_down(void) {
	int i;
	
	i = (abook_cbar + LINES - 5 < abook_win_size) ? abook_cbar + LINES - 5 : abook_win_size - 1;
	slpim_abook_win_mov_cbar(i - abook_cbar);
	return(0);
}

int slpim_abook_page_up(void) {
	int i;

	i = (abook_cbar - LINES + 5 >= 0) ? abook_cbar - LINES + 5 : 0;
	slpim_abook_win_mov_cbar(i - abook_cbar);
	return(0);
}

int slpim_abook_enter(void) {
	char *k, *s, *t;

	if(dircont->i == 0)
		return(1);

	k = abook_current_dir->ent[abook_cbar];
	switch(slpim_ABASE_get_record_status(k)) {
		case 1:
			slpim_ABASE_dir_enter(k);
			slpim_abook_win_reload(0);
			t = slpim_ABASE_dir_name(dirstack->name);
			s = malloc(strlen(t) + 22);
			strcpy(s, "Changed directory to ");
			strcat(s, t);
			free(t);
			slpim_write_message(s, INFO_MESSAGE);
			free(s);
			break;
		case 0:
			slpim_redit_main(NULL);
			slpim_abook_init();
			slpim_abook_win_reload(1);
			break;
		default:
	}
	return(0);
}

int slpim_abook_dir_up(void) {
	char *s, *t;
	
	if(dirstack->next == NULL) {
		slpim_write_message("Can't change dir to previous - already in rootdir.", WARN_MESSAGE);
		return(1);
	}
	slpim_ABASE_dir_up();
	slpim_abook_win_reload(0);
	if(dirstack->next != NULL) {
		t = slpim_ABASE_dir_name(dirstack->name);
		s = malloc(strlen(t) + 22);
		strcpy(s, "Changed directory to ");
		strcat(s, t);
		free(t);
		slpim_write_message(s, INFO_MESSAGE);
		free(s);
	} else
		slpim_write_message("Changed directory to rootdir.", INFO_MESSAGE);
		
	return(0);
}

int slpim_abook_mkdir(void) {
	char *n;

	n = slpim_input_read(" Enter dir name", NULL);
	if(*n == 0) {
		slpim_write_message("Cancelled.", INFO_MESSAGE);
		return(0);
	}
	slpim_ABASE_mkdir(NULL, n);
	free(n);
	slpim_write_message("New directory created.", INFO_MESSAGE);
	slpim_abook_win_reload(1);
	return(0);
}

int slpim_abook_dir_rename(void) {
	char *n, *o;

	if(dircont->i == 0)
		return(1);

	if(slpim_ABASE_get_record_status(abook_current_dir->ent[abook_cbar]) == 1) {
		o = slpim_ABASE_dir_name(abook_current_dir->ent[abook_cbar]);
		n = slpim_input_read(" Enter dir's new name", o);
		if(strcmp(o, n)) {
			slpim_ABASE_dir_rename(abook_current_dir->ent[abook_cbar], n);
			slpim_write_message("Directory name changed", INFO_MESSAGE);
			slpim_abook_win_reload(1);
		} else
			slpim_write_message("Directory name change cancelled.", INFO_MESSAGE);
		free(o);
		free(n);
	} else
		slpim_write_message("Entry is not directory.", WARN_MESSAGE);
	return(0);
}

int slpim_abook_rm(void) {
	int i;
	
	if(dircont->i == 0)
		return(1);

	i = slpim_input_yesno(" Are you sure?", 0);
	if(i) {
		slpim_ABASE_rm_record(abook_current_dir->ent[abook_cbar], NULL);
		if(abook_cbar == abook_win_size - 1)
			abook_cbar--;
		slpim_write_message("Entry removed.", INFO_MESSAGE);
		slpim_abook_win_reload(1);
	}
	return(0);
}

int slpim_abook_add(void) {
	char *k;

	k = slpim_ABASE_add_record(NULL);
	slpim_write_message("New record created.", INFO_MESSAGE);
	slpim_redit_main(k);
	free(k);
	slpim_abook_init();
	slpim_abook_win_reload(1);
	return(0);
}


int slpim_abook_sort(void) {
	slpim_ABASE_sort(NULL, FIELD_NAME);
	slpim_abook_win_reload(0);
	return(0);
}

int slpim_abook_search(void) {
	int i;

	abook_s_pattern = slpim_input_read(" Search for (regexp)", NULL);
	if(abook_s_pattern != NULL) {
		if(*abook_s_pattern == 0)
			return(0);
	} else
		return(0);

	i = slpim_ABASE_find(NULL, abook_s_pattern, FIELD_NAME, abook_cbar, 0);
	if(i > -1)
		slpim_abook_win_mov_cbar(i - abook_cbar);
	
	if(i == -2) {
		slpim_write_message(ABASE_ERROR, ERROR_MESSAGE);
		free(ABASE_ERROR);
		beep();
	}

	if(i == -1)
		slpim_write_message("Pattern not found.", INFO_MESSAGE);
	
	free(abook_s_pattern);

	return(0);
}
		
int slpim_abook_search_next(void) {
	int i;

	i = slpim_ABASE_find(NULL, NULL, FIELD_NAME, abook_cbar, 1);
	if(i > -1)
		slpim_abook_win_mov_cbar(i - abook_cbar);
	
	if(i == -2) {
		slpim_write_message(ABASE_ERROR, ERROR_MESSAGE);
		free(ABASE_ERROR);
		beep();
	}

	if(i == -1)
		slpim_write_message("Pattern not found.", INFO_MESSAGE);
	
	return(0);
}

int slpim_abook_mutt_query(char *patt) {
	char *n, *e, *s, *e1;
	dyntab *t;
	int i;

	slpim_ABASE_open();

	if(patt != NULL) {
		if(*patt == 0)
			patt = ".";
	} else
		patt = ".";

	t = slpim_ABASE_query(patt, FIELD_NAME);
	if(ABASE_ERROR) {
		printf("slPIM error: %s\n", ABASE_ERROR);
		free(ABASE_ERROR);
		return(1);
	}
	
	printf("[slPIM] Results of query\n");

	for(i = 0; i < t->i; i++) {
		n = slpim_ABASE_fetch_field(t->ent[i], FIELD_NAME);
		e = slpim_ABASE_fetch_field(t->ent[i], FIELD_EMAIL);
		s = slpim_ABASE_fetch_field(t->ent[i], FIELD_NICK);
		e1 = e;
		if(e != NULL) {
			if(*e == 0)
				e1 = ".";
		} else
			e1 = ".";
		printf("%s\t%s\t%s\n", e1, n, s);
		free(n);
		free(e);
		free(s);
	}

	slpim_ABASE_dir_load(NULL, &t);

	slpim_ABASE_close();

	return(0);
}
	
int slpim_abook_main(void) {
	int q, c;

	slpim_ABASE_open();
	
	/* initialize common format strings... */
	FSTRING2 = malloc(13);
	snprintf(FSTRING2, 13, "%%-%2ds %%-%3ds", FC_WIDTH, COLS - FC_WIDTH - 1);
	
	FSTRING3 = malloc(19);
	snprintf(FSTRING3, 19, "%%-%2ds %%-%2ds %%-%3ds", FC_WIDTH, SC_WIDTH, COLS - FC_WIDTH - SC_WIDTH - 2);
	
	abook_current_dir = NULL;
	slpim_abook_win_reload(0);

	slpim_abook_init();
	slpim_write_message("Welcome to slPIM's addressbook. Press '?' for help.", INFO_MESSAGE);
	/* TODO - helpscreen */

	abook_s_pattern = NULL;

	q = 0;
	while(!q) {
		slpim_screen_refresh();
		slpim_abook_win_refresh();
		c = getch();
		switch(c) {
			case 'q':
				q = 1;
				break;
			case 'm':
				slpim_abook_mailto();
				break;
			case 'd':
				slpim_abook_mkdir();
				break;
			case 'c':
				slpim_abook_dir_rename();
				break;
			case 'r':
				slpim_abook_rm();
				break;
			case 'a':
				slpim_abook_add();
				break;
			case KEY_NPAGE:
				slpim_abook_page_down();
				break;
			case KEY_PPAGE:
				slpim_abook_page_up();
				break;
			case KEY_DOWN:
				slpim_abook_win_mov_cbar(1);
				break;
			case KEY_UP:
				slpim_abook_win_mov_cbar(-1);
				break;
			case KEY_LEFT:
			case 'u':
				slpim_abook_dir_up();
				break;
			case KEY_RIGHT:
			case 13:
				slpim_abook_enter();
				break;
			case 's':
				slpim_abook_sort();
				break;
			case '/':
				slpim_abook_search();
				break;
			case 'n':
				slpim_abook_search_next();
				break;
			default:
		}
	}
	slpim_ABASE_close();
	if (abook_window)
		delwin(abook_window);
	clear();
	free(FSTRING2);
	free(FSTRING3);
	return(0);
}

