/***************************************************************************
                          smb4kbookmarkhandler  -  description
                             -------------------
    begin                : Fr Jan 9 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// KDE includes
#include <kstandarddirs.h>

// application specific includes
#include "smb4kbookmarkhandler.h"
#include "smb4kdefs.h"


Smb4KBookmarkHandler::Smb4KBookmarkHandler( QObject *parent, const char *name ) : QObject( parent, name )
{
  // First we need the directory.
  KStandardDirs *stddir = new KStandardDirs();
  QString dir = locateLocal( "appdata", QString::null, KGlobal::instance() );
  
  if ( !stddir->exists( dir ) )
  {
    stddir->makeDir( dir );
  }

  delete stddir;
    
  // Do not use the KConfig object, that is provided by kapp->config().
  // We want a separate one for the passwords.
  m_config = new KConfig( "bookmarks", false, true, "appdata" );

  loadBookmarks();
}


Smb4KBookmarkHandler::~Smb4KBookmarkHandler()
{
  writeBookmarkList( m_bookmarks );
  
  m_bookmarks.clear();
}


/****************************************************************************
   Writes the bookmark to the bookmark file, too.
****************************************************************************/

void Smb4KBookmarkHandler::addBookmark( Smb4KBookmark *bookmark )
{
  if ( bookmark->getType() == "Printer" )
  {
    emit error( ERROR_WRONG_BOOKMARK_TYPE );
    return;
  }
  
  for ( QValueList<Smb4KBookmark *>::ConstIterator it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
  {
    if( (*it)->getShare().upper() == bookmark->getShare().upper() )
    {
      //already exists
      return;
    }
  }

  m_bookmarks.append( bookmark );
  qHeapSort( m_bookmarks.end(), m_bookmarks.begin() );
  writeBookmarkList( m_bookmarks );
}


/****************************************************************************
   Writes a new list of bookmarks to the bookmark file.
****************************************************************************/

void Smb4KBookmarkHandler::writeBookmarkList( const QValueList<Smb4KBookmark *> &list )
{
  if ( list != m_bookmarks )
  {
    m_bookmarks = list;
  }
  
  clear();
  
  m_config->setGroup( "Bookmarks" );
  int i = 0;
  
  for ( QValueListConstIterator<Smb4KBookmark *> it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
  {
    m_config->writeEntry( QString( "%1" ).arg( i++ ), (*it)->getShare() );
  }
  
  m_config->sync();
  
  emit bookmarksUpdated();
}


/****************************************************************************
   Load the bookmarks.
****************************************************************************/

void Smb4KBookmarkHandler::loadBookmarks()
{
  if ( !m_bookmarks.isEmpty() )
  {
    m_bookmarks.clear();
  }
  
  m_config->setGroup( "Bookmarks" );

  for ( int index = 0; ; index++ )
  {
    QString bookmark = m_config->readEntry( QString( "%1" ).arg( index ), QString::null ).stripWhiteSpace();
    
    if ( !bookmark.isEmpty() )
    {
      m_bookmarks.append( new Smb4KBookmark( bookmark, QString::null ) );
    }
    else
    {
      break;
    }
  }

  qHeapSort( m_bookmarks.end(), m_bookmarks.begin() );
  
  emit bookmarksUpdated();
}


/****************************************************************************
   Clears the list of bookmarks.
****************************************************************************/

void Smb4KBookmarkHandler::clear()
{
  m_config->deleteGroup( "Bookmarks" );
  m_config->sync();
  
  emit bookmarksUpdated();
}

#include "smb4kbookmarkhandler.moc"
