/***************************************************************************
                          smb4kprintdialog  -  description
                             -------------------
    begin                : So Apr 11 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KPRINTDIALOG_H
#define SMB4KPRINTDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// Qt includes
#include <qstring.h>

// KDE includes
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <knuminput.h>

 
/**
 * This class provides the print dialog.
 */
 
class Smb4KPrintDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
    /**
     * The constructor
     */
    Smb4KPrintDialog( const QString &workgroup, const QString &host, const QString &ip, const QString &printer, const QString &comment, QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KPrintDialog();
    
  protected slots:
    /**
     * Reimplemented from KDialogBase.
     */
    void slotOk();
      
  private:
    /**
     * Holds the workgroup.
     */
    QString m_workgroup;
    /**
     * Holds the host.
     */
    QString m_host;
    /**
     * Holds the IP address.
     */
    QString m_ip;
    /**
     * Holds the printer name.
     */
    QString m_printer;
    /**
     * The URL requester object, that is needed to specify the
     * the file to print.
     */
    KURLRequester *m_input;
    /**
     * Sets the number of copies the user wants to have.
     */
    KIntNumInput *m_copies;
};

#endif
