/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qtabwidget.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4ksambaoptions.h"


Smb4KSambaOptions::Smb4KSambaOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );
  
  //
  // The tab for general options.
  //
  QWidget *general_tab = new QWidget( this, "SambaGeneralTab" );
  QGridLayout *grid1 = new QGridLayout( general_tab );
  grid1->setSpacing( 10 );

  QGroupBox *general_options = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "General Options" ), general_tab );
  general_options->setInsideSpacing( 10 );

  new QLabel( i18n( "NetBIOS name:" ), general_options );
  m_netbios = new KLineEdit( QString::null, general_options );

  new QLabel( i18n( "Socket options:" ), general_options );
  m_sockopt = new KLineEdit( QString::null, general_options );

  new QLabel( i18n( "Scope (Read manual page first.):" ), general_options );
  m_scope = new KLineEdit( QString::null, general_options );

  new QLabel( i18n( "Remote SMB port:" ), general_options );
  m_port = new KIntNumInput( 139, general_options );
  // Set the port range:
  m_port->setMinValue( 0 );
  m_port->setMaxValue( 65535 );

  QButtonGroup *active_directory = new QButtonGroup( 1, QGroupBox::Horizontal, i18n( "Active Directory" ), general_tab );
  active_directory->setInsideSpacing( 10 );
  m_krb = new QCheckBox( i18n( "Try to authenticate with Kerberos." ), active_directory );
  
  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  grid1->addWidget( general_options, 0, 0, 0 );
  grid1->addWidget( active_directory, 1, 0, 0 );
  grid1->addItem( spacer1, 2, 0 );
  
  addTab( general_tab, i18n( "General" ) );

  
  //
  // Tab for mount options.
  //
  QWidget *mount_tab = new QWidget( this, "SambaMountTab" );
  QGridLayout *grid2 = new QGridLayout( mount_tab );
  grid2->setSpacing( 10 );

  QGroupBox *user_group = new QGroupBox( 2, Qt::Horizontal, i18n( "User and Group" ), mount_tab );
  user_group->setInsideSpacing( 10 );
  new QLabel( i18n( "Set the UID to:" ), user_group );
  m_uid = new KComboBox( user_group );
  m_uid->insertItem( i18n( "default" ) );
  new QLabel( i18n( "Set the GID to:" ), user_group );
  m_gid = new KComboBox( user_group );
  m_gid->insertItem( i18n( "default" ) );
  
  QGroupBox *charset_codepage = new QGroupBox( 2, Qt::Horizontal, i18n( "Charset and Codepage" ), mount_tab, "SambaCharsetCodepage" );
  charset_codepage->setInsideSpacing( 10 );
  new QLabel( i18n( "Linux charset:" ), charset_codepage );
  m_charset = new KComboBox( charset_codepage );
  QStringList charsets;
  charsets << "iso8859-1" << "iso8859-2" << "iso8859-3" << "iso8859-4" << "iso8859-5" << "iso8859-6" << "iso8859-7" << "iso8859-8" << "iso8859-9" << "iso8859-13" << "iso8859-14" << "iso8859-15" << "koi8-r" << "koi8-u" << "koi8-ru" << "cp1251" << "utf8" << "gb2312" << "big5" << "euc-jp" << "euc-kr" << "tis-620";
  charsets.sort();
  m_charset->insertItem( i18n( "default" ) );
  m_charset->insertStringList( charsets );
  new QLabel( i18n( "Server codepage:" ), charset_codepage );
  m_codepage = new KComboBox( charset_codepage );
  QStringList codepages;
  codepages << "cp437" << "cp737" << "cp775" << "cp850" << "cp852" << "cp855" << "cp857" << "cp860" << "cp861" << "cp862" << "cp863" << "cp864" << "cp865" << "cp866" << "cp869" << "cp936" << "cp950" << "cp932" << "cp874" << "cp1255" << "cp1250" << "cp1251" << "cp1252" << "cp1253" << "cp1254" << "cp1256" << "cp1257" << "cp1258" << "cp949" << "cp932" << "cp720" << "cp858";
  codepages.sort();
  m_codepage->insertItem( i18n( "default" ) );
  m_codepage->insertStringList( codepages );  
 
  QButtonGroup *permissions = new QButtonGroup( 2, Qt::Horizontal, i18n( "Permissions" ), mount_tab );
  permissions->setInsideSpacing( 10 );
  new QLabel( i18n( "File mask:" ), permissions );
  m_fmask = new KLineEdit( QString::null, permissions );
  m_fmask->setAlignment( Qt::AlignRight );
  new QLabel( i18n( "Directory mask:" ), permissions );
  m_dmask = new KLineEdit( QString::null, permissions );
  m_dmask->setAlignment( Qt::AlignRight );
  new QLabel( i18n( "Mount shares:" ), permissions );
  m_rw = new QRadioButton( i18n( "read-write" ), permissions );
  permissions->addSpace( 0 );
  m_ro = new QRadioButton( i18n( "read-only" ), permissions );

  QGroupBox *mount_misc = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), mount_tab );
  mount_misc->setInsideSpacing( 10 );
  QWidget *buffer = new QWidget( mount_misc );
  QGridLayout *buffer_grid = new QGridLayout( buffer );
  buffer_grid->setSpacing( 10 );
  QLabel *ttlLabel = new QLabel( i18n( "Caching time of directory listings:" ), buffer, "SambaCachingTime" );
  m_ttl = new KIntNumInput( 1000, buffer );
  m_ttl->setSuffix( " ms" );
  m_ttl->setMinValue( 0 );
  buffer_grid->addWidget( ttlLabel, 0, 0, 0 );
  buffer_grid->addWidget( m_ttl, 0, 1, 0 );
  m_unicode = new QCheckBox( i18n( "Use unicode when communicating with the server." ), mount_misc );
  m_lfs = new QCheckBox( i18n( "Use large filesystem support." ), mount_misc );
  m_rsize = new QCheckBox( i18n( "Use default network read size." ), mount_misc );
  m_wsize = new QCheckBox( i18n( "Use default network write size." ), mount_misc );
  
  QButtonGroup *filesystem = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "File System" ), mount_tab );
  new QLabel( i18n( "Use the following file system for mounting remote shares:" ), filesystem );
  m_smbfs = new QRadioButton( i18n( "SMBFS (default)" ), filesystem );
  m_smbfs->setChecked( true );
  m_cifs = new QRadioButton( i18n( "CIFS" ), filesystem );
  QLabel *note = new QLabel( i18n( "If you choose the CIFS file system, you might need super user privileges to execute the mount command." ), filesystem );
  note->setTextFormat( QLabel::RichText );
  
  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid2->addMultiCellWidget( user_group, 0, 1, 0, 0, 0 );
  grid2->addMultiCellWidget( charset_codepage, 2, 3, 0, 0, 0 );
  grid2->addMultiCellWidget( permissions, 4, 4, 0, 0, 0 );
  grid2->addMultiCellWidget( filesystem, 0, 2, 1, 1, 0 );
  grid2->addMultiCellWidget( mount_misc, 3, 4, 1, 1, 0 ); 

  grid2->addMultiCell( spacer2, 11, 11, 0, 1 );

  addTab( mount_tab, "mount" );

  //
  // Tab for smbclient options.
  //
  QWidget *smbclient_tab = new QWidget( this, "SambaSmbclientTab" );
  QGridLayout *grid3 = new QGridLayout( smbclient_tab );
  grid3->setSpacing( 10 );

  QGroupBox *smbclient_misc = new QGroupBox( 2, Qt::Horizontal, i18n( "Miscellaneous" ), smbclient_tab );
  smbclient_misc->setInsideSpacing( 10 );

  new QLabel( i18n( "Resolve order:" ), smbclient_misc );
  m_resolve = new KLineEdit( QString::null, smbclient_misc );

  new QLabel( i18n( "Buffer size:" ), smbclient_misc );
  m_buffer = new KIntNumInput( smbclient_misc );
  m_buffer->setMinValue( 0 );
  m_buffer->setValue( 65520 );
  m_buffer->setSuffix( " Bytes" );
  
  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid3->addWidget( smbclient_misc, 0, 0, 0 );
  grid3->addItem( spacer3, 1, 0 );
  
  addTab( smbclient_tab, "smbclient" );
  
  //
  // Tab for nmblookup options.
  //
  QWidget *w4 = new QWidget( this, "SambaNmblookupTab" );
  QGridLayout *w4grid = new QGridLayout( w4 );
  w4grid->setSpacing( 10 );
  
  QGroupBox *w4box1 = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), w4 );
  w4box1->setInsideSpacing( 10 );

  QWidget *w4w1 = new QWidget( w4box1 );
  QGridLayout *w4w1g = new QGridLayout( w4w1 );
  w4w1g->setSpacing( 10 );
    
  QLabel *domainLabel = new QLabel( w4w1 );
  domainLabel->setText( i18n( "SMB domain (workgroup):" ) );
  m_domain = new KLineEdit( QString::null, w4w1 );

  QLabel *broadcastLabel = new QLabel( w4w1 );
  broadcastLabel->setText( i18n( "Broadcast address:" ) );
  m_broadcast = new KLineEdit( QString::null, w4w1 );
    
  w4w1g->addWidget( domainLabel, 0, 0, 0 );
  w4w1g->addWidget( m_domain, 0, 1, 0 );
  w4w1g->addWidget( broadcastLabel, 1, 0, 0 );
  w4w1g->addWidget( m_broadcast, 1, 1, 0 );
  
  m_udp = new QCheckBox( i18n( "Try and bind to UDP port 137 to send and receive UDP datagrams." ), w4box1 );
  
  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  w4grid->addWidget( w4box1, 0, 0, 0 );
  w4grid->addItem( spacer4, 1, 0 );  
  
  addTab( w4, "nmblookup" );
}


Smb4KSambaOptions::~ Smb4KSambaOptions()
{
}


#include "smb4ksambaoptions.moc"
