/***************************************************************************
                          smb4ksuperuseroptions  -  description
                             -------------------
    begin                : Sa Okt 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4ksuperuseroptions.h"
#include "../smb4k.h"


Smb4KSuperUserOptions::Smb4KSuperUserOptions( QWidget *parent, const char *name )
: QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );
  
  QButtonGroup *suid_progs = new QButtonGroup( 1, QGroupBox::Horizontal, i18n( "Programs" ), this, "SUIDPrograms" );
  suid_progs->setInsideMargin( 10 );
  new QLabel( i18n( "Use the following program to gain super user privileges:" ), suid_progs );
  m_super = new QRadioButton( i18n( "super (recommended)" ), suid_progs, "SuperButton" );
  m_super->setChecked( true );
  m_sudo = new QRadioButton( i18n( "sudo" ), suid_progs, "SudoButton" );
  
  QButtonGroup *suid_actions = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Actions" ), this, "SUIDActions" );
  m_unmount_dead = new QCheckBox( i18n( "Use super user privileges to force the unmounting of (broken) shares.\n(Requires Linux kernel 2.4.11 or later.)" ), suid_actions );
  m_use_suid = new QCheckBox( i18n( "Use super user privileges to mount and unmount shares." ), suid_actions );
  
  QWidget *remove_widget = new QWidget( suid_actions );
  QGridLayout *grid1 = new QGridLayout( remove_widget );
  m_remove = new KPushButton( i18n( "Remove Entries" ), remove_widget );
  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Preferred );
  grid1->addItem( spacer1, 0, 0 );  
  grid1->addWidget( m_remove, 0, 1, 0 );
  
  QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  grid->addWidget( suid_progs, 0, 0, 0 );
  grid->addWidget( suid_actions, 1, 0, 0 );
  grid->addItem( spacer, 2, 0 );
}


Smb4KSuperUserOptions::~Smb4KSuperUserOptions()
{
}

#include "smb4ksuperuseroptions.moc"
