/*
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
using std::cerr;
using std::endl;

#include "preferences.h"

#include <string.h>

#ifdef NEED_GNOMESUPPORT_H
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#else
#include "gnome-stubs.h"
#endif

/** The global prefs object.
    
    It is accessible to other classes via the getInstance method.
*/

Preferences *Preferences::instance = NULL;

/** Singleton getInstance method. Standard pattern followed, non threadsafe
	but not required (at the moment) since it gets called before any threading
	is activated. Keep an eye on it though.

	\returns the single instance of Preferences.
*/

Preferences &Preferences::getInstance() {
	if ( instance == NULL )
		instance = new Preferences;
	return *instance;
}

/** The constructor loads the user preferences.

    Since this uses gnome-config, preferences are typically
    loaded from ~/.gnome/kino.
*/
Preferences::Preferences() {
    gchar key[256];
    gchar *tempString;

	//cout << "Preferences constructed" << endl;
    gnome_config_push_prefix("/kino/general/");

    tempString = gnome_config_get_string("file=capture");
    if (tempString) {
        strncpy( file, tempString, 511);
        g_free(tempString);
    }
    defaultNormalisation = gnome_config_get_int("defaultNormalisation=0");
    defaultAudio = gnome_config_get_int("defaultAudio=0");
    defaultAspect = gnome_config_get_int("defaultAspect=0");
    g_snprintf( key, 255, "fileFormat=%d", AVI_DV1_FORMAT);
    fileFormat = gnome_config_get_int(key);
    autoSplit = gnome_config_get_bool("autoSplit=true");
    timeStamp = gnome_config_get_bool("timeStamp=false");
    frames = gnome_config_get_int("frames=7000");
    every = gnome_config_get_int("every=1");
    interface = gnome_config_get_int("interface=0");
    channel = gnome_config_get_int("channel=63");
	phyID = -1;
	tempString = gnome_config_get_string("avcGUID=");
    if (tempString) {
        strncpy( avcGUID, tempString, 64);
        g_free(tempString);
    }
    g_snprintf( key, 255, "displayMode=%d", DISPLAY_XV);
    displayMode = gnome_config_get_int(key);
    displayQuality = gnome_config_get_float("displayQuality=2");
    displayFixed = gnome_config_get_bool("displayFixed=false");
    enableAudio = gnome_config_get_bool("enableAudio=true");
    cip_n = gnome_config_get_int("cip_increment=0");
    cip_d = gnome_config_get_int("cip_threshold=0");
    syt_offset = gnome_config_get_int("syt_offset=19000");
    preview_capture = gnome_config_get_bool("preview_capture=false");
    dropFrame = gnome_config_get_bool("dropFrame=true");
    tempString = gnome_config_get_string("audioDevice=/dev/dsp");
    if (tempString) {
        strncpy( audioDevice, tempString, 254);
        g_free(tempString);
    }
    enableJogShuttle = gnome_config_get_bool("enableJogShuttle=false");
    tempString = gnome_config_get_string("jogShuttleDevice=/dev/input/event0");
    if (tempString) {
        strncpy( jogShuttleDevice, tempString, 254);
        g_free(tempString);
    }
	enableV4L = gnome_config_get_bool( "enableV4L=false" );
	disableKeyRepeat = gnome_config_get_bool( "disableKeyRepeat=false");
	audioRendering = gnome_config_get_int( "audioRendering=0" );
	previewRendering = gnome_config_get_int( "previewRendering=1" );
	enableTimecode = gnome_config_get_bool( "enableTimecode=false" );
	maxUndos = gnome_config_get_int( "maxUndos=50" );
	tempString = gnome_config_get_string("video1394Device=/dev/video1394");
    if (tempString) {
        strncpy( video1394Device, tempString, 254);
        g_free(tempString);
    }
	dvCaptureBuffers = gnome_config_get_int( "dvCaptureBuffers=50" );
	dvExportBuffers = gnome_config_get_int( "dvExportBuffers=10" );
	dvDecoderAddNTSCSetup = gnome_config_get_bool( "dvDecoderAddNTSCSetup=false" );
	dvDecoderClampLuma = gnome_config_get_bool( "dvDecoderClampLuma=true" );
	dvDecoderClampChroma = gnome_config_get_bool( "dvDecoderClampChroma=true" );
	maxFileSize = gnome_config_get_int( "maxFileSize=2000" );
	audioScrub = gnome_config_get_bool( "audioScrub=false" );
  	tempString = gnome_config_get_string( "v4lVideoDevice=/dev/video0" );
    if (tempString) {
        strncpy( v4lVideoDevice, tempString, 254);
        g_free(tempString);
    }
	tempString = gnome_config_get_string( "v4lAudioDevice=/dev/dsp" );
    if (tempString) {
        strncpy( v4lAudioDevice, tempString, 254);
        g_free(tempString);
    }
	tempString = gnome_config_get_string( "v4lInput=PAL" );
    if (tempString) {
        strncpy( v4lInput, tempString, 31);
        g_free(tempString);
    }
	tempString = gnome_config_get_string( "v4lAudio=32000" );
    if (tempString) {
        strncpy( v4lAudio, tempString, 31);
        g_free(tempString);
    }
    isOpenDML = gnome_config_get_bool( "isOpenDML=false" );
	tempString = gnome_config_get_string( "defaultDirectory=~/" );
    if (tempString) {
        strncpy( defaultDirectory, tempString, 254);
        g_free(tempString);
    }
    deinterlacePreview = gnome_config_get_bool( "deinterlacePreview=false" );
    relativeSave = gnome_config_get_bool( "relativeSave=false" );

    gnome_config_pop_prefix();
}

/** Save the user preferences.
*/

/// Save the user preferences.
void
Preferences::Save() {
#ifdef NEED_GNOME_SUPPORT_H
    gnome_config_push_prefix("/kino/general/");

    gnome_config_set_int("defaultNormalisation", defaultNormalisation);
    gnome_config_set_int("defaultAudio", defaultAudio);
    gnome_config_set_int("defaultAspect", defaultAspect);
    gnome_config_set_string( "file", file);
    gnome_config_set_int("fileFormat", fileFormat);
    gnome_config_set_bool("autoSplit", autoSplit);
    gnome_config_set_bool("timeStamp", timeStamp);
    gnome_config_set_int("frames", frames);
    gnome_config_set_int("every", every);
    gnome_config_set_int("interface", interface);
    gnome_config_set_int("channel", channel);
	gnome_config_set_string("avcGUID", avcGUID);
    gnome_config_set_int("displayMode", displayMode);
    gnome_config_set_float("displayQuality", displayQuality);
    gnome_config_set_bool("displayFixed", displayFixed);
    gnome_config_set_bool("enableAudio", enableAudio);
    gnome_config_set_int("cip_increment", cip_n);
    gnome_config_set_int("cip_threshold", cip_d);
    gnome_config_set_int("syt_offset", syt_offset);
    gnome_config_set_bool("preview_capture", preview_capture);
    gnome_config_set_bool("dropFrame", dropFrame);
    gnome_config_set_string("audioDevice", audioDevice);
    gnome_config_set_bool("enableJogShuttle", enableJogShuttle);
    gnome_config_set_string("jogShuttleDevice", jogShuttleDevice);
    gnome_config_set_bool("enableV4L", enableV4L);
    gnome_config_set_bool("disableKeyRepeat", disableKeyRepeat);
    gnome_config_set_int("audioRendering", audioRendering);
    gnome_config_set_int("previewRendering", previewRendering);
    gnome_config_set_bool("enableTimecode", enableTimecode);
    gnome_config_set_int("maxUndos", maxUndos);
	gnome_config_set_string("video1394Device", video1394Device);
	gnome_config_set_int("dvCaptureBuffers", dvCaptureBuffers);
	gnome_config_set_int("dvExportBuffers", dvExportBuffers);
	gnome_config_set_bool("dvDecoderAddNTSCSetup", dvDecoderAddNTSCSetup);
	gnome_config_set_bool("dvDecoderClampLuma", dvDecoderClampLuma);
	gnome_config_set_bool("dvDecoderClampChroma", dvDecoderClampChroma);
	gnome_config_set_int("maxFileSize", maxFileSize);
	gnome_config_set_bool("audioScrub", audioScrub);
	gnome_config_set_string("v4lVideoDevice", v4lVideoDevice);
	gnome_config_set_string("v4lAudioDevice", v4lAudioDevice);
	gnome_config_set_string("v4lInput", v4lInput);
	gnome_config_set_string("v4lAudio", v4lAudio);
    gnome_config_set_bool("isOpenDML", isOpenDML);
	gnome_config_set_string("defaultDirectory", defaultDirectory);
    gnome_config_set_bool("deinterlacePreview", deinterlacePreview);
    gnome_config_set_bool("relativeSave", relativeSave);
    gnome_config_pop_prefix();

    gnome_config_sync();
#endif
}


/// Provide access to the audioDevice propery from C modules.
gchar *Preferences_getAudioDevice(void)
{
    return Preferences::getInstance().audioDevice;
}

