#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "debug.h"
#include "vsprintf.h"

void Debug::Open()
{
#ifdef DEBUG
     if (!str.is_open() && name != "") str.open(name.c_str());
#endif
}

void Debug::Log(int level, const char *msg, ...)
{
    Open();
    if (!str.is_open()) return;
    
    char buf[MAX_LOG_LINE_LEN];
    va_list args;

    va_start(args, msg);
    VSPRINTF(buf, sizeof(buf)-1, msg, args);
    va_end(args);

    str << buf << std::endl;
}


