/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_LAME

#include "../player.h"
#include "../audio.h"
#include "graphic.h"
#include "../other.h"

void
on_lame_show_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkWidget *quality;
  GtkWidget *bitrate;
  GtkWidget *channels;
  GtkWidget *lowpass;
  GtkWidget *highpass;
  GtkWidget *file;

  audio *ao = (audio *) user_data;
  audio_data_lame *lame;
  char s[SIZE_BUFFER];

  if (!ao)
    return;

  lame = ao->data;
  if (!lame)
    return;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - mp3 configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT,
				 GTK_STOCK_SAVE, 100,
				 GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  rate = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", lame->rate);
  gtk_entry_set_text (GTK_ENTRY (rate), s);
  gtk_entry_set_editable (GTK_ENTRY (rate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Quality:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  quality = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", lame->quality);
  gtk_entry_set_text (GTK_ENTRY (quality), s);
  gtk_entry_set_editable (GTK_ENTRY (quality), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), quality, 1, 2, 1, 2);

  label = gtk_label_new_with_mnemonic (_("Bitrate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  bitrate = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", lame->bitrate);
  gtk_entry_set_text (GTK_ENTRY (bitrate), s);
  gtk_entry_set_editable (GTK_ENTRY (bitrate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  label = gtk_label_new_with_mnemonic (_("Channels:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  channels = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%s", lame->channels == 1 ? "MONO" : "STEREO");
  gtk_entry_set_text (GTK_ENTRY (channels), s);
  gtk_entry_set_editable (GTK_ENTRY (channels), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 3, 4);

  label = gtk_label_new_with_mnemonic (_("LowPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  lowpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", lame->lowpass);
  gtk_entry_set_text (GTK_ENTRY (lowpass), s);
  gtk_entry_set_editable (GTK_ENTRY (lowpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), lowpass, 1, 2, 4, 5);

  label = gtk_label_new_with_mnemonic (_("HighPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  highpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", lame->highpass);
  gtk_entry_set_text (GTK_ENTRY (highpass), s);
  gtk_entry_set_editable (GTK_ENTRY (highpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), highpass, 1, 2, 5, 6);

  label = gtk_label_new_with_mnemonic (_("File Output:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
  file = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (file), lame->file);
  gtk_entry_set_editable (GTK_ENTRY (file), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), file, 1, 2, 6, 7);

  gtk_widget_show_all (box);

  while (1)
    {
      if (gtk_dialog_run (GTK_DIALOG (dialog)) == 100)
	{
	  char s[1024];
	  char *file;

	  snprintf (s, 1024, "%s %s - Save Mp3 config file", NAME, VERSION);

	  if((file=file_chooser(s, GTK_SELECTION_SINGLE, GTK_FILE_CHOOSER_ACTION_SAVE))) {
	      FILE *fl;

	      if (dialog_test_file (file))
		{
		  free (file);
		  continue;
		}

	      if (!(fl = fopen (file, "w")))
		{
		  msg_error ("I can't open %s", file);
		  free (file);
		  continue;
		}

	      fprintf (fl, "type = M\n");
	      fprintf (fl, "rate = %d\n", lame->rate);
	      fprintf (fl, "quality = %d\n", lame->quality);
	      fprintf (fl, "bitrate = %d\n", lame->bitrate);
	      fprintf (fl, "channels = %d\n", lame->channels);
	      fprintf (fl, "lowpass = %d\n", lame->lowpass);
	      fprintf (fl, "highpass = %d\n", lame->highpass);
	      fprintf (fl, "file = \"%s\"\n", lame->file);
	      fclose (fl);
	      free (file);

	      dialog_msg (_("Mp3 config saved!"));
	    }

	  continue;
	}
      else
	break;
    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
