/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "graphic.h"
#include "../other.h"
#include "../admin.h"

struct admin_s
{
  GtkWidget *u;
  GtkWidget *t;
} admin;

static GtkWidget *trimming_win = NULL;

void tools_trimming_close (GtkWidget *, gpointer);
void tools_trimming_trimming (GtkWidget *, gpointer);
admin_data *admin_configure (void);
void admin_tcp (GtkWidget *, gpointer);
void admin_unix (GtkWidget *, gpointer);

void
on_trimming_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *frame;
  GtkWidget *button;

  char s[SIZE_BUFFER];

  if (trimming_win)
    return;

  trimming_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf (s, _("%s %s - Silence Trimming Window"), NAME, VERSION);
  gtk_window_set_title (GTK_WINDOW (trimming_win), s);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (trimming_win), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 8);

  button = gtk_toggle_button_new_with_label ("Silence Trim!");
  gtk_widget_show (button);
  gtk_container_add (GTK_CONTAINER (frame), button);

  if (play->trimming)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);

  g_signal_connect ((gpointer) button, "toggled",
		    G_CALLBACK (tools_trimming_trimming), NULL);

  gtk_widget_show (trimming_win);

  g_signal_connect ((gpointer) trimming_win, "delete_event",
		    G_CALLBACK (tools_trimming_close), NULL);
}

void
tools_trimming_close (GtkWidget * w, gpointer dummy)
{
  gtk_widget_destroy (trimming_win);
  trimming_win = NULL;
}

void
tools_trimming_trimming (GtkWidget * w, gpointer dummy)
{
  if (play->trimming)
    play->trimming = 0;
  else
    play->trimming = 1;
}

void
on_admin_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) ==
      FALSE)
    {
      if (!play->admin)
	return;

      play->admin_active = 0;
      pthread_join (play->admin->th, NULL);

      if (play->admin->interface)
	free (play->admin->interface);
      if (play->admin->socket)
	free (play->admin->socket);

      free (play->admin);
      play->admin = NULL;
    }
  else
    {
      if ((play->admin = admin_configure ()))
	{
	  play->admin_active = 1;
	  if (admin_start ())
	    {
	      if (play->admin->interface)
		free (play->admin->interface);
	      if (play->admin->socket)
		free (play->admin->socket);

	      free (play->admin);
	      play->admin = NULL;
	      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menuitem),
					      FALSE);
	    }
	}
      else
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menuitem),
					FALSE);

    }
}

admin_data *
admin_configure (void)
{
  admin_data *data = NULL;

  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *box_unix;
  GtkWidget *table_tcp;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *socket;
  GtkWidget *interface;
  GtkWidget *port;

  GSList *group = NULL;
  GtkWidget *radiobutton;

  char buf[1024];
  char *txt;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - Admin Interface"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_vbox_new (FALSE, 8);
  gtk_widget_show (box);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Unix Socket"));
  gtk_widget_show (radiobutton);
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);

  box_unix = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box_unix);
  gtk_container_add (GTK_CONTAINER (frame), box_unix);

  admin.u = box_unix;
  g_signal_connect ((gpointer) radiobutton, "toggled",
		    G_CALLBACK (admin_unix), NULL);

  label = gtk_label_new (_("Socket File: "));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box_unix), label, FALSE, FALSE, 0);

  socket = gtk_entry_new ();
  gtk_widget_show (socket);
  gtk_box_pack_start (GTK_BOX (box_unix), socket, TRUE, TRUE, 0);
  snprintf (buf, 1024, "%s/somaplayer-%d.sock", (char *) g_get_tmp_dir (),
	    getpid ());
  gtk_entry_set_text (GTK_ENTRY (socket), buf);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Tcp Socket"));
  gtk_widget_show (radiobutton);
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), FALSE);

  table_tcp = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table_tcp);
  gtk_container_add (GTK_CONTAINER (frame), table_tcp);

  admin.t = table_tcp;
  g_signal_connect ((gpointer) radiobutton, "toggled", G_CALLBACK (admin_tcp),
		    NULL);

  label = gtk_label_new (_("Interface: "));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 0, 1, GTK_FILL,
		    GTK_FILL, 0, 0);

  interface = gtk_entry_new ();
  gtk_widget_show (interface);
  gtk_table_attach (GTK_TABLE (table_tcp), interface, 1, 2, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_entry_set_text (GTK_ENTRY (interface), "0.0.0.0");

  label = gtk_label_new (_("Port: "));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 1, 2, GTK_FILL,
		    GTK_FILL, 0, 0);

  port = gtk_entry_new ();
  gtk_widget_show (port);
  gtk_table_attach (GTK_TABLE (table_tcp), port, 1, 2, 1, 2,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  snprintf (buf, 1024, "%d", ADMIN_PORT);
  gtk_entry_set_text (GTK_ENTRY (port), buf);

  gtk_widget_show_all (box);

  gtk_widget_set_sensitive (admin.t, FALSE);
  gtk_widget_set_sensitive (admin.u, TRUE);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton)) ==
	  TRUE)
	{
	  if (!(data = (admin_data *) malloc (sizeof (admin_data))))
	    fatal (_("Error: memory."));
	  memset (data, 0, sizeof (admin_data));

	  txt = (char *) gtk_entry_get_text (GTK_ENTRY (interface));
	  if (!*txt || strcmp (txt, "0.0.0.0"))
	    data->interface = NULL;
	  else
	    data->interface = strdup (txt);

	  data->port = atoi (gtk_entry_get_text (GTK_ENTRY (port)));

	  data->type = SOCKET_TCP;
	}
      else
	{
	  if (!(data = (admin_data *) malloc (sizeof (admin_data))))
	    fatal (_("Error: memory."));
	  memset (data, 0, sizeof (admin_data));

	  txt = (char *) gtk_entry_get_text (GTK_ENTRY (socket));
	  if (!*txt)
	    data->socket = NULL;
	  else
	    data->socket = strdup (txt);

	  data->type = SOCKET_UNIX;
	}
    }

  gtk_widget_destroy (dialog);

  return data;
}

void
admin_unix (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (admin.t, FALSE);
  gtk_widget_set_sensitive (admin.u, TRUE);
}

void
admin_tcp (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (admin.u, FALSE);
  gtk_widget_set_sensitive (admin.t, TRUE);
}

void
on_realtime_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) ==
      FALSE)
    play->norealtime = 1;
  else
    play->norealtime = 0;
}

/* EOF */
