///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: AbstractPhraseBuilder.h,v 1.2 2003/10/24 15:59:34 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _AbstractPhraseBuilder_h
#define _AbstractPhraseBuilder_h

class AbstractPhraseBuilder
{
public:
  virtual ~AbstractPhraseBuilder()
  {
  }

  virtual void setMinWords(int value) = 0;

  virtual void setMaxWords(int value) = 0;

  virtual void setMaxChars(int value) = 0;

  virtual int getMinWords() = 0;

  virtual int getMaxWords() = 0;

  virtual int getWordCount() const = 0;

  virtual void addWord(const string &word) = 0;

  virtual const char *getPhrase(int num_words) = 0;

  virtual void clear() = 0;
};

#endif // _AbstractPhraseBuilder_h
